/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  mouse event handling.
*/

#include "xdisplayP.h"
#include "prototyping.h"


extern int body_mode;

Boolean button1_flag=False;
Boolean prompt_flag=False;
int zoom_box=0;

static void moving_button1(XEvent*, long);

/*
  This function handles all
  pushed mouse button events.
*/
void button_pushEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch )	/* RJM: added 4th arg */
{
  long id,id_anim;	/* RJM: handle 64-bit architectures */

  if (prompt_flag) return;

				/* Record a button1 event. */
  if (event->xbutton.button==Button1) 
    button1_flag=True;

  id=(long)client_data;
  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Update the record, trace, etc...  */
  pick_meter(event,id,id_anim);

				/* Check mode. */
  switch (xdisplay[id].mode) { 
  case 0: start_zoom(event); zoom_box=1; break;
  case 1: pick_button(event,id,id_anim); break;
  case 2: select_segment(event,id,id_anim); break;
  case 3: move_pick(event,id,id_anim); break;
  case 4: add_pick(event,id,id_anim); break;
  case 5: delete_pick(event,id,id_anim); break;
  case 6: split_segment(event,id,id_anim); break;
  case 7: join_segments(event,id,id_anim); break;
  case 8: start_moving_segment(event,id,id_anim); break;
  case 9: round_picks(event,id,id_anim); break;
  case 10: round_picks(event,id,id_anim); break;
  case 11: round_picks(event,id,id_anim); break;
  case 12: break;     /* NULL operation. Use to be squish mode. */
  case 14: set_position_label(event,id); break;
  case 15: round_picks_side(event,id,id_anim); break;
  case 16: round_picks_side(event,id,id_anim); break;
  case 29: round_picks_side(event,id,id_anim); break;
  case 30: round_picks_side(event,id,id_anim); break;
  case 17: pick_button(event,id,id_anim); 
    xdisplay[id].mode=17; 
    set_mode_label(17,id);
    break;
  case 18:
    if (changed_picks) {
      regenerateCB((Widget)NULL,(XtPointer)id,0); 
      changed_picks=False;
    }
    if (event->xbutton.button==Button1) 
      switch (body_mode) {
      case 0:
	select_body(event,id); break;
      case 1:
	set_vel(event,1);
	update_par(id);
	break;
      case 2:
	set_xy(event,id,1);
	update_par(id);
	break;
      case 3:
	set_vxy(event,id,1);
	update_par(id);
	break;
      case 5:
	set_vel(event,2);
	update_par(id);
	break;
      case 6:
	set_xy(event,id,2);
	update_par(id);
	break;
      case 7:
	set_vxy(event,id,2);
	update_par(id);
	break;
      }
    if (event->xbutton.button==Button2) 
      undo_velCB(0,(XtPointer)id,0);
    if (event->xbutton.button==Button3) 
      update_velCB(0,(XtPointer)id,0);
    break;
  case 21: delete_segment(event,id,id_anim); break;
  case 22: duplicate_segment(event,id,id_anim); break;
  case 23: refine_segment(event,id,id_anim); break;
  case 24: label_segment(event,id,id_anim); break;
  case 25: color_segment(event,id,id_anim); break;
  case 26: break;		/* print mode. */
  case 27: single_pick_button(event,id); break;
  case 28: paint_button(event,id); break; /* Velocity Paint */
  }
}



/*
  This function handles all
  released mouse button events.
*/
void button_releaseEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch ) /* RJM: added 4th arg */
{
  long id,id_anim;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;

  if (prompt_flag)
    return;

  if (event->xbutton.button==Button1) 
    button1_flag=False;

  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id=animate_list[step_count];

				/* Update the record, trace, etc...  */
  pick_meter(event,id,id_anim);


  switch (xdisplay[id].mode) { 
  case 0: end_zoom(w,event,id,0); zoom_box=0; break;
  }
}



/*
  This function handles all
  mouse movement events.
*/
void moving_mouseEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch ) /* RJM: added 4th arg */
{
  long id,id_anim;	/* RJM: handle 64-bit architectures */

  id=(long)client_data;
  id_anim=id;

  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Update the record, trace, etc...  */
  pick_meter(event,id,id_anim);

				/* Check if button1 is pressed. */
  if (button1_flag) {
    moving_button1(event,id);
    return;
  }

				/* Check mode. */
  switch (xdisplay[id].mode) { 
  case 1: moving_pick(event,id,id_anim); break;
  case 2: moving_pick(event,id,id_anim); break;
  case 4: moving_add_pick(event,id,id_anim); break;
  case 14: position_label(event,id); break;
  case 17: moving_pick(event,id,id_anim); break;
  case 28: moving_paint(event,id); break;
  }
}


/*
  This function handles all
  mouse movement events with
  button1 held down.
*/
static void moving_button1(XEvent *event, long id)/* RJM: handle 64-bit architectures */
{
  long id_anim;

  if (prompt_flag) return;

  id_anim=id;
  if (strcmp(xdisplay[id].filename,"Animation")==0)
    id_anim=animate_list[step_count];

				/* Check mode. */
  switch (xdisplay[id].mode) { 
  case 0: box_zoom(event,id); break;
  case 3: moving_pick_point(event,id,id_anim); break;
  case 8: moving_segment(event,id,id_anim); break;
  case 9: box_zoom(event,id); break;
  case 10: box_zoom(event,id); break;
  case 11: box_zoom(event,id); break;
  case 28: paint(event,id); break; /* Velocity Paint */
  }
}
