/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  overlaying wiggles on seismic data.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern int window_list[MAX_IMAGES],list_count;

static void overlay_image(long, long);

/*
  This function creates the window to
  display the overlays the wiggles
  on a seimic image.
*/
void overlayCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget wiggle_window;
  Widget main_window;
  Widget wiggle_form;
  int n,image_count;
  long id;	/* RJM: handle 64-bit architectures */
  int width_temp,height_temp;

  if (list_count<2)
    return;

  id=window_list[0];

  if (id==-1)
    return;

  image_count=next_image();
  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;
  XtSetArg(args[n],XtNdepth,screenDepth); n++;
/*wiggle_window=XtAppCreateShell("xsd","wiggle",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  wiggle_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(wiggle_window);

  copy_attributes(image_count,id);
  strcpy(xdisplay[image_count].type,"Overlay");

  width_temp=xdisplay[id].image->width;
  height_temp=xdisplay[id].image->height;

  raster[image_count]=(unsigned char *)malloc(width_temp*height_temp
					      *sizeof(char));

  memcpy((char *)raster[image_count],(char *)raster[id],width_temp*height_temp*sizeof(char));

  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],
					   width_temp,height_temp,screenDepth,0);

  for (n=1; n<list_count; n++) 
    overlay_image(image_count,window_list[n]);

  screen_size(id,&width_temp,&height_temp);

  main_window=XmCreateMainWindowVa(wiggle_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);

  strcpy(xdisplay[image_count].filename,xdisplay[id].filename);
  window_title(buf,image_count);

  XtVaSetValues(wiggle_window,
		XmNtitle,buf,
		NULL);

  wiggle_form=XmCreateFormVa(main_window,"form",
			     XmNwidth,width_temp,
			     XmNheight,height_temp+MIN_HEIGHT,
			     NULL);
  
                                /* Indicate general mode. */
  xdisplay[image_count].mode=1;
  set_mode_label(1,image_count);

  app_menus(wiggle_form,image_count,False);

  xdisplay_image(image_count,wiggle_window,wiggle_form,width_temp,height_temp);
  
  XtRealizeWidget(wiggle_window);
}


/*
  This function overlays the wiggles
  on a seimic image.
*/
static void overlay_image(long id, long id1)
{
  int x,y;

  for (y=0; y<xdisplay[id].image->height; y++)
    for (x=0; x<xdisplay[id].image->width; x++)
      if ((x < xdisplay[id1].image->width)&&(y < xdisplay[id1].image->height)) {
	if (xdisplay[id1].background!=*(raster[id1]+x+(y*xdisplay[id1].image->width)))
	  *(raster[id]+x+(y*xdisplay[id].image->width))=*(raster[id1]+x+(y*xdisplay[id1].image->width));
      }
}

