/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  painting a velocity model.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "ut_defs.h"
#include "io_defs.h"

extern Widget draw_vel;
extern char vel_dir[1024];
extern XtIntervalId time_out;

static Widget paint_window=NULL;
static Widget text_value=NULL;
static Widget text_size=NULL;
static Widget toggle_custom=NULL;
static Widget toggle_size[4];
static Widget text_paint[5];
static float paint_value=0.0;
static int size_x_old=0;
static int size_y_old=0;
Boolean paint_brush=False;
int paint_index=0;

void vel_paintCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget button;
  int root_x,root_y;
  ClientData *message;
  long id = (long)client_data;

  locate_cursor(&root_x,&root_y);

  dialog_form=XmCreateFormDialogVa(xdisplay[id].window,"form",
				   XmNdefaultPosition,False,
				   XmNx,root_x,
				   XmNy,root_y,
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,
					   XMstr("Velocity Builder Setup"),
				   XtNmanageChild,False,
				XmNallowShellResize, True,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"model_par2.help");
  
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNspacing,MAGIC_SPACING,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNtopOffset,15,
				    NULL);
  
  (void)XmCreateLabelVa(dialog_window,"Input Velocity Tape",NULL);
  (void)XmCreateLabelVa(dialog_window,"Horizontal Zoom",NULL);
  (void)XmCreateLabelVa(dialog_window,"Vertical Zoom",NULL);
  (void)XmCreateLabelVa(dialog_window,"Minimum Velocity",NULL);
  (void)XmCreateLabelVa(dialog_window,"Maximum Velocity",NULL);
  
  dialog_window=XmCreateRowColumnVa(dialog_form,"row_column",
				    XmNpacking,XmPACK_COLUMN,
				    XmNnumColumns,1,
				    XmNtopAttachment,XmATTACH_FORM,
				    XmNrightAttachment,XmATTACH_FORM,
				    XmNleftAttachment,XmATTACH_WIDGET,
				    XmNleftWidget,dialog_window,
				    NULL);
  
  text_paint[0]=XmCreateTextVa(dialog_window,"directory",
			       XmNvalue,xdisplay[id].filename,
			       XmNcolumns,50,
			       NULL);
  
  
  text_paint[1]=XmCreateTextVa(dialog_window,"min",
			       XmNvalue,"1",
			       XmNcolumns,10,
			       NULL);
  
  
  text_paint[2]=XmCreateTextVa(dialog_window,"max",
			       XmNvalue,"1",
			       XmNcolumns,10,
			       NULL);
  
  sprintf(buf,"%d",global_min);
  
  text_paint[3]=XmCreateTextVa(dialog_window,"min",
			       XmNvalue,buf,
			       XmNcolumns,10,
			       NULL);
  
  sprintf(buf,"%d",global_max);
  
  text_paint[4]=XmCreateTextVa(dialog_window,"max",
			       XmNvalue,buf,
			       XmNcolumns,10,
			       NULL);
  
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNleftAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,velocity_paintCB,message);
  
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,dialog_window,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNrightAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 
  
  XtManageChild(dialog_form);
}


void velocity_paintCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget main_window;
  ClientData *message=(ClientData *)client_data;
  Widget paint_form;
  int image_count,m,n,error,ntrc,nsmp,id,x,y;
  int width_temp,height_temp,width,height;
  float hor_zoom=1.0,ver_zoom=1.0;
  short temp;
  long tmp;
  char filename[1024],*str,*header;

  id=message->id;

  if (model_mode!=0) {
    error_message("You must first quit the velocity builder.");
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  if (paint_index!=0) {		/* If there is already an animation */
    if (xdisplay[paint_index].hide_flag) {
                                /* If window is hidden map it. */
      XtMapWidget(xdisplay[paint_index].window);
      xdisplay[paint_index].hide_flag=False;
    } else {
                                /* If window is not hidden unmap then map. */
      XtUnmapWidget(xdisplay[paint_index].window);
      XtMapWidget(xdisplay[paint_index].window);
    }
    if( message->w != NULL )
      XtDestroyWidget( message->w );
    free(message);
    return;
  }

  XtSetArg(args[0],XmNvalue,&str);	/* RJM: check for fn first! */
  XtGetValues(text_paint[0],args,1);
  if( (int)strlen( str ) == 0 )
  {
    XtFree(str);
    return;
  }
  strcpy(buf,str);
  XtFree(str);
  strcpy(vel_dir,buf);

  image_count=next_image();
  strcpy(xdisplay[image_count].filename,buf);

  paint_index=image_count;	/* Set flag indicating an animation
				   window is being displayed. */

  n=0;
  XtSetArg(args[n],XtNargc,savedArgc); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNargv,savedArgv); n++;     /* RJM: added 1/17/97 */
  XtSetArg(args[n],XtNiconPixmap,xsd_pixmap); n++;
  XtSetArg(args[n],XtNvisual,visual); n++;	/* RJM: added */
  XtSetArg(args[n],XtNdepth,screenDepth); n++;	/* RJM: added */
/*paint_window=XtAppCreateShell("xsd","paint",
                               topLevelShellWidgetClass,display,args,n);
RJM: commented out 1/17/97 */
  paint_window=XtAppCreateShell(ApplicationName, ApplicationClass,	/* RJM: added 1/17/97 */
                               topLevelShellWidgetClass,display,args,n);
  quit_frame(paint_window);

  copy_attributes(image_count,id);
  
  XtSetArg(args[0],XmNvalue,&str);
  XtGetValues(text_paint[1],args,1);
  sscanf(str,"%f",&hor_zoom);
  XtFree(str);
  XtGetValues(text_paint[2],args,1);
  sscanf(str,"%f",&ver_zoom);
  XtFree(str);

  XtGetValues(text_paint[3],args,1);
  sscanf(str,"%d",&global_min);
  XtFree(str);
  XtGetValues(text_paint[4],args,1);
  sscanf(str,"%d",&global_max);
  XtFree(str);

  if( strstr( ServerName, "dds" ) )
	if( !autoFormatDetectionWidget
	||  XmToggleButtonGetState( autoFormatDetectionWidget ) )
		amoco_detect_format();
	else
		specifyFormat( top_level, xdisplay[image_count].filename );

  error=amoco_check_server(buf);
  if (error==-1) {
#ifndef NO_TIME_OUT
    XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
    error_message(buf);
    error_message("Server error (10). Try restarting server.");
    return;
  }
  error=amoco_read_line_header(&header,xdisplay[image_count].filename);
  if (error < 0) {
    reportDSerror( error );

    if( paint_window ) {	/* RJM: added check */
/*    XtDestroyWidget(paint_window); RJM: deleting a paint window no longer
      calls the destroyCallback via xdisplay_image. Hence, do explicitly:
*/
      if( xdisplay[paint_index].window != paint_window )
          (void)fprintf( stderr, "xdisplay[%d].window(%x)!= paint_window(%x)\n",
                paint_index, xdisplay[paint_index].window, paint_window );
      tmp = paint_index;	/* int to long for 64-bit machines */
      delete_windowCB(NULL, (XtPointer)tmp, NULL );  /* RJM: added */
      paint_window=NULL;
    }
    paint_index=0;
    return;
  }
  if (error==2) {
    error_message("Cannot use velocity painter on disco data sets.");
    if( paint_window ) {	/* RJM: added check */
/*    XtDestroyWidget(paint_window); RJM: deleting a paint window no longer
      calls the destroyCallback via xdisplay_image. Hence, do explicitly:
*/
      if( xdisplay[paint_index].window != paint_window )
          (void)fprintf( stderr, "xdisplay[%d].window(%x)!= paint_window(%x)\n",
                paint_index, xdisplay[paint_index].window, paint_window );
      tmp = paint_index;	/* int to long for 64-bit machines */
      delete_windowCB(NULL, (XtPointer)tmp, NULL );  /* RJM: added */
      paint_window=NULL;
    }
    paint_index=0;
    return;
  }
  C_SAVER((int*)header,"NumTrc",&ntrc,0);
  C_SAVER((int*)header,"NumSmp",&nsmp,0);
  if(header)
    free(header);

				/* Set window attributes. */
  xdisplay[image_count].flip_flag=xdisplay[id].flip_flag;
  xdisplay[image_count].pick_x=1.0/hor_zoom;
  xdisplay[image_count].pick_y=1.0/ver_zoom;
  nrec[image_count]=1;
  ntrace[image_count]=ntrc;
  nsamp[image_count]=nsmp;
  srec[image_count]=1;
  erec[image_count]=1;
  irec[image_count]=1;
  strace[image_count]=1;
  etrace[image_count]=ntrc;
  itrace[image_count]=1;
  ssamp[image_count]=1;
  esamp[image_count]=nsmp;
  isamp[image_count]=1;

  scale_range(global_min,global_max,image_count); /* Set the color range. */

  width_temp=ntrc;
  height_temp=nsmp;
  width=ntrc*hor_zoom;
  height=nsmp*ver_zoom;

  raster[image_count]=(unsigned char *)malloc(width*height*sizeof(char));

  memset((char *)raster[image_count],(int)(white&0xffffffff),width*height*sizeof(char));

  traceH[image_count]=(unsigned char *)malloc(width_temp*256*sizeof(char));
  memcpy((char *)traceH[image_count],(char *)traceH[id],width_temp*256*sizeof(char));

  /* Read in the backdrop. */
  error=amoco_check_server(buf);
  if (error==-1) {
#ifndef NO_TIME_OUT
    XtRemoveTimeOut(time_out);  /* abort error dialog pop-up */
#endif
    error_message(buf);
    error_message("Server error (11). Try restarting server.");
    return;
  }
  if( vel_old )	/* RJM: added */
    free((char*)vel_old);
  vel_old=(unsigned short *)malloc(width_temp*height_temp*sizeof(unsigned short));
  if( vel_tape )	/* RJM: added */
    free((char*)vel_tape);
  vel_tape=(unsigned short *)malloc(width_temp*height_temp*sizeof(unsigned short));

  error=amoco_read_data((unsigned char *)vel_tape,traceH[image_count],
			xdisplay[image_count].filename,srec[image_count],
			erec[image_count],irec[image_count],
			strace[image_count],etrace[image_count],
			itrace[image_count],ssamp[image_count],
			esamp[image_count],isamp[image_count],
			4,0, 1.0, 0.0, 0,False,False);
  if (error < 0) {
    reportDSerror( error );
    return;
  }
  
  if (xdisplay[image_count].flip_flag) {
    for (m=0; m<height_temp; m++)
      for (n=0; n<(width_temp/2); n++) {
	temp=*(vel_tape+n+m*width_temp);
	*(vel_tape+n+m*width_temp)=*(vel_tape+(width_temp-n-1)+m*width_temp);
	*(vel_tape+(width_temp-n-1)+m*width_temp)=temp;
      }
  }
  
  memcpy((char *)vel_old,(char *)vel_tape,width_temp*height_temp*sizeof(unsigned short));

				/* Check if velocity tape was zoomed. */
  if ((hor_zoom==1.0)&&(ver_zoom==1.0))
    for (m=0; m<height_temp*width_temp; m++)
      *(raster[image_count]+m)=data_to_pixel(*(vel_tape+m),image_count)&0xffffffff;
  else
    for (y=0; y<height; y++)
      for (x=0; x<width; x++)
        *(raster[image_count]+x+y*width)=
		data_to_pixel(*(vel_tape+(int)(x/hor_zoom)+(int)(y/ver_zoom)
					*width_temp),image_count) & 0xffffffff;

  xdisplay[image_count].image=XCreateImage(display,visual,screenDepth,ZPixmap,
                                           0,(char *)raster[image_count],width,
                                           height,screenDepth,0);

  screen_size(id,&width,&height); /* Find best screen size. */

				/* Mark window as a Model. */
  strcpy(xdisplay[image_count].type,"Paint");
  window_title(buf,image_count);
  
  XtVaSetValues(paint_window,
		XmNtitle,buf,
		NULL);

  main_window=XmCreateMainWindowVa(paint_window,"child_form",
				   XmNshowSeparator,True,
				   NULL);
  paint_form=XmCreateFormVa(main_window,"main",
			    XmNwidth,width,
			    XmNheight,height+MIN_HEIGHT,
			    NULL);
  
				/* Indicate model mode. */
  xdisplay[image_count].mode=28;
  set_mode_label(18,image_count);

				/* Create drop-down menus. */
  paint_menus(main_window,paint_form,image_count,0);

				/* Create image. */
  xdisplay_image(image_count,paint_window,paint_form,width,height);

  XtRealizeWidget(paint_window);

                                /* The enviroment variable XSD_DIR
                                   contains the path to the color files. */

  /* DWN 10/19/97 change XSD_DIR to XSD_COLOR_DIR */

  if (getenv("XSD_COLOR_DIR")==NULL) {
    error_message("Error reading color file.");
    return;
  }
 
                                /* Get path of the color files. */
  strcpy(filename,getenv("XSD_COLOR_DIR"));
/* DWN 10/19/97
  strcat(filename,"color/velocity");
*/
  strcat(filename,"velocity");
  load_color(image_count);
  load_color_file(filename,image_count);

  tmp = image_count;	/* int to long for 64-bit machines */
  XtAddCallback(draw_vel,XmNexposeCallback,expose_velCB,(XtPointer)tmp);

  XtAddEventHandler(draw_vel,ButtonPressMask,False,button_push_velEH,(XtPointer)tmp);
  XtAddEventHandler(draw_vel,ButtonReleaseMask,False,button_release_velEH,(XtPointer)tmp);
  XtAddEventHandler(draw_vel,PointerMotionMask,False,moving_mouse_velEH,(XtPointer)tmp);

  XmUpdateDisplay(paint_window);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


void paint_brushCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget dialog_window;
  Widget label;
  Widget button;
  long id = (long)client_data;
 
  if (paint_brush)
    return;

  paint_brush=True;

  dialog_form=XmCreateFormDialogVa(xdisplay[paint_index].window,"form",
		XmNmarginHeight,10,
		XmNmarginWidth,10,
		XmNdeleteResponse,XmDO_NOTHING,
		XmNdialogTitle,XMstr("Paint Brush"),
		XtNmanageChild,False,
		NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"model_par.help");
  
  label=XmCreateLabelVa(dialog_form,"Brush Size",
			XmNleftAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_FORM,
			XmNtopOffset,15,
			NULL);
  
  dialog_window=XmCreateRadioBoxVa(dialog_form,"row_column",
				   XmNpacking,XmPACK_COLUMN,
				   XmNnumColumns,1,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNtopAttachment,XmATTACH_WIDGET,
				   XmNtopWidget,label,
				   NULL);
  
  toggle_size[0]=XmCreateToggleButtonVa(dialog_window,"Pixel  1 Pixel",NULL);
  toggle_size[1]=XmCreateToggleButtonVa(dialog_window,"Small  2 Pixels",NULL);
  toggle_size[2]=XmCreateToggleButtonVa(dialog_window,"Medium 3 Pixels",NULL);
  toggle_size[3]=XmCreateToggleButtonVa(dialog_window,"Large  4 Pixels",NULL);
  
  XmToggleButtonSetState(toggle_size[0],True,False);
  XmToggleButtonSetState(toggle_size[1],False,False);
  XmToggleButtonSetState(toggle_size[2],False,False);
  XmToggleButtonSetState(toggle_size[3],False,False);
  
  toggle_custom=XmCreateToggleButtonVa(dialog_form,"Custom Brush Size",
				       XmNtopAttachment,XmATTACH_WIDGET,
				       XmNtopWidget,dialog_window,
				       XmNtopOffset,15,
				       XmNleftAttachment,XmATTACH_FORM, 
				       NULL);
  XmToggleButtonSetState(toggle_custom,False,False);
  
  text_size=XmCreateTextVa(dialog_form,"text",
			   XmNtopAttachment,XmATTACH_WIDGET,
			   XmNtopWidget,dialog_window,
			   XmNtopOffset,10,
			   XmNleftAttachment,XmATTACH_WIDGET, 
			   XmNleftWidget,toggle_custom,
			   XmNcolumns,3,
			   NULL);
  
  label=XmCreateLabelVa(dialog_form,"Brush Value",
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,text_size,
			XmNtopOffset,25,
			XmNleftAttachment,XmATTACH_FORM, 
			NULL);
  
  sprintf(buf,"%d",global_min);
  
  text_value=XmCreateTextVa(dialog_form,"text",
			    XmNvalue,buf,
			    XmNtopAttachment,XmATTACH_WIDGET,
			    XmNtopWidget,text_size,
			    XmNtopOffset,20,
			    XmNleftAttachment,XmATTACH_WIDGET, 
			    XmNleftWidget,label,
			    XmNcolumns,10,
			    XmNrightAttachment,XmATTACH_FORM, 
			    NULL);
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,label,
			      XmNtopOffset,20,
			      XmNbottomAttachment,XmATTACH_FORM, 
			      XmNrightAttachment,XmATTACH_FORM, 
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form); 
  XtAddCallback(button,XmNactivateCallback,reset_flagCB,&paint_brush); 
  
  XtManageChild(dialog_form);
  
  /* set to prevent flashing between this and painter window */
  XSetWindowColormap(display,XtWindow(XtParent(dialog_form)),xdisplay[id].cmap);
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  /* flashing does not occur on SGI */
#endif
}


void paint(XEvent *event, int id)
{
  int x,y,paint_size;
  int x1,y1,size,size_x,size_y;
  char *str;

				/* Compute x and y. */
  x=(int)(xdisplay[id].pick_x*event->xbutton.x);
  y=(int)(xdisplay[id].pick_y*event->xbutton.y);

  if (paint_brush) {
    XtSetArg(args[0],XmNvalue,&str);
    XtGetValues(text_value,args,1);
    if (*str=='\0')
      paint_value=0.0;
    else
      sscanf(str,"%f",&paint_value);
    XtFree(str);

    if (XmToggleButtonGetState(toggle_custom)) {
      XtGetValues(text_size,args,1);
      sscanf(str,"%d",&paint_size);
      XtFree(str);
    } else
      paint_size=0;

    if ((event->xbutton.state==Button1Mask)||
	(event->xbutton.button==Button1)) {     
      if (XmToggleButtonGetState(toggle_size[0]))
	size=0;
      if (XmToggleButtonGetState(toggle_size[1]))
	size=1;
      if (XmToggleButtonGetState(toggle_size[2]))
	size=2;
      if (XmToggleButtonGetState(toggle_size[3]))
	size=3;
      if (paint_size!=0)
	size=paint_size;

      for (x1=x-size; x1<=x+size; x1++)
	for (y1=y-size; y1<=y+size; y1++) {
	  if ((x1>=0)&&(x1<xdisplay[id].image->width)&&
	      (y1>=0)&&(y1<xdisplay[id].image->height)) {
	    *(vel_tape+(int)(x1*xdisplay[id].pick_x)+
	      (int)(y1*xdisplay[id].pick_y)*etrace[id])=(int)(paint_value+0.5);
	  }
	}

				/* Compute x and y. */
      x=event->xbutton.x;
      y=event->xbutton.y;

      size_x=(float)size/xdisplay[id].pick_x;
      size_y=(float)size/xdisplay[id].pick_y;
      for (x1=x-size_x; x1<=x+size_x; x1++)
	for (y1=y-size_y; y1<=y+size_y; y1++) {
	  if ((x1>=0)&&(x1<xdisplay[id].image->width)&&
	      (y1>=0)&&(y1<xdisplay[id].image->height)) {
	    *(raster[id]+x1+y1*xdisplay[id].image->width)=data_to_pixel((int)(paint_value+0.5),id)&0xffffffff;
	  }
	}

      XPutImage(display,xdisplay[id].top,xdisplay[id].gc,xdisplay[id].image,
		x-size_x,y-size_y,x-size_x,y-size_y,2*size_x+1,2*size_y+1);
      size_x_old=0;		/* Reset size so old outline box is erase. */
      size_y_old=0;		/* Reset size so old outline box is erase. */
    }
  }
}


void paint_button(XEvent *event, int id)
{
  int x,y,paint_size;
  int x1,y1,size,size_x,size_y;
  char *str;

				/* Compute x and y. */
  x=(int)(xdisplay[id].pick_x*event->xbutton.x);
  y=(int)(xdisplay[id].pick_y*event->xbutton.y);

  if (paint_brush) {

    XtSetArg(args[0],XmNvalue,&str);
    XtGetValues(text_value,args,1);
    if (*str=='\0')
      paint_value=0.0;
    else
      sscanf(str,"%f",&paint_value);
    XtFree(str);

    if (XmToggleButtonGetState(toggle_custom)) {
      XtSetArg(args[0],XmNvalue,&str);
      XtGetValues(text_size,args,1);
      sscanf(str,"%d",&paint_size);
      XtFree(str);
    } else
      paint_size=0;
    
    if (event->xbutton.button==Button1) {     
      if (XmToggleButtonGetState(toggle_size[0]))
	size=0;
      if (XmToggleButtonGetState(toggle_size[1]))
	size=1;
      if (XmToggleButtonGetState(toggle_size[2]))
	size=2;
      if (XmToggleButtonGetState(toggle_size[3]))
	size=3;
      if (paint_size!=0)
	size=paint_size;
      
      for (x1=x-size; x1<=x+size; x1++)
	for (y1=y-size; y1<=y+size; y1++) {
	  if ((x1>=0)&&(x1<xdisplay[id].image->width)&&
	      (y1>=0)&&(y1<xdisplay[id].image->height)) {
	    *(vel_tape+(int)(x1*xdisplay[id].pick_x)+
	      (int)(y1*xdisplay[id].pick_y)*etrace[id])=(int)(paint_value+0.5);
	  }
	}
      
				/* Compute x and y. */
      x=event->xbutton.x;
      y=event->xbutton.y;
      
      size_x=(float)size/xdisplay[id].pick_x;
      size_y=(float)size/xdisplay[id].pick_y;
      for (x1=x-size_x; x1<=x+size_x; x1++)
	for (y1=y-size_y; y1<=y+size_y; y1++) {
	  if ((x1>=0)&&(x1<xdisplay[id].image->width)&&
	      (y1>=0)&&(y1<xdisplay[id].image->height)) {
	    *(raster[id]+x1+y1*xdisplay[id].image->width)=data_to_pixel((int)(paint_value+0.5),id)&0xffffffff;
	  }
	}
      
      XPutImage(display,xdisplay[id].top,xdisplay[id].gc,xdisplay[id].image,
		x-size_x,y-size_y,x-size_x,y-size_y,2*size_x+1,2*size_y+1);
      size_x_old=0;		/* Reset size so old outline box is erase. */
      size_y_old=0;		/* Reset size so old outline box is erase. */
    }
    if (event->xbutton.button==Button2) {     
      paint_value=(float)*(vel_tape+x+y*etrace[id]);
      sprintf(buf,"%f",paint_value);
      XtSetArg(args[0],XmNvalue,buf);
      XtSetValues(text_value,args,1);
    }
    if (event->xbutton.button==Button3) {     
      update(id);
      size_x_old=0;		/* Reset size so old outline box is erase. */
      size_y_old=0;		/* Reset size so old outline box is erase. */
    }
  }
}


void moving_paint(XEvent *event, int id)
{
  static int x_old=0,y_old=0;
  int x,y,paint_size;
  int size,size_x,size_y;
  char *str;

				/* Compute x and y. */
  x=event->xbutton.x;
  y=event->xbutton.y;

  if (paint_brush) {

    if (XmToggleButtonGetState(toggle_custom)) {
      XtSetArg(args[0],XmNvalue,&str);
      XtGetValues(text_size,args,1);
      sscanf(str,"%d",&paint_size);
      XtFree(str);
    } else
      paint_size=0;

    if (XmToggleButtonGetState(toggle_size[0]))
      size=0;
    if (XmToggleButtonGetState(toggle_size[1]))
      size=1;
    if (XmToggleButtonGetState(toggle_size[2]))
      size=2;
    if (XmToggleButtonGetState(toggle_size[3]))
      size=3;
    if (paint_size!=0)
      size=paint_size;

    size_x=(float)size/xdisplay[id].pick_x;
    size_y=(float)size/xdisplay[id].pick_y;

    XSetForeground(display,xdisplay[id].gc,black);
    XSetFunction(display,xdisplay[id].gc,GXequiv);
    XSetLineAttributes(display,xdisplay[id].gc,0,
		       LineSolid,CapNotLast,JoinRound);

    XDrawRectangle(display,xdisplay[id].top,xdisplay[id].gc,
		   x_old-size_x_old,y_old-size_y_old,
		   2*size_x_old,2*size_y_old);
    
    x_old=x; y_old=y; 
    size_x_old=size_x;
    size_y_old=size_y;

    XDrawRectangle(display,xdisplay[id].top,xdisplay[id].gc,
		   x-size_x,y-size_y,2*size_x,2*size_y);


    XSetLineAttributes(display,xdisplay[id].gc,line_width,
		       LineSolid,CapNotLast,JoinRound);

    XSetFunction(display,xdisplay[id].gc,GXcopy);
  }
}


void reset_flagCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  *(Boolean*)client_data=False;
}


void update(int id)
{
  float hor_zoom,ver_zoom;
  int x,y,m,width,height,width_temp,height_temp;
  Pixel pixel;
  float offset,scalar;

                                /* Compute offset for seismic value. */
/*offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
  offset=(float)(end_color-start_color)/2+(int)start_color;	/* RJM: unbias */
  offset+=(offset*(int)(end_color-start_color+1))/100.0;
  
                                /* Compute scalar for seismic value. */
  scalar=100.0*xdisplay[id].scalar;

  hor_zoom=1/xdisplay[id].pick_x;
  ver_zoom=1/xdisplay[id].pick_y;

  width_temp=etrace[id];
  height_temp=esamp[id];
  width=width_temp*hor_zoom;
  height=height_temp*hor_zoom;

				/* Check if velocity tape was zoomed. */
  if ((hor_zoom==1.0)&&(ver_zoom==1.0))
    for (m=0; m<height_temp*width_temp; m++)
      *(raster[id]+m)=data_to_pixel(*(vel_tape+m),id)&0xffffffff;
  else
    for (y=0; y<height; y++)
      for (x=0; x<width; x++) {
	pixel=(Pixel)((*(vel_tape+(int)(x/hor_zoom)+
		       (int)(y/ver_zoom)*width_temp)*scalar)+offset);
	
	if (pixel<start_color) pixel=start_color;
	if (pixel>end_color) pixel=end_color;
        *(raster[id]+x+y*width)=pixel&0xffffffff;
      }

  expose_image(id);
}


void assign_vel_paint(int vel)
{
  if (paint_brush) {
    paint_value=(float)vel;
    sprintf(buf,"%d",(int)paint_value);
    XtSetArg(args[0],XmNvalue,buf);
    XtSetValues(text_value,args,1);
  }
}
