/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  creating the main menus.
*/

#include "xdisplayP.h"
#include "prototyping.h"


static void paint_zoom(long);
static void paint_segment(long);
static void paint_oper(long);
static void paint_create(long);
static void paint_color(long);
static void paint_help();
static void paint_return(long);

static Widget menubar=NULL;

void paint_menus(Widget main_window,Widget main_form, long id, Boolean dual_flag)
{
  XmRemoveTabGroup(main_form);

  xdisplay[id].menu=XmCreateFormVa(main_form,"menu",
				   NULL);
  XtAddCallback(xdisplay[id].menu,XmNhelpCallback,helpCB,"paint_window.help");

  menubar=XmCreateMenuBarVa(main_window,"menubar",
			    NULL);

  paint_zoom(id);
  paint_segment(id);
  edit_segment_menu(id, menubar);
  paint_oper(id);
  paint_create(id);
  paint_color(id);
  paint_help();
  paint_return(id);

  if (dual_flag)
    color_half(xdisplay[id].menu,id);
  else
    color_sliders(xdisplay[id].menu,id);
    

  XtVaSetValues(main_window,
                XmNmenuBar,menubar,
                XmNworkWindow,main_form,
                XmNshowSeparator,True,
                NULL);
  XtManageChild(xdisplay[id].menu);
}



static void paint_zoom(long id)
{
  Widget pulldown;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Window",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,(KeySym)'W',
                                  NULL);

  (void)XmCreatePushButtonVa(pulldown,"Global",
                              XmNmnemonic,(KeySym)'G',
                              XmNacceleratorText,XMstr("G"),
                              XmNaccelerator,"<Key>G",
			      XmNactivateCallback,CBl(globalCB,(XtPointer)id),
			      NULL);
}


static void paint_segment(long id)
{
  Widget pulldown;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  (void)XmCreateCascadeButtonVa(menubar,"Segments",
                                  XmNsubMenuId,pulldown,
                                  XmNmnemonic,(KeySym)'S',
                                  NULL);

  button=XmCreatePushButton(pulldown,"Edit Segments",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_modeCB,(XtPointer)(0x2000|id));
  XtManageChild(button);
}



static void paint_oper(long id)
{
  Widget pulldown;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  (void)XmCreateCascadeButtonVa(menubar,"Operations",
		XmNsubMenuId,pulldown,
		NULL );

  (void)XmCreatePushButtonVa(pulldown,"Paint Brush",
		XmNactivateCallback, CBl( paint_brushCB, (XtPointer)id ),
		NULL );

  (void)XmCreatePushButtonVa(pulldown,"Paint Area",
		XmNsensitive, False,
		NULL );

  (void)XmCreatePushButtonVa(pulldown,"Paint Warping",
		XmNsensitive, False,
		NULL );
}


static void paint_create(long id)
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Create",args,1);
  XtManageChild(cascade);

  button=XmCreatePushButton(pulldown,"Create Velocity Tape",NULL,0);
  XtAddCallback(button,XmNactivateCallback,create_vel_paintCB,(XtPointer)id);
  XtManageChild(button);
}


static void paint_color(long id)
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);

  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Color",args,1);
  XtManageChild(cascade);

  (void)XmCreatePushButtonVa(pulldown,"Pick Color",
                              XmNmnemonic,(KeySym)'P',
                              XmNactivateCallback,
				CBl(pick_color_dialogCB,(XtPointer)id),
                              NULL);

  button=XmCreatePushButton(pulldown,"Set to Global Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_global_colorCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Load Global Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)6L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Load Local Colormap",NULL,0);
  XtAddCallback(button,XmNactivateCallback,set_typeCB,(XtPointer)10L);
  XtAddCallback(button,XmNactivateCallback,filer_promptCB,(XtPointer)id);
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"Cursor Color",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,cursor_colorCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Show Colormap Scale",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,show_colormapCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Edit Colormap",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,edit_colormapCB,(XtPointer)id);

  button=XmCreatePushButton(pulldown,"Segment Colors",NULL,0);
  XtManageChild(button);
  XtAddCallback(button,XmNactivateCallback,segment_colorsCB,(XtPointer)id);
}



static void paint_help()
{
  Widget pulldown;
  Widget cascade;
  Widget button;

  pulldown=XmCreatePulldownMenuVa(menubar,"pulldown",
				XtNmanageChild,False,
#ifdef TEAR_OFF_MENUS
				XmNtearOffModel, XmTEAR_OFF_ENABLED, /* RJM */
#endif
				XmNvisual, visual,	/* RJM */
				XmNdepth, screenDepth,	/* RJM */
				NULL);
  
  XtSetArg(args[0],XmNsubMenuId,pulldown);
  cascade=XmCreateCascadeButton(menubar,"Help",args,1);
  XtManageChild(cascade);


  button=XmCreatePushButton(pulldown,"On Help",NULL,0);
  XtAddCallback(button,XmNactivateCallback,helpCB,"help.help");
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"On Window",NULL,0);
  XtAddCallback(button,XmNactivateCallback,helpCB,"window.help");
  XtManageChild(button);

  button=XmCreatePushButton(pulldown,"On Version",NULL,0);
  XtAddCallback(button,XmNactivateCallback,versionCB,0);
  XtManageChild(button);
}


static void paint_return(long id)
{
  extern Boolean paint_brush;
  Widget cascade;

  cascade=XmCreateCascadeButton(menubar,"Return",NULL,0);
  XtAddCallback(cascade,XmNactivateCallback,delete_windowCB,(XtPointer)id);
  XtAddCallback(cascade,XmNactivateCallback,reset_flagCB,&paint_brush); 
  XtManageChild(cascade);
}
