/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  make hardcopy plots of xsd images.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include <localsys.h> /* which system */


/* #ifdef SUN */        /* RJM: commented out */
#if defined(sun)
#include <rasterfile.h>
#ifndef __SVR4
#else
extern int pclose(FILE *);
#endif
#else
#include "rasterfile.h"
#endif

#define MIN_PRINT_HEIGHT 300

extern char printer_name[1024];

static Widget text_print[7];
static Widget toggle_color=NULL;
static Widget toggle_setting=NULL;
static unsigned char *ras_print;
static int print_width,print_height,border;
static int print_min_x,print_min_y,print_max_x,print_max_y;
static Boolean color_flag=True;
static Boolean settings_flag=False;
static char title[1024]="",x_title[1024]="Trace #",z_title[1024]="Sample #";
static char note_name[1024]="",filename[1024]="";

/*
  This function prompts the 
  user to save the xsd image 
  to a file or a printer.
*/
void save_printCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget dialog_form;
  Widget button, lbl0, lbl1, lbl2, lbl3, lbl4, lbl5, lbl6;
  long id;	/* RJM: handle 64-bit architectures */
  ClientData *message;
 
  id=(long)client_data;
  
  dialog_form=XmCreateFormDialogVa(w,"form",
				   XmNmarginHeight,10,
				   XmNmarginWidth,10,
				   XmNdeleteResponse,XmDO_NOTHING,
				   XmNdialogTitle,XMstr("Print Parameters"),
				   XtNmanageChild,False,
				   NULL);
  XtAddCallback(dialog_form,XmNhelpCallback,helpCB,"print.help"); 
  
  if (settings_flag==False) {
    strcpy(title,xdisplay[id].filename);
    /* DWN 1/15/98 add to be sure something shows up in printer name field */
    if (strlen(printer_name)==0) {
      char *ctemp=NULL;
      if( (ctemp=getenv("PRINTER")) == NULL )
         ctemp=getenv("LPDEST");
      if (ctemp!=NULL)
         strcpy(printer_name,ctemp);
    }
  }

  lbl0 = XmCreateLabelVa(dialog_form,"Plot Title",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_FORM,
			  XmNtopOffset,20,
			  NULL);
  lbl1 = XmCreateLabelVa(dialog_form,"X Title",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl0,
			  XmNtopOffset,10,
			  NULL);
  lbl2 = XmCreateLabelVa(dialog_form,"Z Title",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl1,
			  XmNtopOffset,10,
			  NULL);
  lbl3 = XmCreateLabelVa(dialog_form,"Border in pixels",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl2,
			  XmNtopOffset,10,
			  NULL);
  lbl4 = XmCreateLabelVa(dialog_form,"Output file",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl3,
			  XmNtopOffset,10,
			  NULL);
  lbl5 = XmCreateLabelVa(dialog_form,"Note file",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl4,
			  XmNtopOffset,10,
			  NULL);
  lbl6 = XmCreateLabelVa(dialog_form,"Printer Name",
			  XmNleftAttachment,XmATTACH_FORM,
			  XmNleftOffset,10,
			  XmNtopAttachment,XmATTACH_WIDGET,
			  XmNtopWidget,lbl5,
			  XmNtopOffset,10,
			  NULL);

  text_print[0]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,title,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl0,
			       XmNtopOffset,-5,
			       NULL);
  text_print[1]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,x_title,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl1,
			       XmNtopOffset,-5,
			       NULL);
  text_print[2]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,z_title,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl2,
			       XmNtopOffset,-5,
			       NULL);
  text_print[3]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,"0",
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl3,
			       XmNtopOffset,-5,
			       NULL);
  text_print[4]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,filename,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl4,
			       XmNtopOffset,-5,
			       NULL);
  text_print[5]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,note_name,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl5,
			       XmNtopOffset,-5,
			       NULL);
  text_print[6]=XmCreateTextVa(dialog_form,"text",
			       XmNcolumns,40,
			       XmNvalue,printer_name,
			       XmNleftAttachment,XmATTACH_WIDGET,
			       XmNleftWidget,lbl3,
			       XmNleftOffset,10,
			       XmNrightAttachment,XmATTACH_FORM,
			       XmNrightOffset,10,
			       XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
			       XmNtopWidget,lbl6,
			       XmNtopOffset,-5,
			       NULL);
  
  XtManageChildren(text_print,7);
    
  toggle_setting=XmCreateToggleButtonVa(dialog_form,"Save current settings",
				    XmNtopAttachment,XmATTACH_WIDGET,
				    XmNtopWidget,lbl6,
				    XmNtopOffset,20,
				    XmNleftAttachment,XmATTACH_FORM,
				    XmNsensitive,True,
				    NULL);
  XmToggleButtonSetState(toggle_setting,settings_flag,False);
  
  toggle_color=XmCreateToggleButtonVa(dialog_form,"Color Scale",
				      XmNtopAttachment,XmATTACH_WIDGET,
				      XmNtopWidget,toggle_setting,
				      XmNleftAttachment,XmATTACH_FORM,
				      XmNsensitive,True,
				      NULL);
  XmToggleButtonSetState(toggle_color,color_flag,False);
  
  
  button=XmCreatePushButtonVa(dialog_form,"  OK  ",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,toggle_color,
			      XmNleftAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);
  
  message=(ClientData *)malloc(sizeof(ClientData));
  message->w=dialog_form;
  message->id=id;
  XtAddCallback(button,XmNactivateCallback,show_watchCB,xdisplay[id].window);
  XtAddCallback(button,XmNactivateCallback,printCB,message);
  XtAddCallback(button,XmNactivateCallback,hide_watchCB,xdisplay[id].window);
  
  
  button=XmCreatePushButtonVa(dialog_form,"Cancel",
			      XmNtopAttachment,XmATTACH_WIDGET,
			      XmNtopWidget,toggle_color,
			      XmNrightAttachment,XmATTACH_FORM,
			      XmNbottomAttachment,XmATTACH_FORM,
			      NULL);
  XtAddCallback(button,XmNactivateCallback,destroyCB,dialog_form);
  
  XtManageChild(dialog_form);
}


/*
   This function reads the
   printing parameters.
   */
void printCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  ClientData *message=(ClientData *)client_data;
  char *str;
  
  XtSetArg(args[0],XmNvalue,&str);
 
  XtGetValues(text_print[0],args,1);
  strcpy(title,str);
  XtFree(str);

  XtGetValues(text_print[1],args,1);
  strcpy(x_title,str);
  XtFree(str);

  XtGetValues(text_print[2],args,1);
  strcpy(z_title,str);
  XtFree(str);

  XtGetValues(text_print[3],args,1);
  sscanf(str,"%d",&border);
  XtFree(str);
  border+=75;

  XtGetValues(text_print[4],args,1);
  strcpy(filename,str);
  XtFree(str);

  XtGetValues(text_print[5],args,1);
  strcpy(note_name,str);
  XtFree(str);

  XtGetValues(text_print[6],args,1); 
  strcpy(printer_name,str);
  XtFree(str);

  if (XmToggleButtonGetState(toggle_color))
    color_flag=True;
  else
    color_flag=False;
  
  settings_flag=XmToggleButtonGetState(toggle_setting);

  save_print(message->id);

  if( message->w != NULL )
    XtDestroyWidget( message->w );
  free(message);
}


/*
  This function save out the image
  file and prints it.
*/
void save_print(long id)
{
  FILE *in;
  XColor color[256];
  struct rasterfile header;
  unsigned char red[256],green[256],blue[256];
  char buf2[1024],*tmp_file1;
  int n,out1,out2,old_mode,note_length,x,y;
#ifdef LINUXSYSTEM
  struct rasterfile swap;
#endif

  tmp_file1=tmpnam(NULL);
  out1=open(tmp_file1,O_WRONLY|O_TRUNC|O_CREAT,0666);
  if (strlen(filename)==0)
    out2=0;
  else
    out2=open(filename,O_WRONLY|O_TRUNC|O_CREAT,0666);

  if (out1==-1) {
    error_message("Can't open print file.");
    return;
  }
  if (out2==-1) {
    error_message("Can't open print file.");
    return;
  }

  if (color_flag)
    print_width=xdisplay[id].image->width+2*border+125;
  else
    print_width=xdisplay[id].image->width+2*border;

  print_height=xdisplay[id].image->height+2*border+25;
  if (print_height<MIN_PRINT_HEIGHT+border+25)
    print_height=MIN_PRINT_HEIGHT+border+25;

  if (strlen(note_name)!=0) {
    in=fopen(note_name,"r");
    if (in==NULL) {
      error_message("Can't open note file.");
      return;
    }
    fclose(in);
    sprintf(buf,"wc -l %s",note_name);
    in=popen(buf,"r");
    fscanf(in,"%d",&note_length);
    note_length*=13;
    print_height+=(note_length+30);
    pclose(in);
  }

  ras_print=(unsigned char *)malloc(print_width*print_height*sizeof(char));

  memset((char *)ras_print,(int)(white&0xffffffff),print_width*print_height*sizeof(char));

  for (y=0; y<xdisplay[id].image->height; y++)
    memcpy((char *)(ras_print+border+(y+border)*print_width),
	   (char *)(raster[id]+y*xdisplay[id].image->width),
	   xdisplay[id].image->width);

  old_mode=xdisplay[id].mode;

  xdisplay[id].mode=26;
  set_mode_label(26,id);

  print_min_x=-50;
  print_min_y=-50;
  print_max_x=xdisplay[id].image->width+50;
/* DWN more room ???
  print_max_y=xdisplay[id].image->height+50;
*/
  print_max_y=xdisplay[id].image->height+75;

  if( xdisplay[id].axis_flag )
    draw_axis(id,id);
  show_labels(id,id);

  print_min_x=0;
  print_min_y=0;
  print_max_x=xdisplay[id].image->width;
  print_max_y=xdisplay[id].image->height;

  expose_picks(id);
  expose_grid(id);

  if (strlen(note_name)!=0)
    if (expose_note(id,note_length)==0) {
      if(ras_print)
        free((char*)ras_print);
      ras_print = NULL;
      return;
    }

				/* Draw titles in middle of section. */
  if (color_flag) {
    expose_color_scale(id); /* Draw color scale. */

    x=(print_width-100)/2;
    y=border-10;
    expose_labels(id,title,"10x20",x,y,black,1,0,False,False);
    if (strlen(note_name)==0) {
      x=(print_width-100)/2;
      y=print_height-border+75;
      expose_labels(id,x_title,"9x15bold",x,y,black,1,0,False,False);
      x=border-70;
      y=(print_height-100)/2;
      expose_labels(id,z_title,"9x15bold",x,y,black,0,1,False,True);
    } else {
      x=(print_width-100)/2;
      y=print_height-border+55-note_length;
      expose_labels(id,x_title,"9x15bold",x,y,black,1,0,False,False);
      x=border-70;
      y=(print_height-100-note_length-20)/2;
      expose_labels(id,z_title,"9x15bold",x,y,black,0,1,False,True);
    }
  } else {
    x=print_width/2;
    y=border-10;
    expose_labels(id,title,"10x20",x,y,black,1,0,False,False);
    if (strlen(note_name)==0) {
      x=print_width/2;
      y=print_height-border+75;
      expose_labels(id,x_title,"9x15bold",x,y,black,1,0,False,False);
      x=border-70;
      y=(print_height-100)/2;
      expose_labels(id,z_title,"9x15bold",x,y,black,0,1,False,True);
    } else {
      x=print_width/2;
      y=print_height-border+55-note_length;
      expose_labels(id,x_title,"9x15bold",x,y,black,1,0,False,False);
      x=border-70;
      y=(print_height-100-note_length-20)/2;
      expose_labels(id,z_title,"9x15bold",x,y,black,0,1,False,True);
    }
  }

  xdisplay[id].mode=old_mode;
  set_mode_label(old_mode,id);
  expose_image(id);

  header.ras_magic=RAS_MAGIC;
  header.ras_width=print_width;
  header.ras_height=print_height;
  header.ras_depth=8;
  if (header.ras_width%2 == 0)
    header.ras_length=header.ras_width*header.ras_height;
  else
    header.ras_length=(header.ras_width+1)*header.ras_height;
  header.ras_type=RT_STANDARD;
  header.ras_maptype=RMT_EQUAL_RGB;
  header.ras_maplength=768;

#ifdef CRAY
  buf1[0]=(header.ras_magic<<32)+(header.ras_width&0xffffffff);
  buf1[1]=(header.ras_height<<32)+(header.ras_depth&0xffffffff);
  buf1[2]=(header.ras_length<<32)+(header.ras_type&0xffffffff);
  buf1[3]=(header.ras_maptype<<32)+(header.ras_maplength&0xffffffff);
  write(out1,buf1,32);
  if (out2!=0)
    write(out2,buf1,32);
#else

#ifdef LINUXSYSTEM
  /* DWN 1/6/99 swap bytes on linux so it appears in sun byte order */
  swap.ras_magic=htonl(header.ras_magic);
  swap.ras_width=htonl(header.ras_width);
  swap.ras_height=htonl(header.ras_height);
  swap.ras_depth=htonl(header.ras_depth);
  swap.ras_length=htonl(header.ras_length);
  swap.ras_type=htonl(header.ras_type);
  swap.ras_maptype=htonl(header.ras_maptype);
  swap.ras_maplength=htonl(header.ras_maplength);
  write(out1,(void*)&swap,sizeof(swap));
  if (out2!=0)
    write(out2,(void*)&swap,sizeof(swap));
#else
  write(out1,(void*)&header,sizeof(header));	
  if (out2!=0)
    write(out2,(void*)&header,sizeof(header));
#endif

#endif


  for (n=0; n<256; n++) {
    color[n].pixel=n;
  }

  XQueryColors(display,xdisplay[id].cmap,color,256);

  for (n=0; n<256; n++) {
    red[n]=(unsigned char)(color[n].red>>8);
    green[n]=(unsigned char)(color[n].green>>8);
    blue[n]=(unsigned char)(color[n].blue>>8);
  }

  write(out1,red,256);
  write(out1,green,256);
  write(out1,blue,256);
  if (out2!=0) {
    write(out2,red,256);
    write(out2,green,256);
    write(out2,blue,256);
  }

  if (header.ras_width%2 == 0) {
    write(out1,ras_print,header.ras_width*header.ras_height*sizeof(char));
    if (out2!=0)
      write(out2,ras_print,header.ras_width*header.ras_height*sizeof(char));
  } else {
    for (n=0; n<header.ras_height; n++) {
      write(out1,(ras_print+n*header.ras_width),
	    header.ras_width*sizeof(char));
      write(out1,ras_print,1);	/* RJM: comment: pad to 16 bit boundary */
      if (out2!=0) {
	write(out2,(ras_print+n*header.ras_width),
	      header.ras_width*sizeof(char));
	write(out2,ras_print,1);
      }
    }
  }
  close(out1);
  if (out2!=0)
    close(out2);

  if (strlen(printer_name)!=0) {
    sprintf(buf2,"lpr -r -v -P%s %s\n",printer_name,tmp_file1);
    system(buf2);
  } else if (out2==0) {
    /* DWN add 1/15/98 and fixed on 2/2/98 */
    error_message("Please specify a printer name and/or a file name.");
  }

  if(ras_print)
    free((char*)ras_print);
  ras_print = NULL;

  return;
}



/*
  This function add text to the
  bottom of the plot.
*/
int expose_note(long id, int note_length)
{
  FILE *in;
  int x,y;
  
  in=fopen(note_name,"r");

  if (in==NULL) {
    error_message("Can't open note file.");
    return(0);
  }

  y=print_height-note_length;

  while (fgets(buf,1024,in)!=NULL) {
    strcpy(&buf[strlen(buf)-1],"");
    expose_labels(id,buf,"7x13",border+10,y,black,0,0,False,False);
    y+=13;
  }
  
  x=print_width-2*border;
  y=print_height-note_length-border-10;
  digline(0,y,x,y,black,1);
  digline(x,y,x,print_height-border-2,black,1);
  digline(x,print_height-border-2,0,print_height-border-2,black,1);
  digline(0,print_height-border-2,0,y,black,1);


  fclose(in);

  return(1);
}


/*
  This function draws the color
  scale for the hardcopy.
*/
void expose_color_scale(long id)
{
  int start_x,start_y,y;
  float offset,scalar,value;

				/* Compute offset for seismic value. */
/*offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
  offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
  offset+=(xdisplay[id].offset*(int)(end_color-start_color+1))/100.0;
  
  /* Compute scalar for seismic value. */
  scalar=100.0*xdisplay[id].scalar;
  start_x=print_width-125;
  start_y=border+25;

  for (y=start_y; y<start_y+200; y++) {
    if ((((y-start_y)%25)==0)||(y==start_y+199)) {
      digline(start_x+25-border,y-border,
	      start_x+30-border,y-border,black,1);
      value=((float)((int)start_color+y-start_y)-offset)/scalar;
      if (value<0) sprintf(buf,"%10.3g",value);
      else sprintf(buf," %10.3g",value);
      expose_labels(id,buf,"9x15bold",print_width-10,y,black,2,1,False,False);
    }
    memset((char *)(ras_print+start_x+y*print_width),(int)start_color+y-start_y,25);
  }

  start_x-=border;
  start_y-=border;
  digline(start_x,start_y,start_x+25,start_y,black,1);
  digline(start_x+25,start_y,start_x+25,start_y+200,black,1);
  digline(start_x+25,start_y+200,start_x,start_y+200,black,1);
  digline(start_x,start_y+200,start_x,start_y,black,1);
}


/*
  This function creates a bitmap
  image of a text string and draws
  it on the image.
*/
void expose_labels(long id, char *buf, char *font_name, 
		   int x, int y, Pixel color, int center_x, int center_y, 
		   Boolean border_flag, Boolean rotate)
{ 
  XFontStruct *font;
  XCharStruct overall;
  Pixmap pix;
  XImage *image;
  int direction,ascent,descent,width,height,x1,y1;
  Pixel bg;

#ifdef DEBUG
  fprintf( stderr, "expose_labels: id=%d, buf=%s, font_name=%s, x=%d, y=%d, color=%ld, center_x=%d, center_y=%d\n", id, buf, font_name, x, y, color, center_x, center_y );
#endif

  if (strlen(buf)==0)
    return;

  font=XQueryFont(display,XLoadFont(display,font_name));
  XTextExtents(font,buf,strlen(buf),&direction,&ascent,&descent,&overall);
  XSetFont(display,xdisplay[id].gc,XLoadFont(display,font_name));

  width=overall.width;
  height=ascent+descent;

  pix=XCreatePixmap(display,xdisplay[id].top,width,height,8); 

  if (color==white)
    bg=black;
  else
    bg=white;

  XSetForeground(display,xdisplay[id].gc,bg);
  XFillRectangle(display,pix,xdisplay[id].gc,0,0,width,height);

  XSetForeground(display,xdisplay[id].gc,color);
  XDrawString(display,pix,xdisplay[id].gc,0,ascent,buf,strlen(buf));

  image=XGetImage(display,pix,0,0,width,height,AllPlanes,ZPixmap);

  if (rotate) {
    switch (center_x) {
    case 0: break;		/* Right */
    case 1: x-=(height/2); break; /* Middle */
    case 2: x-=height; break;	/* Left */
    }
    switch (center_y) {
    case 0: y+=width; break;	/* Bottom */
    case 1: y+=(width/2); break; /* Middle */
    case 2: break;		/* Top */
    }  
  } else {
    switch (center_x) {
    case 0: break;		/* Right */
    case 1: x-=(width/2); break; /* Middle */
    case 2: x-=width; break;	/* Left */
    }
    switch (center_y) {
    case 0: y-=height; break;	/* Bottom */
    case 1: y-=(height/2); break; /* Middle */
    case 2: break;		/* Top */
    }
  }

  /* DWN 1/15/97 label is wider than destination image */
  if (width>print_width) x=0;

  if (border_flag) {
    x+=border;
    y+=border;
  }

				/* Rotates fonts vertically. */
  if (rotate) {
    for (y1=0; y1<height; y1++)
      for (x1=0; x1<width; x1++)
	if (XGetPixel(image,x1,y1)!=bg)
	  *(ras_print+(x+y1)+((y+(width-x1))*print_width))=XGetPixel(image,x1,y1);
  } else {
    int xstart;

    /* DWN 1/15/97 label is wider than destination image */
    if (width>print_width) xstart=width-print_width;
    else xstart=0;

    for (y1=0; y1<height; y1++) {
      for (x1=xstart; x1<width; x1++)
	if (XGetPixel(image,x1,y1)!=bg)
	  *(ras_print+(x+(x1-xstart))+((y+y1)*print_width))=
                                                    XGetPixel(image,x1,y1);
    }
  }

  XFreePixmap(display,pix);
  (void)XDestroyImage(image);

  return;
}

/*
  This function is simular to
  expose_labels except the string
  is draw on a black or white
  rectangle.
*/
void expose_labels_image(long id, char *buf, char *font_name, int x, int y, 
			 Pixel fg, Pixel bg, int center_x, int center_y, 
			 Boolean border_flag, Boolean rotate)
{ 
  XFontStruct *font;
  XCharStruct overall;
  Pixmap pix;
  XImage *image;
  int direction,ascent,descent,width,height,x1,y1;

  if (strlen(buf)==0)
    return;

  font=XQueryFont(display,XLoadFont(display,font_name));
  XTextExtents(font,buf,strlen(buf),&direction,&ascent,&descent,&overall);
  XSetFont(display,xdisplay[id].gc,XLoadFont(display,font_name));

  width=overall.width;
  height=ascent+descent;

  pix=XCreatePixmap(display,xdisplay[id].top,width,height,8); 

  XSetForeground(display,xdisplay[id].gc,bg);
  XFillRectangle(display,pix,xdisplay[id].gc,0,0,width,height);

  XSetForeground(display,xdisplay[id].gc,fg);
  XSetBackground(display,xdisplay[id].gc,bg);
  XDrawImageString(display,pix,xdisplay[id].gc,0,ascent,buf,strlen(buf));

  image=XGetImage(display,pix,0,0,width,height,AllPlanes,ZPixmap);

  if (rotate) {
    switch (center_x) {
    case 0: break;		/* Right */
    case 1: x-=(height/2); break; /* Middle */
    case 2: x-=height; break;	/* Left */
    }
    switch (center_y) {
    case 0: y+=width; break;	/* Bottom */
    case 1: y+=(width/2); break; /* Middle */
    case 2: break;		/* Top */
    }  
  } else {
    switch (center_x) {
    case 0: break;		/* Right */
    case 1: x-=(width/2); break; /* Middle */
    case 2: x-=width; break;	/* Left */
    }
    switch (center_y) {
    case 0: y-=height; break;	/* Bottom */
    case 1: y-=(height/2); break; /* Middle */
    case 2: break;		/* Top */
    }
  }

  if (border_flag) {
    x+=border;
    y+=border;
  }

				/* Rotates fonts vertically. */
  if (rotate) {
    for (y1=0; y1<height; y1++)
      for (x1=0; x1<width; x1++)
	*(ras_print+(x+y1)+((y+(width-x1))*print_width))=XGetPixel(image,x1,y1);
  } else {
    for (y1=0; y1<height; y1++)
      for (x1=0; x1<width; x1++)
	*(ras_print+(x+x1)+((y+y1)*print_width))=XGetPixel(image,x1,y1);
  }

  XFreePixmap(display,pix);
  (void)XDestroyImage(image);

  return;
}


/*
  This function store a pixel
  at location x,y.
*/
void pixelprint(int x, int y, Pixel nv)
{
  if ((x<print_min_x)||(y<print_min_y)||
      (x>print_max_x)||(y>print_max_y)) 
    return;
  x+=border;
  y+=border;
 
  *(ras_print+x+y*print_width) = nv & 0xffffffff;
}

