/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

extern void	error_message( char* );


void reportDSerror( int rc )
{
	switch( rc )
	{
	case 0:
		break;
	case -1:
		error_message( "Data server unable to open specified data file." );
		break;
	case -2:
		error_message( "Data server unable to open associated binary data file." );
		break;
	case -3:
		error_message( "Data server unable to recognize data as SIS, DDS, Disco or SEGY." );
		break;
	case -4:
		error_message( "Data server Unable to open DDS map." );
		break;
	case -5:
		error_message( "Data server found illegal size= definition in DDS dictionary file." );
		break;
	case -11:
		error_message( "Data server unable to allocate space for scaling data." );
		break;
	case -12:
		error_message( "Data server unable to allocate space for trace buffer." );
		break;
	case -13:
		error_message( "Data server unable to allocate space for data buffer." );
		break;
	case -14:
		error_message( "Data server unable to read trace data." );
		break;
	case -15:
		error_message( "Data server unable to allocate space for rasterized data." );
		break;
	case -16:
		error_message( "Data server unable to allocate space for IEEE conversion buffer." );
		break;
	case -90:
		error_message( "Error reading seismic data (server may be dead). Try specifying the data format." );
		break;
	case -91:
		error_message( "Data server found 0 bytes of line header." );
		break;
	case -92:
		error_message( "Data server unable to generate header in SIS or Disco format." );
		break;
	case -93:
		error_message( "Data server return impossible #bytes in trace." );
		break;
	case -94:
		error_message( "Data server must be dead.  No response after 1000 tries." );
		break;
	case -95:
		error_message( "Data server not running or no files in current directory path." );
		break;
	default:
		error_message( "Unable to interpret error code from data server." );
		break;
	}
}
