/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/************************************************************************
 * Routine: RMVDUPPOINTS3
 * Purpose: Remove duplicate points along curve segments.
 * Author:  Bob Mars
 * Date:    4-19-90
 ***********************************************************************/


typedef struct {
   float  x;
   float  y;
   float  z;
} Tuple, *Tupleptr;


void rmvduppoints3( crvs, ncrvs, ncrvpts )
   Tupleptr crvs[];
   int      *ncrvs, ncrvpts[];
{
   int      ccrv, pt, i;


   for( ccrv = 0;  ccrv < *ncrvs;  ccrv++ )
      for( pt = 0;  pt < ncrvpts[ccrv]-1; )
         if( (crvs[ccrv]+pt)->x == (crvs[ccrv]+pt+1)->x  &&
             (crvs[ccrv]+pt)->y == (crvs[ccrv]+pt+1)->y  &&
             (crvs[ccrv]+pt)->z == (crvs[ccrv]+pt+1)->z )  {
            for( i = pt;  i < ncrvpts[ccrv] - 1;  i++ )  {
               (crvs[ccrv]+i)->x = (crvs[ccrv]+i+1)->x;
               (crvs[ccrv]+i)->y = (crvs[ccrv]+i+1)->y;
               (crvs[ccrv]+i)->z = (crvs[ccrv]+i+1)->z;
            }

            ncrvpts[ccrv]--;
         } else
            pt++;
}
