/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the function for
  loading, saving, and editting the colormap.
*/

#include "xdisplayP.h"
#include "prototyping.h"
#include "stringutils.h"

#define WIDTH	200
#define HEIGHT	440

static CB_PROTO( draw_color_scaleCB )
static CB_PROTO( cancelColorScaleCB )

static Widget	scale_color_dialog = NULL;
static Window	top = NULL;
static GC	gc = NULL;


/*
	Create a window to display the color scale.
*/

void show_colormapCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget	draw_area;
  XGCValues	values;
  String	tmp;
  long		id = (long)client_data;	/* RJM: handle 64-bit architectures */

  if( scale_color_dialog != NULL )
	XtDestroyWidget( scale_color_dialog );

  scale_color_dialog = XmCreateFormDialogVa( w, "colorScale",
			XmNmarginHeight,10,
			XmNmarginWidth,10,
			XmNdialogTitle,XMstr( tmp = concat( "Window ",
						itostr( xdisplay[id].sequence ),
						" Color Scale",
                                                NULL ) ),
			XmNvisual, visual,
			XmNdepth, screenDepth,
/*  			XmNcolormap, xdisplay[id].cmap, RJM: causes dialog to allocate colors which generates errors */
			XtNmanageChild,False,
			XmNhelpCallback, CBl( helpCB, "show_color.help" ),
			NULL );
  free( tmp );

  draw_area=XmCreateDrawingAreaVa(scale_color_dialog,"drawArea",
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			XmNtopAttachment,XmATTACH_FORM,
			XmNbottomAttachment,XmATTACH_FORM,
			XmNbottomOffset,50,
			XmNbackground,black,
			XmNwidth,WIDTH,
			XmNheight,HEIGHT,
  			XmNexposeCallback,
				CBl( draw_color_scaleCB, (XtPointer)id ),
			NULL);
  
  (void)XmCreatePushButtonVa(scale_color_dialog,"Cancel",
			XmNleftAttachment,XmATTACH_FORM,
			XmNbottomAttachment,XmATTACH_FORM, 
  			XmNactivateCallback,
				CBl( cancelColorScaleCB, (XtPointer)NULL ),
			NULL);
  
  XtManageChild(scale_color_dialog);

  top = XtWindow( draw_area );	/* note: must do after managechild */

  if( gc == NULL )
  {	/* create once */
	values.background = black;
	values.foreground = white;
	values.font = XLoadFont( display, "9x15" );
	gc = XCreateGC( display, top, GCForeground|GCBackground|GCFont, &values );
  }

/*draw_color_scaleCB( NULL, (XtPointer)id, NULL ); CAN'T DO HERE AS WINDOW MUST
					BE MAPPED TO SCREEN FOR DRAWING TO GC
*/

  XSetWindowColormap( display, XtWindow(XtParent(scale_color_dialog)), xdisplay[id].cmap );
#if defined(__sgi) || defined(sun)	/* added sun in case redirect disp from sun to sgi */
  XSetWindowColormap( display, top, xdisplay[id].cmap );
#endif
}


/*
	Draw the labels
*/
CB_DECL( draw_color_scaleCB )
{
  char		buf[1024];
  int		n;
  long		id = (long)client_data;
  Boolean	flag=False;
  float		offset,scalar,value;

				/* Compute offset for seismic value. */
/*offset=((end_color-start_color+1)/2+start_color); RJM: commented out */
  offset=(float)(end_color-start_color)/2+(int)start_color; /* RJM: unbias */
  offset+=(xdisplay[id].offset*(int)(end_color-start_color+1))/100.0;
  
				/* Compute scalar for seismic value. */
  scalar=100.0*xdisplay[id].scalar;

  if (((((float)start_color-offset)/scalar)>-100000)&&
      ((((float)end_color-offset)/scalar)<100000)) 
    flag=True;

  XSetForeground(display,gc,white);
  XDrawLine(display,top,gc,19,19,71,19);	/* bounding box */
  XDrawLine(display,top,gc,71,19,71,420);
  XDrawLine(display,top,gc,71,420,19,420);
  XDrawLine(display,top,gc,19,420,19,19);

  for (n=0; n<400; n++) {
    if (((n%25)==0)||(n==399)) {
      XSetForeground(display,gc,white);
      XDrawLine(display,top,gc,70,n+20,75,n+20);

				/* Compute the seismic value. */
      value=((float)((n/2)+(int)start_color)-offset)/scalar;
      if (value<0) 
	if (flag)
	  sprintf(buf,"%7.2f",value);
	else
	  sprintf(buf,"%1.2e",value);
      else
	if (flag)
	  sprintf(buf," %7.2f",value);
	else
	  sprintf(buf," %1.2e",value);
      XDrawString(display,top,gc,80,n+25,buf,strlen(buf));
    }

    XSetForeground(display,gc,(Pixel)((n/2)+start_color));
    XDrawLine(display,top,gc,20,n+20,70,n+20);
  }
}


static CB_DECL( cancelColorScaleCB )
{
	if( scale_color_dialog != NULL )
	{
		XtDestroyWidget( scale_color_dialog );
		scale_color_dialog = NULL;
	}
}
