/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
  This file contains the functions for
  mouse event handling for the velocity selection.
*/

#include "xdisplayP.h"
#include "prototyping.h"

extern Widget *v_parameter;
extern float bar_scale;

/*
  This function handles all
  pushed mouse button events.
*/
void button_push_velEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch)	/* RJM: added 4th arg */
{
  int x,vel,start,end;
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */
  float factor;

  x=event->xbutton.x-20;

  if (x<0) x=0;

  start=pixel_to_data(start_color,id);
  end=pixel_to_data(end_color,id);

  factor=(end-start)/(bar_scale*(int)(end_color-start_color+1));
  vel=(int)(x*factor+start);
  if (vel>end) vel=end;

  if (xdisplay[id].mode==18) 
    assign_vel(vel,id);

  if (xdisplay[id].mode==28) 
    assign_vel_paint(vel);
}



/*
  This function handles all
  released mouse button events.
*/
void button_release_velEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch)	/* RJM: added 4th arg */
{

}



/*
  This function handles all
  mouse movement events.
*/
void moving_mouse_velEH(Widget w, XtPointer client_data, XEvent *event,
	Boolean *continue_to_dispatch)	/* RJM: added 4th arg */
{
  long id = (long)client_data;	/* RJM: handle 64-bit architectures */

  vel_meter(event,id);
}
