/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* util.c -- utility functions for zip support
 */

#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
/* #include "tailor.h" */

/*
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifndef NO_FCNTL_H
#  include <fcntl.h>
#endif
#if defined(STDC_HEADERS) || !defined(NO_STDLIB_H)
#  include <stdlib.h>
#else
#  extern int errno;
#endif
*/

#include "zip.h"
/* #include "crypt.h" */

/* =====================================================================
 * Clear input and output buffers
 */
void clear_bufs()
{
    outcnt = 0;
    insize = inptr = 0;
    bytes_in = bytes_out = 0L;
}

/* =====================================================================
 * Fill the input buffer. This is called only when the buffer is empty.
 */
int fill_inbuf(eof_ok)
    int eof_ok;          /* set if EOF acceptable as a result */
{
    int size;

    /* Read as much as possible */
    errno = 0;
    
    size = INBUFSIZ;
    if (size > icnt) size = icnt;
    
    if (size > 0)
    {
       memcpy((char*)inbuf, (char*)ibuf, (size_t)size);
       ibuf += size;
       icnt -= size;
    }
    insize = size;

    if (insize == 0) {
	if (eof_ok) return EOF;
	read_error();
    }
    bytes_in += (ulg)insize;
    inptr = 1;
    return inbuf[0];
}

/* =====================================================================
 * Write the output buffer outbuf[0..outcnt-1] and update bytes_out.
 * (used for the compressed data only)
 */
void flush_outbuf()
{
    if (outcnt == 0) return;

    write_buf((char *)outbuf, outcnt);
    bytes_out += (ulg)outcnt;
    outcnt = 0;
}

/* =====================================================================
 * Write the output window window[0..outcnt-1] and bytes_out.
 * (Used for the decompressed data only.)
 */
void flush_window()
{
    if (outcnt == 0) return;

	 write_buf((char *)window, outcnt);
    bytes_out += (ulg)outcnt;
    outcnt = 0;
}

/* =====================================================================
 * Read a new buffer from the current input buffer.
 */
int file_read(buf, size)
    char *buf;
    unsigned size;
{
    unsigned len;

    Assert(insize == 0, "inbuf not empty");

    if (size > icnt) size = icnt;
    
    if (size > 0)
    {
       memcpy((char*)buf, (char*)ibuf, (size_t)size);
       ibuf += size;
       icnt -= size;
    }
    
    return (int)size;
}

/* =====================================================================
 * Does the same as write(), but writes to the output buffer.
 */
void write_buf(buf, cnt)
voidp     buf;
unsigned  cnt;
{
    unsigned  n;

    if (ocnt + cnt > osize)
    {
       osize = ocnt + cnt + 10000;
       obuf = (uch*)realloc(obuf, osize);
    }
    memcpy((char*)&obuf[ocnt], (char*)buf, (size_t)cnt);
    ocnt += cnt;
}

/* =====================================================================
 * Error handlers.
 */
void zerror(m)
    char *m;
{
    fprintf(stderr, "\nzip error: %s\n", m);
}

void warn(a, b)
    char *a, *b;            /* message strings juxtaposed in output */
{
    fprintf(stderr, "zip warning: %s%s\n", a, b);
}

void read_error()
{
    fprintf(stderr, "zip error: unexpected end of buffer\n");
}
