/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* zip.c -- compress data buffers using the gzip format 
 *	taken from gnu's gzip-1.2.4 freeware 
 */
#ifdef TESTZIP
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif

#include "zip.h"

/* GLOBALS */

DECLARE(uch, inbuf,  INBUFSIZ +INBUF_EXTRA);
DECLARE(uch, outbuf, OUTBUFSIZ+OUTBUF_EXTRA);
DECLARE(ush, d_buf,  DIST_BUFSIZE);
DECLARE(uch, window, 2L*WSIZE);
DECLARE(ush, tab_prefix, 1L<<BITS);

long icnt, ocnt, osize;
uch *ibuf, *obuf;

long bytes_in;		/* number of input bytes */
long bytes_out;   	/* number of output bytes */
int level;        	/* compression level */
unsigned insize;       	/* valid bytes in inbuf */
unsigned inptr;  	/* index of net byte to be processed in inbuf */
unsigned outcnt;  	/* bytes in output buffer */


/* =====================================================================
 * Deflate in to out; return out & its size.
 */
int zip(int *buflen, uch **buffer, int lvl)
{
    int method;			/* compression method */
    uch flags = 0;         	/* general purpose bit flags */
    ush attr = 0;          	/* ascii/binary flag */
    ush deflate_flags = 0; 	/* pkzip -es, -en or -ex equivalent */

    level = lvl;
    icnt = *buflen;
    ibuf = *buffer;
    ocnt = 0;
    osize = 10000;
    obuf = (uch*)malloc(osize);
    
    if (icnt < 1) return(icnt);
    
    outcnt = 0;
    insize = inptr = 0;
    bytes_in = bytes_out = 0L;

    /* Allocate all global buffers (for DYN_ALLOC option) */
    ALLOC(uch, inbuf,  INBUFSIZ +INBUF_EXTRA);
    ALLOC(uch, outbuf, OUTBUFSIZ+OUTBUF_EXTRA);
    ALLOC(ush, d_buf,  DIST_BUFSIZE);
    ALLOC(uch, window, 2L*WSIZE);
    ALLOC(ush, tab_prefix, 1L<<BITS);
    
    /* put our special zip header */
    method = DEFLATED;
    put_byte(GZIP_MAGIC[0]); /* magic header */
    put_byte(GZIP_MAGIC[1]);
    put_byte(DEFLATED);      /* compression method */
    put_long(icnt);

    /* Create deflated buffer */
    bi_init(NO_FILE);
    ct_init(&attr, &method);
    lm_init(level, &deflate_flags);

    (void)deflate();
    
    flush_outbuf();

    /* return deflated buffer */
    free((char*)*buffer);
    *buflen = ocnt;
    *buffer = obuf;

    /* free global buffers */
    FREE(inbuf);
    FREE(outbuf);
    FREE(d_buf);
    FREE(window);
    FREE(tab_prefix);

    return(ocnt);
}

#ifdef TESTZIP

main(int argc, char **argv)
{
   int fd, n, m, nbuf;
   uch *buf;
   
   fd = open(argv[1], O_RDONLY);
   nbuf = lseek(fd, (off_t)0, SEEK_END);
   lseek(fd, (off_t)0, SEEK_SET);
   
   buf = (uch*)malloc(nbuf);
   n = 0;
   while (n<nbuf)
   {
      m = read(fd, &buf[n], nbuf-n);
      if (m <= 0)
      {
         perror("read");
         exit(0);
      }
      n += m;
   }
   
   m = 9;
   if (argc >= 3) sscanf(argv[2], "%d", &m);
   
   zip(&nbuf, &buf, m);
   printf("zip: %d==>%d\n", n, nbuf);
   
   fd = open("tst.zip", O_WRONLY|O_CREAT);
   n = 0;
   while(n<nbuf)
   {
      m = write(fd, &buf[n], nbuf-n);
      if (m <= 0)
      {
         perror("write");
         exit(0);
      }
      n += m;
   }
}

#endif
