C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (nsamp, nsi, ntrc, nrec, iform, ntap, otap, 
     :     ftap, geometry, mnemonic, mnemonicX, mnemonicY, map,
     :     reverse, notseq )

#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, iform

      character   ntap*(*), otap*(*), ftap*(*), mnemonic*(*)
      character   mnemonicX*(*), mnemonicY*(*)

      logical geometry, reverse, map, notseq
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*) ' format of data        =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      if ( .not. reverse ) then
         write(LERR,*) ' output data set name  =  ', otap
         write(LERR,*) ' input flat file name  =  ', ftap
      else
         write(LERR,*) ' using reverse (-R) option:'
         write(LERR,*) ' '
         write(LERR,*) ' no output seismic data set will be written'
         write(LERR,*) ' output flat file name  =  ', ftap
      endif

      if ( map ) write(LERR,*)' Getting one value per record'

      if ( geometry ) then
         write(LERR,*)' '
         write(LERR,*) ' using geometry option'
         write(LERR,*)' '
         write(LERR,*) ' Index header mnemonic =  ', mnemonic
         write(LERR,*) ' X coord mnemonic =  ', mnemonicX
         write(LERR,*) ' Y coord mnemonic =  ', mnemonicY
      else
         write(LERR,*)' '
         write(LERR,*) ' trace header mnemonic =  ', mnemonic
         write(LERR,*)' '
      endif

      if (notseq) then
         write(LERR,*)' '
         write(LERR,*)' using -actual option:'
         write(LERR,*)' Input flat file refers to actual',
     :' Rec,Trc values, NOT sequential Rec,Trc values'
         write(LERR,*)' '
      endif

      return
      end
