C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GeoQuestHeader ( luout, Xmax, Xmin, dX, Ymax, Ymin, dY,
     :     NumXnodes, NumYnodes, zunits, xyunits, Xorigin, Yorigin, 
     :     Azimuth,  key, TransposeFlag ) 

c writes GeoQuest header cards to output GeoQuest Grid File
 
#include <f77/iounit.h>

      integer  luout, zunits, xyunits, NumXnodes, NumYnodes

      real Xmax, Xmin, dX, Ymax, Ymin, dY
      real Xorigin, Yorigin, Azimuth

      character key*1, TransposeFlag*1, Horizon*16, Title*60

c for now I cannot read back Horizon or Title so set them to blanks

      Horizon = ' '
      Title = ' '
      
      write( luout, 10) key, zunits, xyunits, NumXnodes,
     :     NumYnodes, dX, dY
 10   format(A2,I2,I2,I5,I5,2E15.7)

      write ( luout, '(1X,4E15.7)') Xmin, Xmax, Ymin, Ymax

      if ( key .eq. 'B' ) then
         write ( luout, 20) Xorigin, Yorigin, Azimuth, 
     :        TransposeFlag
 20      format(1X,2E15.7,F10.3,A1)

         write ( luout, '(1X,A16,A60)') Horizon, Title
      endif

      return
      end

