C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GeoQuestOut( luout, tri, nsampo )
 
      integer luout, nsampo, pointer
      integer numCardsToWrite, numOnLastCard

      real tri(nsampo)

      pointer = 0

c write out data in GeoQuest 8(E15.7) format.  This of course means that
c I have to watch nsampo as a modulus of 8 and pad the last line in the 
c current value of y out to 8 values if required

c determine number of cards to write

      numOnLastCard = mod (nsampo,8)

      if ( numOnLastCard .ne. 0 ) then
         numCardsToWrite = nsampo / 8 + 1
      else
         numCardsToWrite = nsampo / 8 
      endif

      do i = 1, numCardsToWrite
         if ( i .ne. numCardsToWrite) then
 
c write full 8 value cards 

            write(luout,'(1X,8(E15.7))') (tri(pointer+j),j=1,8)
            pointer = pointer + 8
         else
 
c write last partial card 

            write(luout,'(1X,8(E15.7))') 
     :           (tri(pointer+j),j=1,numOnLastCard)
         endif
      enddo

      return
      end
      
