C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetGeoQuestLimits ( luin, Xmax, Xmin, dX, Ymax, Ymin,  
     :     dY, FirstIsX, NumXnodes, NumYnodes, zunits, xyunits, key,
     :     Xorigin, Yorigin, Azimuth, TransposeFlag, Horizon, Title)

c gets limits from GeoQuest grid file
 
#include <f77/iounit.h>

      integer  zunits, xyunits, NumXnodes, NumYnodes

      real Xmax, Xmin, dX, Ymax, Ymin, dY
      real Xorigin, Yorigin, Azimuth

      character key*1, TransposeFlag*1, Horizon*16, Title*60
      
      logical FirstIsX
      
      Xmax = 0.
      Xmin = 0.
      Ymax = 0.
      Ymin = 0.
      dX = 0.
      dY = 0.

c since GeoQuest Grids start at Xmin, Ymin and go through X first then Y
c FirstIsX is always true.

      FirstIsX = .true.

      read( luin, 10, end=990, err=991) key, zunits, xyunits, NumXnodes,
     :     NumYnodes, dX, dY
 10   format(1X,A1,I2,I2,I5,I5,2E15.7)

      read ( luin, '(1X,4E15.7)', end=990, err=991) Xmin, Xmax, Ymin, 
     :     Ymax

      if ( key .eq. 'B' ) then

c for now I will read this stuff just to get past the cards.  Maybe some
c day I'll do something with it

         read ( luin, 20, end=990, err=991) Xorigin, Yorigin, Azimuth, 
     :        TransposeFlag
 20      format(1X,2E15.7,F10.3,A1)

         read ( luin, '(1X,A16,A60)', end=990, err=991) Horizon, Title

      endif

      return

 990  write(LERR,*)'XYZ2SIS: premature EOF on input'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'XYZ2SIS: premature EOF on input'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop
 991  write(LERR,*)'XYZ2SIS: error reading input'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'XYZ2SIS: error reading input' 
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop
      end

