C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadGeoQuestTrace( luin, tri, nsampo, nullvalue, 
     :     nullreplacevalue )
       
c read in data in GeoQuest (8(E15.7)) format and load into
c tri. 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer luin, nsampo, numCardsToRead, numOnLastCard, pointer

      real tri(nsampo), triHold(SZLNHD), nullvalue, nullreplacevalue

      pointer = 1
      call vclr(tri,1,nsampo)
	
c determine number of GeoQuest Grid Data Cards to read
c for this Y value

      if ( mod (nsampo,8) .ne. 0 ) then
	 numCardsToRead = nsampo / 8 + 1
         numOnLastCard = int ( mod (nsampo,8) * 8.0 )
      else
	 numCardsToRead = nsampo / 8
      endif
	   
      do i = 1, numCardsToRead
	 read(luin,'(1X,8(E15.7))',end=990,err=991) (triHold(j),j=1,8)
	 if ( i .ne. numCardsToRead ) then
	    call vmov ( triHold, 1, tri(pointer), 1, 8 )
	    pointer = pointer + 8
	 else
	    call vmov ( triHold, 1, tri(pointer), 1, numOnLastCard )
	 endif
      enddo
   
      do i = 1, nsampo
         if ( abs(tri(i) - nullvalue) .lt. 1.e-30 ) 
     :        tri(i) = nullreplacevalue
      enddo

      return

 990  write(LERR,*)' ' 
      write(LERR,*)'XYZ2SIS: premature EOF on GeoQuest Grid File'
      write(LERR,*)'FATAL' 
      write(LERR,*)' ' 
      stop

 991  write(LERR,*)' ' 
      write(LERR,*)'XYZ2SIS: error reading GeoQuestGridFile'
      write(LERR,*)'FATAL' 
      write(LERR,*)' ' 
      stop

      end
	
