C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----------------------- xyz2sis -----------------------
c
c Author P.G.A. Garossino
c
c xyz2sis reads [x,y,z] data in either Zycor [x,y,z] or GeoQuest Grid 
c Data Card format and outputs a Y trace record of X samples per trace.  
c In its reverse mode it reads an USP format dataset and
c outputs either one of the above.  The default input format is
c Zycor.
c
c If the input is GeoQuest, piping is allowed on output.  If the input
c is Zycor no piping is allowed on output as I am jumping around
c in the output disk file to drop the data in the correct location.
c
c Changes: 

c          - put in an option -believe for OJ in Norway so he can use
c            flat 2 format without the nasty inverse sample logic.
c            [July, 2, 2002 - Garossino]

c          - made seismic output amplitudes f12.3 for Marty Albertin
c            with the exception of the e12.3 used by Guto below
c            [May 21, 2002 - Garossino]

c          - added mnemonic format detection to provide ability to 
c            automatically handle floating point headers values. If
c            any of the desired header mnemonics correspond to a floating
c            point entry all will be reported in real f15.3 format.
c            [Aug/98 - Garossino]

c          - made flat1 output e12.3 for Guto
c            [Feb/97 - Garossino]

c          - put in default null value for GeoQuest of -1.e30 
c            [Jun/96 - Garossino]
c
c          - put in -flat1 output format for Todd Jones 
c            [trace, sample, amplitude] [Jun/96 - Garossino]
c
c          - fix -s -e functionality on -R case with usp data 
c            input.  Up to now this has not worked [Jun/96 - Garossino]
c
c          - add -amp[] option and switch to formatted -R output to work
c            on cray machines. [Jun/96 - Garossino]
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables

c get machine dependent parameters

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables

      integer     lhed( SZLNHD )
      integer     nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin, luout, lbytes, nbytes, obytes
      integer     argis, ist, iend, irs, ire, ns, ne
      integer     JJ, KK

      real        tri(SZLNHD)
      real        rhed(SZLNHD)

      character   name*8, ntap*255, otap*255

      logical     verbos

c dimension program specific variables 

      integer nbyt, NumXnodes, NumYnodes, zunits, xyunits
      integer ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1
      integer ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2
      integer ifmt_Wrd3, l_Wrd3, ln_Wrd3, Wrd3
      integer ifmt_Wrd4, l_Wrd4, ln_Wrd4, Wrd4
      integer ifmt_TmMsSL, l_TmMsSL, ln_TmMsSL
      integer ifmt_TmSlIn, l_TmSlIn, ln_TmSlIn
      integer ifmt_TmMsFS, l_TmMsFS, ln_TmMsFS
      integer ifmt_NTrLnS, l_NTrLnS, ln_NTrLnS
      integer ifmt_ILCLIn, l_ILCLIn, ln_ILCLIn
      integer ifmt_CLCLIn, l_CLCLIn, ln_CLCLIn
      integer ifmt_MnUHTm, l_MnUHTm, ln_MnUHTm
      integer ifmt_MxUHTm, l_MxUHTm, ln_MxUHTm
      integer ifmt_NmSpMi, l_NmSpMi, ln_NmSpMi
      integer ifmt_MutVel, l_MutVel, ln_MutVel
      integer ifmt_AERcPr, l_AERcPr, ln_AERcPr
      integer ifmt_Crew01, l_Crew01, ln_Crew01
      integer ifmt_EqpCod, l_EqpCod, ln_EqpCod
      integer ifmt_HlhEnt, l_HlhEnt, ln_HlhEnt
      integer ifmt_HlhByt, l_HlhByt, ln_HlhByt

      real Xmax, Xmin, Ymax, Ymin, dX, dY, y
      real Xorigin, Yorigin, Azimuth
      real NullValue, NullReplaceValue
      real r_Wrd1, r_Wrd2, r_Wrd3, r_Wrd4

      character Horizon*16, Title*60, key*1
      character mnemonic1*6, mnemonic2*6
      character mnemonic3*6, mnemonic4*6

      logical reverse, FirstIsX, GeoQuest, Swap, flat, flat1, flat2
      logical floating_point, flat2_believe

      equivalence (lhed(1), rhed(1))
c initialize necessary variables and trace memory

      data name/'XYZ2SIS'/
      data lbytes/0/
      data floating_point/.false./

      do i = 1,SZLNHD
         lhed(i) = 0
      enddo

c get online help if necessary 

      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c printout        

#include <f77/open.h>

c get command line parameters

      call cmdln ( ntap, otap, ist, iend, irs, ire, ns, ne, 
     :     mnemonic1, mnemonic2, mnemonic3, mnemonic4, reverse, 
     :     NullValue, NullReplaceValue, Swap, GeoQuest, flat, flat1, 
     :     flat2, flat2_believe, verbos )

c get logical units 

      IF(reverse)then

         call getln(luin,ntap,'r',0)

c handle output pipe if requested

         if ( otap .eq. ' ' ) then
            if ( GeoQuest .or. flat .or. flat1 ) then
               luout = LOT
            else
               write(LERR,*)' '
               write(LERR,*)' Cannot pipe out Zycor format output. '
               write(LERR,*)' You must supply an output filename'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'XYZ2SIS: '
               write(LER,*)' Cannot pipe out Zycor format output. '
               write(LER,*)' You must supply an output filename'
               write(LER,*)'FATAL'
               stop
            endif
         else
            call alloclun(luout)
            leotap = lenth(otap)
            open(unit=luout,file=otap(1:leotap),status='unknown',
     :           err=991)
         endif

      ELSE
         lentap = lenth(ntap)
	 if (lentap .eq. 0) then
	   write(LERR,*)' XYZ2SIS: '
	   write(LERR,*)'        no input file specified'
	   write(LERR,*)' FATAL'
	   write(LER,*)' XYZ2SIS: '
	   write(LER,*)'        no input file specified'
	   write(LER,*)' FATAL'
	   stop 100
	 endif
         call alloclun(luin)
         open(unit=luin,file=ntap(1:lentap),status='old',err=990)
         call getln (luout,otap,'w+',1)
      ENDIF

      call  sislgbuf( luout, 'off')

c build/read line header as required 

      IF (reverse) THEN
      
         lbytes = 0
         call rtape(luin,lhed,lbytes)
         write(LERR,*)'lbytes= ',lbytes

         if(lbytes .eq. 0) then
            write(LERR,*)'no header read on unit ',ntap
            write(LERR,*)'FATAL'
            write(LERR,*)'Check existence of file & rerun'
            write(LER,*)' '
            write(LER,*)'xyz2sis: no header read on unit ',ntap
            write(LER,*)'Check existence of file & rerun'
            write(LER,*)'FATAL'
            stop
         endif

         call saver ( lhed, 'NumSmp', nsamp, LINHED )
         call saver ( lhed, 'SmpInt', nsi, LINHED )
         call saver ( lhed, 'NumRec', nrec, LINHED )
         call saver ( lhed, 'NumTrc', ntrc, LINHED )
         call saver ( lhed, 'Format', iform, LINHED )

         call savelu ( 'TmMsSl',ifmt_TmMsSl, l_TmMsSl, ln_TmMsSL, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_TmMsSl, l_TmMsSl, ln_TmMsSL, Xmin, 
     :        LINEHEADER )

         call savelu ( 'TmSlIn', ifmt_TmSlIn, l_TmSlIn, ln_TmSlIn, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_TmSlIn, l_TmSlIn, ln_TmSlIn, Xmax, 
     :        LINEHEADER )

         call savelu ( 'TmMsFS', ifmt_TmMsFS, l_TmMsFS, ln_TmMsFS, 
     :        LINEHEADER )
         call saver2 ( lhed,  ifmt_TmMsFS, l_TmMsFS, ln_TmMsFS, Ymin, 
     :        LINEHEADER )

         call savelu ('NTrLnS', ifmt_NTrLnS, l_NTrLnS, ln_NTrLnS, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_NTrLnS, l_NTrLnS, ln_NTrLnS, iYmax, 
     :        LINEHEADER )
         Ymax = float(iYmax)

         call savelu ( 'ILClIn', ifmt_ILClIn, l_ILClIn, ln_ILClIn,
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_ILClIn, l_ILClIn, ln_ILClIn, dX ,
     :        LINEHEADER )

         call savelu ('CLClIn', ifmt_CLClIn, l_CLClIn, ln_CLClIn, 
     :        LINEHEADER )
         call saver2 ( lhed, ifmt_CLClIn, l_CLClIn, ln_CLClIn, dY, 
     :        LINEHEADER )

         if (GeoQuest) then

            call savelu ( 'MnUHTm', ifmt_MnUHTm, l_MnUHTm, ln_MnUHTm, 
     :           LINEHEADER )
            call saver2 ( lhed, ifmt_MnUHTm, l_MnUHTm, ln_MnUHTm, 
     :           zunits, LINEHEADER )
            call savelu ( 'MxUHTm', ifmt_MxUHTm, l_MxUHTm, ln_MxUHTm, 
     :           LINEHEADER )
            call saver2 ( lhed, ifmt_MxUHTm, l_MxUHTm, ln_MxUHTm, 
     :           xyunits, LINEHEADER )
            call savelu ( 'NmSpMi', ifmt_NmSpMi, l_NmSpMi, ln_NmSpMi, 
     :           LINEHEADER )
            call saver2 ( lhed, ifmt_NmSpMi, l_NmSpMi, ln_NmSpMi, 
     :           Xorigin, LINEHEADER )
            call savelu ( 'MutVel', ifmt_MutVel, l_MutVel, ln_MutVel, 
     :           LINEHEADER )
            call saver2( lhed, ifmt_MutVel, l_MutVel, ln_MutVel, 
     :           Yorigin, LINEHEADER )
            call savelu ( 'AERcPr', ifmt_AERcPr, l_AERcPr, ln_AERcPr, 
     :           LINEHEADER )
            call saver2( lhed, ifmt_AERcPr, l_AERcPr, ln_AERcPr, 
     :           Azimuth, LINEHEADER )
            call savelu ( 'Crew01', ifmt_Crew01, l_Crew01, ln_Crew01, 
     :           LINEHEADER )
            call saver2( lhed, ifmt_Crew01, l_Crew01, ln_Crew01, key, 
     :           LINEHEADER )
            call savelu ( 'EqpCod', ifmt_EqpCod, l_EqpCod, ln_EqpCod, 
     :           LINEHEADER )
            call saver2( lhed, ifmt_EqpCod, l_EqpCod, ln_EqpCod, 
     :           TransposeFlag, LINEHEADER)
         endif

         if(nsamp .gt. SZSMPM) nsamp=SZSMPM

c set record start and end defaults 

         if(irs .eq. 0) irs=1
         if(ire .eq. 0) ire=nrec
         if(ns.eq.0)ns = 1
         if(ne.eq.0)ne = ntrc

c determine number of records to process 

         nreco = ire - irs +1

c convert start and end time to start and end sample 

         if ( nsi .eq. 0 ) then
            write(LERR,*)' '
            write(LERR,*)' Zero sample interval found in input line'
            write(LERR,*)' header.  This will be set to 1.  If you'
            write(LERR,*)' do not wish this value then use utop -dt'
            write(LERR,*)' to change the lineheader entry in your input'
            write(LERR,*)' dataset and resubmit'
            write(LERR,*)'WARNING '
            write(LERR,*)' '
            write(LERR,*)'XYZ2SIS: '
            write(LERR,*)' Zero sample interval found in input line'
            write(LERR,*)' header.  This will be set to 1.  If you'
            write(LERR,*)' do not wish this value then use utop -dt'
            write(LERR,*)' to change the lineheader entry in your input'
            write(LERR,*)' dataset and resubmit'
            write(LERR,*)'WARNING '
            nsi = 1
         endif

         ist=ist/nsi
         iend=iend/nsi
         if(ist .lt. 1) ist=1
         if(iend .lt. 1) iend=nsamp

c determine number of output samples 

         nsampo=iend-ist+1

c determine number of output traces 

         ntrco = ne - ns + 1

c if GeoQuest grid file required, write the grid file header

         if ( GeoQuest ) 
     :        Call GeoQuestHeader(luout, Xmax, Xmin, dX, Ymax, Ymin, dY,
     :        nsampo, ntrco, zunits, xyunits, Xorigin, Yorigin, Azimuth,
     :        key, TransposeFlag )
 
      ELSE

c Going Forward to an output USP dataset from either Zycor or Geoquest input

c assign header values for the following 

         if (GeoQuest) then
            call GetGeoQuestLimits(luin, Xmax, Xmin, dX, Ymax, Ymin, 
     :           dY, FirstIsX, NumXnodes, NumYnodes, zunits, xyunits, 
     :           key, Xorigin, Yorigin, Azimuth, TransposeFlag, Horizon, 
     :           Title)
            nsampo = NumXnodes
            ntrco = NumYnodes

         elseif (flat2) then
c input is flat2 format

            call ReadFlat2Head ( luin, ntrco, nreco, nsampo, nsi)
   
         else
c default is Zycor input

            call GetZycorLimits ( luin, Xmax, Xmin, dX, Ymax, Ymin, dY, 
     :           FirstIsX )
            nsampo = nint(abs(Xmax - Xmin)/abs(dX)) + 1
            ntrco = nint(abs(Ymax - Ymin)/abs(dY)) + 1
         endif

         if (.not. flat2) then
            nreco = 1
            nsi = 1
            irs = 1
            ire = nreco
            ns = 1
            ne = ntrco
         endif

         lbytes = HSTOFF
         nbyt = 2 * SZHFWD
         iform = 3

c set HLH to zero length

         call savelu ( 'HlhEnt', ifmt_HlhEnt, l_HlhEnt, ln_HlhEnt, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_HlhEnt, l_HlhEnt, ln_HlhEnt, 0 , 
     :        LINEHEADER )
         call savelu ( 'HlhByt', ifmt_HlhByt, l_HlhByt, ln_HlhByt, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_HlhByt, l_HlhByt, ln_HlhByt, nbyt, 
     :        LINEHEADER )

c do this only if not flat2 option
        if (.not. flat2) then
c store Xmin --> TmMsSl
c store Xmax --> TmSlIn
c store Ymin --> TmMsFS
c store Ymax --> NTrLnS
c store dX   --> ILClIn
c store dY   --> CLClIn
c
c GeoQuest Only   store zunits  --> MnUHTm
c GeoQuest Only   store xyunits --> MxUHTm
c GeoQuest Only   store Xorigin --> NmSpMi
c GeoQuest Only   store Yorigin --> MutVel
c GeoQuest Only   store Azimuth --> AERcPr as an integer
c GeoQuest Only   store key     --> Crew01
c GeoQuest Only   store TransposeFlag --> EqpCod

         call savelu ( 'TmMsSl', ifmt_TmMsSl, l_TmMsSl, ln_TmMsSl, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_TmMsSl, l_TmMsSl, ln_TmMsSl, Xmin, 
     :        LINEHEADER )
         call savelu ( 'TmSlIn', ifmt_TmSlIn, l_TmSlIn, ln_TmSlIn,
     :        LINEHEADER )
         call savew2( lhed, ifmt_TmSlIn, l_TmSlIn, ln_TmSlIn, Xmax, 
     :        LINEHEADER )
         call savelu ( 'TmMsFS', ifmt_TmMsFS, l_TmMsFS, ln_TmMsFS, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_TmMsFS, l_TmMsFS, ln_TmMsFS, Ymin, 
     :        LINEHEADER )
         call savelu ( 'NTrLnS', ifmt_NTrLnS, l_NTrLnS, ln_NTrLnS, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_NTrLnS, l_NTrLnS, ln_NTrLnS, 
     :        nint(Ymax), LINEHEADER )
         call savelu ( 'ILClIn', ifmt_ILClIn, l_ILClIn, ln_ILClIn, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_ILClIn, l_ILClIn, ln_ILClIn, dX, 
     :        LINEHEADER )
         call savelu ( 'CLClIn', ifmt_CLClIn, l_CLClIn, ln_CLClIn, 
     :        LINEHEADER )
         call savew2( lhed, ifmt_CLClIn, l_CLClIn, ln_CLClIn, dY, 
     :        LINEHEADER )

         if (GeoQuest) then

c additional GeoQuest header values

            call savelu ( 'MnUHTm', ifmt_MnUHTm, l_MnUHTm, ln_MnUHTm, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_MnUHTm, l_MnUHTm, ln_MnUHTm, zunits,
     :           LINEHEADER )
            call savelu ( 'MxUHTm', ifmt_MxUHTm, l_MxUHTm, ln_MxUHTm, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_MxUHTm, l_MxUHTm, ln_MxUHTm, 
     :           xyunits, LINEHEADER )
            call savelu ( 'NmSpMi', ifmt_NmSpMi, l_NmSpMi, ln_NmSpMi, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_NmSpMi, l_NmSpMi, ln_NmSpMi, 
     :           Xorigin, LINEHEADER )
            call savelu ( 'MutVel', ifmt_MutVel, l_MutVel, ln_MutVel, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_MutVel, l_MutVel, ln_MutVel, 
     :           Yorigin, LINEHEADER )
            call savelu ( 'AERcPr', ifmt_AERcPr, l_AERcPr, ln_AERcPr, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_AERcPr, l_AERcPr, ln_AERcPr, 
     :           Azimuth, LINEHEADER )
            call savelu ( 'Crew01', ifmt_Crew01, l_Crew01, ln_Crew01, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_Crew01, l_Crew01, ln_Crew01, key, 
     :           LINEHEADER )
            call savelu ( 'EqpCod', ifmt_EqpCod, l_EqpCod, ln_EqpCod, 
     :           LINEHEADER )
            call savew2( lhed, ifmt_EqpCod, l_EqpCod, ln_EqpCod, 
     :           TransposeFlag, LINEHEADER )
         endif

        endif

         call savew( lhed, 'Format', iform , LINHED)
         call savew( lhed, 'NumSmp', nsampo, LINHED)
         call savew( lhed, 'NumRec', nreco , LINHED)
         call savew( lhed, 'NumTrc', ntrco , LINHED)
         call savew( lhed, 'SmpInt', nsi   , LINHED)
         obytes = SZTRHD + SZSMPD * nsampo
         
         call savhlh(lhed,lbytes,lbyout)
         call wrtape(luout,lhed,lbyout)

c clear header space for trace data

         do i = 1,SZLNHD
            lhed(i) = 0
         enddo

      ENDIF

c printout 

      call verbal( nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco,  
     :     mnemonic1, mnemonic2, mnemonic3, mnemonic4, iform, ist, iend,
     :     ns, ne, irs, ire, reverse, NullValue, NullReplaceValue, 
     :     GeoQuest, ntap, otap, Swap, Horizon, Title, flat, flat1, 
     :     flat2, flat2_believe, verbos )

c process data 

      IF ( reverse .or. flat .or. flat1 ) then

c Handle input USP format data 

         call recskp(1,irs-1,luin,ntrc,lhed)

c set up hooks to header mnemonics only if used

         if (mnemonic1 .ne. ' ') then
            call savelu(mnemonic1, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :           TRACEHEADER )
            if ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .or.
     :           ifmt_Wrd1 .eq. SAVE_FKFLT_DEF ) floating_point = .true.
         endif
         if (mnemonic2 .ne. ' ') then
            call savelu(mnemonic2, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :           TRACEHEADER )
            if ( ifmt_Wrd2 .eq. SAVE_FLOAT_DEF .or.
     :           ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) floating_point = .true.
         endif
         if (mnemonic3 .ne. ' ') then
            call savelu(mnemonic3, ifmt_Wrd3, l_Wrd3, ln_Wrd3, 
     :           TRACEHEADER )
            if ( ifmt_Wrd3 .eq. SAVE_FLOAT_DEF .or.
     :           ifmt_Wrd3 .eq. SAVE_FKFLT_DEF ) floating_point = .true.
         endif
         if (mnemonic4 .ne. ' ') then
            call savelu(mnemonic4, ifmt_Wrd4, l_Wrd4, ln_Wrd4, 
     :           TRACEHEADER )
            if ( ifmt_Wrd4 .eq. SAVE_FLOAT_DEF .or.
     :           ifmt_Wrd4 .eq. SAVE_FKFLT_DEF ) floating_point = .true.
         endif

c if Xmin etc. is not defined then the user is accessing a USP dataset
c that was not converted from Zycor or Qeoquest.  In this instance he
c is looking for output [x,y,z] data where x = trace, y = sample, z = value

         DO 100 JJ = irs, ire

c skip to desired trace 

            call trcskp(jj,1,ns-1,luin,ntrc,lhed)

            DO 99 KK = ns,ne

               nbytes = 0
               call rtape(luin,lhed,nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',KK
                  go to 999
               endif

               call vmov(lhed(ITHWP1+ist-1),1,tri,1,nsampo)

               if ( flat ) then

                  if ( mnemonic1 .eq. ' ' .and. 
     :                 mnemonic2 .eq. ' ' .and. 
     :                 mnemonic3 .eq. ' ' .and. 
     :                 mnemonic4 .eq. ' ' ) then

c no additional header entries requested

                     do i = ist, iend
                        write(luout,'(f12.0,2x,f12.3)') float(i)*nsi,
     :                       tri(i-ist+1)
                     enddo

                  elseif ( mnemonic1 .ne. ' ' .and. 
     :                     mnemonic2 .eq. ' ' .and. 
     :                     mnemonic3 .eq. ' ' .and. 
     :                     mnemonic4 .eq. ' ' ) then

c one additional header entries requested

                     if ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd1 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       r_Wrd1, TRACEHEADER )

c report floating point header value

                        do i = ist, iend
                           write(luout,'(f15.3,2x,f12.0,2x,f12.3)') 
     :                          Wrd1,float(i)*nsi, tri(i-ist+1)
                        enddo

                     else

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       Wrd1, TRACEHEADER )

c report integer header value

                        do i = ist, iend
                           write(luout,'(i10,2x,f12.0,2x,f12.3)') Wrd1,
     :                          float(i)*nsi, tri(i-ist+1)
                        enddo

                     endif

                  elseif ( mnemonic1 .ne. ' ' .and. 
     :                     mnemonic2 .ne. ' ' .and.
     :                     mnemonic3 .eq. ' ' .and. 
     :                     mnemonic4 .eq. ' '  ) then

c two additional header entries requested

                     if ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd1 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       r_Wrd1, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       Wrd1, TRACEHEADER )
                        r_Wrd1 = float(Wrd1)
                     endif
                   
                     if ( ifmt_Wrd2 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       r_Wrd2, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       Wrd2, TRACEHEADER )
                        r_Wrd2 = float(Wrd2)
                     endif

                     if ( floating_point ) then

c at least one entry was floating point so use floating point report format

                        do i = ist,iend
                           write(luout,'(2(f15.3,2x),f12.0,2x,f12.3)') 
     :                          r_Wrd1, r_Wrd2, float(i)*nsi, 
     :                          tri(i-ist+1)
                        enddo
                     else
                        do i = ist,iend
                           write(luout,'(2(i10,2x),f12.0,2x,f12.3)') 
     :                          Wrd1, Wrd2, float(i)*nsi, tri(i-ist+1)
                        enddo
                     endif

                  elseif ( mnemonic1 .ne. ' ' .and. 
     :                     mnemonic2 .ne. ' ' .and.
     :                     mnemonic3 .ne. ' ' .and. 
     :                     mnemonic4 .eq. ' '  ) then

c three additional header entries requested

                     if ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd1 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       r_Wrd1, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       Wrd1, TRACEHEADER )
                        r_Wrd1 = float(Wrd1)
                     endif
                   
                     if ( ifmt_Wrd2 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       r_Wrd2, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       Wrd2, TRACEHEADER )
                        r_Wrd2 = float(Wrd2)
                     endif
                   
                     if ( ifmt_Wrd3 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd3 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd3, l_Wrd3, ln_Wrd3, 
     :                       r_Wrd3, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd3, l_Wrd3, ln_Wrd3, 
     :                       Wrd3, TRACEHEADER )
                        r_Wrd3 = float(Wrd3)
                     endif
                   
c at least one entry was floating point so use floating point report format

                     if ( floating_point ) then
                        do i = ist,iend
                           write(luout,'(3(f15.3,2x),f12.0,2x,f12.3)') 
     :                          r_Wrd1, r_Wrd2, r_Wrd3, float(i)*nsi, 
     :                          tri(i-ist+1)
                        enddo
                     else
                        do i = ist,iend
                           write(luout,'(3(i10,2x),f12.0,2x,f12.3)')  
     :                          Wrd1,Wrd2, Wrd3, float(i)*nsi, 
     :                          tri(i-ist+1)
                        enddo
                     endif

                  elseif ( mnemonic1 .ne. ' ' .and. 
     :                     mnemonic2 .ne. ' ' .and.
     :                     mnemonic3 .ne. ' ' .and. 
     :                     mnemonic4 .ne. ' '  ) then

c four additional header entries requested

                     if ( ifmt_Wrd1 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd1 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       r_Wrd1, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd1, l_Wrd1, ln_Wrd1, 
     :                       Wrd1, TRACEHEADER )
                        r_Wrd1 = float(Wrd1)
                     endif
                   
                     if ( ifmt_Wrd2 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd2 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       r_Wrd2, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd2, l_Wrd2, ln_Wrd2, 
     :                       Wrd2, TRACEHEADER )
                        r_Wrd2 = float(Wrd2)
                     endif
                   
                     if ( ifmt_Wrd3 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd3 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd3, l_Wrd3, ln_Wrd3, 
     :                       r_Wrd3, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd3, l_Wrd3, ln_Wrd3, 
     :                       Wrd3, TRACEHEADER )
                        r_Wrd3 = float(Wrd3)
                     endif
                   
                     if ( ifmt_Wrd4 .eq. SAVE_FLOAT_DEF .or.
     :                    ifmt_Wrd4 .eq. SAVE_FKFLT_DEF ) then

                        call saver2 ( lhed, ifmt_Wrd4, l_Wrd4, ln_Wrd4, 
     :                       r_Wrd4, TRACEHEADER )
                     else

                        call saver2 ( lhed, ifmt_Wrd4, l_Wrd4, ln_Wrd4, 
     :                       Wrd4, TRACEHEADER )
                        r_Wrd4 = float(Wrd4)
                     endif
                   
c at least one entry was floating point so use floating point report format

                     if ( floating_point ) then
                        do i = ist, iend
                           write(luout,'(4(f15.3,2x),f12.0,2x,f12.3)') 
     :                          r_Wrd1, r_Wrd2, r_Wrd3, r_Wrd4,
     :                          float(i)*nsi, tri(i-ist+1)
                        enddo
                     else
                        do i = ist, iend
                           write(luout,'(4(i10,2x),f12.0,2x,f12.3)') 
     :                          Wrd1, Wrd2, Wrd3, Wrd4, float(i)*nsi,
     :                          tri(i-ist+1)
                        enddo
                     endif
                  endif

               elseif ( flat1 ) then
                  x = float(KK)
                  do i = ist, iend
                     write(luout,'(2f12.0,e12.3)') x, float(i), 
     :                    tri(i-ist+1)
                  enddo
               else 
               
                  call saver(lhed,'SrPtYC',ivalue, TRACEHEADER )
                  y = float(ivalue)

c write appropriate grid file 

                  if ( GeoQuest ) then
                     Call GeoQuestOut( luout, tri, nsampo )
                  else
c default output format is Zycor
                     call ZycorOut( luout, tri, nsampo, Xmin, dX, y, 
     :                    Swap )
                  endif

               endif

 99         CONTINUE

c skip to end of record 

            call trcskp(jj,ne+1,ntrc,luin,ntrc,lhed)

 100     CONTINUE

      ELSE

c going forward to USP output from either Zycor or Geoquest input

         if ( .not. GeoQuest  ) then

c create output USP format filespace to skip around in 
c which precludes piping out in the Zycor case.
 
            do JJ=irs,ire
               do KK=ns,ne
                  call vclr(tri,1,nsampo)
                  call vmov(tri,1,lhed(ITHWP1),1,nsampo)
                  call wrtape(luout,lhed,obytes)
               enddo
            enddo
         endif

        if (.not. flat2) then
c this is for NOT flat2 option

         thisY = Ymin

         DO 110 JJ = 1,nreco
            
            DO 120 KK = 1,ntrco

               if ( GeoQuest ) then

c fill a trace from the GeoQuest Grid Data  

                  call ReadGeoQuestTrace( luin, tri, nsampo, NullValue, 
     :                 NullReplaceValue )
               else

c Handle Zycor Grid File

                  call ReadZycorTrace ( luin, tri, nsampo, y, NullValue, 
     :                 NullReplaceValue, FirstIsX )

c move pointer 

                  ioff = (JJ-1)*ntrco + KK
                  call sisseek (luout, ioff)
               endif

               call vmov ( tri, 1, lhed(ITHWP1), 1,  nsampo )

c write out trace  

               call savelu ( 'SrPtYC', ifmt, l_Ycorr, ln, TRACEHEADER )
               call savew2(lhed, ifmt, l_Ycorr, ln, nint(y), 
     :              TRACEHEADER )
               call savew( lhed, 'RecNum', JJ,TRCHED)
               call savew( lhed, 'TrcNum', KK,TRCHED)
               call wrtape( luout, lhed, obytes )

 120        CONTINUE

 110     CONTINUE
        else
c do this only for flat2 option

c create output USP format filespace to skip around in
c which precludes piping out in the flat2 case.
 
            call vmov(NullReplaceValue,0,rhed(ITHWP1),1,nsampo)
            do JJ=1,nreco
               call savew( lhed, 'RecNum', JJ,TRCHED)
               do KK=1,ntrco
                  call savew( lhed, 'TrcNum', KK,TRCHED)
                  call wrtape(luout,lhed,obytes)
               enddo
            enddo

         do while (1.eq.1)
            read (luin, *, end=89, err=88) itr, irec, ismp, value
            ioff = (irec - 1) * ntrco + itr
            call sisseek (luout,ioff)
            call rtape (luout, lhed, obytes)
            if (obytes.eq.0) then
                write(LERR,*)'XYZ2SIS:'
                write(LERR,*)' error occurred trying to read in'
                write(LERR,*)' a trace to update a sample'
                write(LERR,*)'FATAL'
                write(LER ,*)'XYZ2SIS:'
                write(LER ,*)' error occurred trying to read in'
                write(LER ,*)' a trace to update a sample'
                write(LER ,*)'FATAL'
                stop
            endif

            if ( flat2_believe ) then
               ksmp = ismp
            else
               ksmp = nsampo - ismp
            endif

            rhed(ITHWP1 + ksmp) = value
            call sisseek (luout, ioff)
            call wrtape (luout, lhed, obytes)
          enddo
   89     continue

         endif

      ENDIF

      if(reverse)then
         call lbclos(luin)
         close(luout)
      else
         close(luin)
         call lbclos(luout)
      endif

      write(LERR,*)'Normal Termination'
      write(LER,*)'xyz2sis: Normal Termination'
      stop

  88  write(LERR,*)' '
      write(LERR,*)'XYZ2SIS:'
      write(LERR,*)'        error reading flat2 input file ',
     :             ntap(1:lentap)
      write(LERR,*)'FATAL'
      write(LER ,*)' '
      write(LER ,*)'XYZ2SIS:'
      write(LER ,*)'        error reading flat2 input file ',
     :             ntap(1:lentap)
      write(LER ,*)'FATAL'

 990  write(LERR,*)' '
      write(LERR,*)'        error opening input file ',ntap(1:lentap)
      write(LERR,*)'        check spelling/permissions and try again'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' XYZ2SIS: '
      write(LER,*)'        error opening input file ',ntap(1:lentap)
      write(LER,*)'        check spelling/permissions and try again'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop

 991  write(LERR,*)' '
      write(LERR,*)'        error opening output file ',otap(1:leotap)
      write(LERR,*)'        check spelling/permissions and try again'
      write(LERR,*)'FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' XYZ2SIS: '
      write(LER,*)'        error opening output file ',otap(1:leotap)
      write(LER,*)'        check spelling/permissions and try again'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop

 999  continue

       if(reverse)then
          call lbclos(luin)
          close(luout)
       else
          close(luin)
          call lbclos(luout)
       endif

      write(LERR,*)'Abnormal Termination'
      write(LER,*)'xyz2sis: Abnormal Termination'
      stop
      end
