C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WGTAVG ( Z, Num_xyz, weight, neighborhood, 
     :     Nfound, r_Zhdrwrd, z_scalar ) 

C     ABSTRACT: perform a weighted average of an array on a neighborhood 
c               of points. 
C 
C                WHERE: z - array containing all input control z values
C                       Num_xyz  -  maximum size of "z" 
C                       weight  -  array of trace weights for neighbor functions
C                       neighborhood  - array of neighbor functions
C                       Nfound - number of neighbors 

c declare variables passed from calling routine

      integer Num_xyz, Nfound
      integer neighborhood( Num_xyz ) 

      real z( Num_xyz) 
      real weight(Num_xyz) 
      real z_scalar, r_Zhdrwrd

c declare local variables

      real SumOfTheWeights

c initialize variables

      r_Zhdrwrd = 0.
      SumOfTheWeights         = 0.0
      z_sum = 0.0

C compute the weighted averaged velocity function 
C  2- APPLY THE WEIGHT TO THE VELOCITY FUNCTION 
C  3- SUM THE WEIGHTED VELOCITY FUNCTIONS 

      DO J = 1, Nfound 

C  for every neighbor, get the z value
c  apply the appropriate weight to the velocity function 

         z_sum = z_sum + weight(J) * z( neighborhood(J) ) 

         SumOfTheWeights = weight(J) + SumOfTheWeights 

      ENDDO

C Normalize trace by weights of the contributors and multiply by scalar

      r_Zhdrwrd = z_scalar * ( z_sum / SumOfTheWeights )

      return 
      end 
