C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------zeco-----------------------------------------72
c
c Author P.G.A. Garossino at request of Sondra Rothe (AFE) 
c
c zeco reads data in USP format one trace at a time, accumulates stats
c on first, second and third zero crossings, and writes output in xgraph
c format to allow a histogram plot of the results.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables

      integer   itr( SZLNHD )
      integer   nsamp, nsampo, nsi, ntrc, nrec, iform
      integer   luin, lbytes, nbytes, luout
      integer   argis, ist, iend, irs, ire, ns, ne
      integer   JJ, KK

      real   tri(SZSMPM)

      character   name*4, ntap*255, otap*255

      logical     verbos

c dimension program specific variables

      integer     graph_max, first_max, second_max, third_max, length

c dimension dynamic memory allocation variables

      integer     errcd1, errcd2, errcd3, abort

      real        first, second, third

      pointer     (wkadr1, first(2000000))
      pointer     (wkadr2, second(2000000))
      pointer     (wkadr3, third(2000000))

      character   First1*20, Second1*21, Third1*20

c initialize necessary variables 

      data name/'ZECO'/
      data luin/1/, lbytes/0/, luout/6/, graph_max/0/
      data First1  /'"First Zero Crossing'/
      data Second1 /'"Second Zero Crossing'/
      data Third1  /'"Third Zero Crossing'/ 

c get online help if necessary

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
           call help ()
           stop
      endif

c open printout files

#include <f77/open.h>

c get command line parameters

      call cmdln ( ntap, otap, ist, iend, irs, ire, ns, ne, 
     :     verbos )

c get logical units

      call getln ( luin, ntap, 'r', 0 )
      length = lenth(otap)
      if (length .eq. 0) length = 1
      if ( otap(1:length) .ne. ' ' ) then
         open(luout,file=otap(1:length),status='unknown',err=990)
      endif

c read line header, check to see if input empty

      lbytes = 0
      call rtape(luin,itr,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'zeco: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c alter line header

#include <f77/saveh.h>

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      if(nsamp .gt. SZSMPM) nsamp=SZSMPM

c ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c set record start and end defaults

      if ( irs .eq. 0) irs = 1
      if ( ire .eq. 0) ire = nrec

c convert start and end time to start and end sample

      ist = ist / nsi
      iend = iend / nsi

      if ( ist .lt. 1) ist = 1
      if ( iend .lt. 1) iend = nsamp

c determine number of output samples

      nsampo = iend - ist + 1

c printout

      call verbal(nsamp, nsampo, nsi, ntrc, nrec, iform, ist, iend, ns, 
     :     ne, irs, ire )

c malloc only space we're going to use

      item = nsampo * SZSMPD

      call galloc ( wkadr1, item, errcd1, abort)
      call galloc ( wkadr2, item, errcd2, abort)
      call galloc ( wkadr3, item, errcd3, abort)

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate memory:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'ZECO:Unable to allocate memory:'
         write(LER,*) 3*item,'  bytes'
         write(LER,*)' '
          go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 3*item,'  bytes'
         write(LERR,*)' '
      endif

c skip to start record

      call recskp ( 1, irs-1, luin, ntrc, itr )

c clear zero crossing arrays

      call vclr ( first, 1, nsampo )
      call vclr ( second, 1, nsampo)
      call vclr ( third, 1, nsampo )

      DO JJ = irs, ire

c skip to desired trace

         call trcskp ( jj, 1, ns-1, luin, ntrc, itr )

         DO KK = ns,ne

            nbytes = 0
            call rtape ( luin, itr, nbytes )
            if ( nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
            endif
            call vmov ( itr(ITHWP1+ist-1), 1, tri, 1, nsampo )

            call zecosub ( tri, nsampo, first, second, third, 
     :           graph_max )

         ENDDO

c skip to end of record

         call trcskp ( jj, ne+1, ntrc, luin, ntrc, itr )


      ENDDO

c output 1st and 2nd zero crossing stats in xgraph format

      call maxv ( first, 1, junk, first_max, nsampo )
      call maxv ( second, 1, junk, second_max, nsampo )
      call maxv ( third, 1, junk, third_max, nsampo )

      first_max = (first_max-1.) * nsi
      second_max = (second_max-1.) * nsi
      third_max = (third_max-1.) * nsi

      write(luout,10) First1, first_max
 10   format(a20,i5,' ms')
      write(luout,888)(float(nsi*(i-1)),first(i),i=1,graph_max+10)
 888  format(f7.0,2x,f7.0)

      write(luout,889)
 889  format(/)
      write(luout,20) Second1, second_max
 20   format(a21,i5,' ms')
      write(luout,888)(float(nsi*(i-1)),second(i),i=1,graph_max+10)

      write(luout,889)
      write(luout,30) Third1, third_max
 30   format(a20,i5,' ms')
      write(luout,888)(float(nsi*(i-1)),third(i),i=1,graph_max+10)

c Normal Termination

      write(LERR,*)' Normal Termination'
      write(LER,*)'zeco: Normal Termination'
      call lbclos(luin)
      if ( otap(1:length) .ne. ' ' ) close(luout)
      stop

c Abnormal Termination

999   continue

      write(LERR,*)' Abnormal Termination'
      write(LER,*)'zeco: Abnormal Termination'
      call lbclos(luin)
      if ( otap(1:length) .ne. ' ' ) close(luout)
      stop


 990  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' FATAL ...............'
      write(LERR,*) ' error opening output file: ',otap(1:length)
      stop
      end

c online help section

      subroutine  help

#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for zeco_trace'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]  -- start trace             (first trace)'
        write(LER,*)'-ne[ne]  -- end trace                (last trace)'
        write(LER,*)'-rs[irs]  -- start record                 (first)'
        write(LER,*)'-re[ire]  -- end record                    (last)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
      write(LER,*)'zeco -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[] -re[] -V'
        write(LER,*)' '

      return
      end

c command line parsing subroutine

      subroutine cmdln ( ntap, otap, ist, iend, irs, ire, ns, ne, 
     :     verbos )

#include <f77/iounit.h>

      integer    argis, ist, iend, irs, ire
     
      character  ntap*(*), otap*(*)

      logical    verbos

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ')
      call argi4('-s',ist,1,1)
      call argi4('-e',iend,0,0)
      call argi4('-rs',irs,1,1)
      call argi4('-re',ire,0,0)
      call argi4('-ns',ns,0,0)
      call argi4('-ne',ne,0,0)
      verbos = (argis('-V') .gt. 0)

      return
      end

      subroutine verbal(nsamp,nsampo,nsi,ntrc,nrec,iform,
     :                  ist,iend,ns,ne,irs,ire)

#include <f77/iounit.h>

      
      integer nsamp,nsampo,nsi,ntrc,nrec,iform,ist,iend
      integer ns,ne

        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi
        write(LERR,*) ' Input Traces per Record  =  ', ntrc
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' window start in samples   =  ', ist
        write(LERR,*) ' window end in samples     =  ', iend
        write(LERR,*) ' trace start       =  ', ns
        write(LERR,*) ' trace end       =  ', ne
        write(LERR,*) ' record start       =  ', irs
        write(LERR,*) ' record end         =  ', ire
        write(LERR,*) ' Output # samples   =  ',nsampo
        write(LERR,*) ' '

      return
      end
