C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
      subroutine mint6(uirreg,ueql,w,leftzeta,idiv,ndiv,   
     1                 hbegin,nirreg,nbuf,neql,ntr)                 
c
      integer   hbegin
      integer   leftzeta(0:neql),idiv(0:neql)
      real      uirreg(-2:nirreg+3,ntr)         
      real      ueql(0:neql,ntr)
      real      w(-2:+3,0:ndiv)    
c_____________________________________________________________________
c     convolve 6 point interpolation operator with data.
c     loop unrolling version.
c_____________________________________________________________________
c_____________________________________________________________________
c      pad to allow for interpolation operator edges.
c      warning: this will destroy other data in these edges  (such
c      as header words).
c_____________________________________________________________________
      if(nirreg+3 .gt. nbuf .or. -1 .lt. hbegin) then
         write(0,*) 'error in routine minterp6'
         write(0,*) 'insufficient buffer space at beginning or end'//
     1              ' of input array uirreg'
         write(0,*) 'hbegin = ',hbegin,' must be .lt. ',-1
         write(0,*) 'nbuf  = ',nbuf ,' must be .gt. ',nirreg+3
         call exitfu(666)
      endif
      do 20000 itr=1,ntr
       uirreg(-2,itr)=uirreg(0,itr)
       uirreg(-1,itr)=uirreg(0,itr)
       uirreg(nirreg+1,itr)=uirreg(nirreg,itr)
       uirreg(nirreg+2,itr)=uirreg(nirreg,itr)
       uirreg(nirreg+3,itr)=uirreg(nirreg,itr)
20000 continue
c_____________________________________________________________________
c     interpolate.
c_____________________________________________________________________
      do 40000 k=0,neql              
       kl=leftzeta(k)
       jdiv=idiv(k)
       do 30000 itr=1,ntr
        ueql(k,itr)=uirreg(kl-2,itr)*w(-2,jdiv) 
     1               +uirreg(kl-1,itr)*w(-1,jdiv) 
     2               +uirreg(kl  ,itr)*w( 0,jdiv) 
     3               +uirreg(kl+1,itr)*w(+1,jdiv) 
     4               +uirreg(kl+2,itr)*w(+2,jdiv) 
     5               +uirreg(kl+3,itr)*w(+3,jdiv) 
30000  continue  
40000 continue
c
      return   
      end
