C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine zeta2z(zeta,nz,dzeql,nzeql,       
     1                  leftzeta,idiv,ndiv,luzeta,lerr)
C
      real      zeta  (0:nz)       
      integer   leftzeta(0:nzeql)
      integer   idiv  (0:nzeql)  
C_______________________________________________________________________
c     read in zeta.                                   
C______________________________________________________________________
      read(luzeta,*)
      read(luzeta,*) (jzeta,zeta(izeta),izeta=0,nz)
      close(luzeta)
c
      istart=0
      leftzeta(0)=0
      idiv(0)=0
      do 60000 izeta=1,nz
       iend=(zeta(izeta)-zeta(0))/dzeql
       do 50000 izeql=istart,iend
        zeql=zeta(0)+izeql*dzeql
        leftzeta(izeql)=izeta-1
        dzeta=zeta(izeta)-zeta(izeta-1)
        idiv(izeql)=nint(ndiv*(zeql-zeta(izeta-1))/dzeta)
        if(idiv(izeql) .eq. ndiv) then
           idiv(izeql)=0
           leftzeta(izeql)=izeta
        endif
50000  continue
       istart=iend+1
60000 continue
C
      write(lerr,*) 'irregular to regular mapping'
      write(lerr,'(/,5a12)') 'izeql','leftzeta','idiv','zeql','zeta'
      write(lerr,'(3i12,2f12.3)') (izeql,leftzeta(izeql),idiv(izeql),
     1      zeta(0)+dzeql*izeql,zeta(leftzeta(izeql)),izeql=0,nzeql)
C
      return
      end
