/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	iesctc.c
	Author	:	Dean Kopesky
	Date	:	March 1990

	Uses CFI32C to convert IEEE floating point data to Cray format.

	Calling sequence, C:

		iesctc( inbuf, start, outbuf, number );

		arg	i/o	type	description
		-----------------------------------
		inbuf	input	long[]	IEEE floating point data.
		start	input	long	Byte in inbuf where data begins,
					numbered from 1.
		outbuf	output	float[]	Array to receive Cray data.
		number	input	long	Number of values to convert.

	Calling sequence, FORTRAN:

		CALL IESCTC( inbuf, start, outbuf, number );

		arg	i/o	type	description
		-----------------------------------
		inbuf	input	int()	IEEE floating point data.
		start	input	integer	Byte in inbuf where data begins;
					numbered from 1.
		outbuf	output	real()	Array to receive Cray data.
		number	input	integer	Number of values to convert.
*/

#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|
	((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))

#include	<stdio.h>

void	exit();
char *	malloc();


void	iesctc( inbuf, start, outbuf, number )

	long *	inbuf;
	long	start;
	float *	outbuf;
	long	number;

{
#ifdef CRAY
	long *	tmpbuf;

	tmpbuf = (long *) malloc( ( ( number + 1 ) / 2 ) * 8 );
	if ( tmpbuf == NULL )
	{
		fprintf( stderr, "iesctc:  cannot malloc workspace." );
		exit( 1 );
	}

	memcpy( (char *) tmpbuf, (char *) inbuf + start - 1, 4 * number );

	CFI32C( tmpbuf, outbuf, &number );

	free( tmpbuf );
#endif

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	int i;
	for (i=0; i<number; i++) outbuf[i] = CONVERT4(inbuf[i+start-1]);
#endif
}


void	IESCTC( inbuf, start, outbuf, number )

	long *	inbuf;
	long *	start;
	float *	outbuf;
	long *	number;

{
	iesctc( inbuf, *start, outbuf, *number );
}
