/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	packbytes.c
	Author	:	Dean Kopesky
	Date	:	23 June 1987
	Changed	: 	27 June 1991
			Changed name from pack() to packbytes() to eliminate
			name conflict with system routine.

	pack() packs a specified number of bytes from each word in the
	input buffer into a contiguous byte stream in the output buffer,
	starting at a specified byte.

	Calling sequence, C:

		void	packbytes();
		char	inbuf[ INLEN ], outbuf[ OUTLEN ];
		long	outptr;
		int	number, perword;

		packbytes( inbuf, outbuf, outptr, number, perword );

	Calling sequence, FORTRAN:

		DIMENSION inbuf( INLEN ), outbuf( OUTLEN )
		INTEGER outptr, number, perword

		CALL PACKBYTE( inbuf, outbuf, outptr, number, perword )

	Parameters:

		inbuf	input	Buffer to read from.
		outbuf	output	Buffer to pack into.
		outptr	input	Byte in outbuf to start packing at
				(numbered from 1).
		number	input	Number of bytes to pack into outbuf.
		perword	input	Number of bytes to read from each word
				in inbuf.
*/


#define	WORDSIZE	8

#define	MIN(a,b)	( ( a < b ) ? ( a ) : ( b ) )


void	packbytes( inbuf, outbuf, outptr, number, perword )

	char	*inbuf, *outbuf;
	long	outptr;
	int	number, perword;

{
	char	*instr, *outstr;
	int	copied = 0;
	int	ncopy;

	char	*memcpy();

	instr  = inbuf;
	outstr = outbuf + outptr - 1;

	while ( copied < number )
	{
		ncopy = MIN( perword, number - copied );
		memcpy( outstr, instr, ncopy );
		instr  += WORDSIZE;
		outstr += ncopy;
		copied += ncopy;
	}
}


void	PACKBYTE( inbuf, outbuf, outptr, number, perword )

	char	*inbuf, *outbuf;
	long	*outptr;
	int	*number, *perword;

{
	packbytes( inbuf, outbuf, *outptr, *number, *perword );
}
