/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	desb.c
	Author	:	Dean Kopesky
	Date	:	August 1987
	Changed	:	June 1988
			Modified to use large buffers and to accept command-
			line arguments.
	Changed	:	March 1990
			Changed usictc to USICTC.
*/


static char	help[] =
"\
\n\
Desb reads a simple blocked (4) file, strips off the control words,\n\
and writes to stdout a plain data file.\n\
\n\
Usage:\n\
\n\
	desb [ -H ] [ simple(4) ]\n\
\n\
	-H		Prints this help listing.\n\
	simple(4)	The simple blocked (4) input file (default\n\
			is stdin).\n\
\n\
";


#define	MODULE	"desb"
#define	PARAMS	"[ -H ] [ simple(4) ]"

#define	ENORMAL	0	/* normal termination */
#define	EUSAGE	1	/* usage error */
#define	EBADIN	2	/* cannot open input file */
#define	ERDERR	3	/* premature EOF or read error on stdin */
#define	EWRERR	4	/* write error on stdout */
#define	EINCOMP	5	/* incomplete input file */

#define	BFRLEN	512*1024

#include	<stdio.h>

void	exit();
void	getargs();
char *	memcpy();
void	USICTC();


main( argc, argv )

	int	argc;
	char *	argv[ ];

{
	int	ifd;

	char	inbfr[ BFRLEN ];
	int	inend;
	int	inptr;
	int	left;
	int	nread;
	char	outbfr[ BFRLEN ];
	int	outptr;
	int	reclen;
	int	tocopy;
	int	c1 = 1, c4 = 4;
	int	start;

	getargs( argc, argv, &ifd );

	left = 0;
	inend = 0;
	inptr = 0;
	outptr = 0;

	while ( ( nread = readpipe( ifd, inbfr + inend, BFRLEN - inend ) ) > 0 )
	{
		inend += nread;

		if ( left > 0 )
		{
			( void ) memcpy( outbfr + outptr, inbfr + inptr, left );
			inptr += left;
			outptr += left;
			left = 0;
		}

		while ( inend - inptr >= 4 )
		{
			start = inptr + 1;
			USICTC( inbfr, &start, &reclen, &c1, &c4 );
			inptr += 4;

			if ( inend - inptr >= reclen )
				tocopy = reclen;
			else
				tocopy = inend - inptr;

			( void ) memcpy( outbfr + outptr, inbfr + inptr,
				tocopy );
			inptr += tocopy;
			outptr += tocopy;
			left = reclen - tocopy;
		}

		if ( write( 1, outbfr, ( unsigned ) outptr ) != outptr )
		{
	( void ) fprintf( stderr, "%s:  write error on stdout.\n", MODULE );
			exit( EWRERR );
		}

		outptr = 0;

		( void ) memcpy( outbfr, inbfr + inptr, inend - inptr );
		( void ) memcpy( inbfr, outbfr, inend - inptr );

		inend -= inptr;
		inptr = 0;
	}

	if ( nread < 0 )
	{
	( void ) fprintf( stderr, "%s:  read error on input.\n", MODULE );
		exit( ERDERR );
	}

	if ( inend > 0 || left > 0 )
	{
	( void ) fprintf( stderr, "%s:  incomplete input file.\n", MODULE );
		exit( EINCOMP );
	}

	return( ENORMAL );
}


void getargs( argc, argv, ifd )

	int	argc;
	char *	argv[];
	int *	ifd;

{
	*ifd = 0;

	switch ( argc )
	{
		case 1:
			break;
		case 2:
			if ( strcmp( argv[ 1 ], "-H" ) == 0 )
			{
				( void ) fprintf( stderr, "%s", help );
				exit( ENORMAL );
			}
			else if ( ( *ifd = open( argv[ 1 ], 0 ) ) < 0 )
			{
	( void ) fprintf( stderr, "%s:  cannot open input file (%s).\n",
					MODULE, argv[ 1 ] );
				exit( EBADIN );
			}
			break;
		default:
	( void ) fprintf( stderr, "usage:  %s %s\n", MODULE, PARAMS );
			exit( EUSAGE );
			break;
	}
}
