/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	File	:	devb.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.
	Date	:	May 1988
	Changed	:	December 1988
			Exits if it finds a bad control word, rather than
			looping.
	Changed	:	March 1990
			Changed usict[ci] to USICT[CI].
	Changed	:	August 1991
			Eliminated calls to USICT[CI].  Should now work on any
			machine that uses significant-byte-first ordering.

--------------------------------------------------------------------------- */


#include	<stdio.h>


static char	help[] =
"\
\n\
Devb reads an IBM RECFM=VB file optionally nested in a simple blocked (4)\n\
file, deblocks it, and writes to stdout a simple blocked (4) file.\n\
\n\
Usage:\n\
\n\
	devb [ -H ] [ -ns ] [ recfm=vb ]\n\
\n\
	-H		Prints this listing.\n\
	-ns		Specifies that recfm=vb is not a simple blocked\n\
			file.\n\
	recfm=vb	The RECFM=VB input file (default is stdin).\n\
\n\
";


#define	MODULE	"devb"
#define	PARAMS	"[ -H ] [ -ns ] [ recfm=vb ]"

#define	ENORMAL	0	/* normal termination */
#define	EUSAGE	1	/* usage error */
#define	EBADIN	2	/* cannot open input file */
#define	ERDERR	3	/* premature EOF or read error on stdin */
#define	EWRERR	4	/* write error on stdout */
#define	EINCOMP	5	/* incomplete input file */
#define	EZERO	6	/* block or record length <= 0 */

#define	BFRLEN	512*1024


#define	GETINT(dest,source,size) \
{ \
	(dest) = 0; \
	memcpy( (char *) &(dest) + sizeof(dest) - (size), (source), (size) ); \
}

#define	PUTINT(source,dest,size) \
	memcpy( (dest), (char *) &(source) + sizeof(source) - (size), (size) );


void	exit();
void	flushem();
void	getargs();
char *	memcpy();


main( argc, argv )

	int	argc;
	char *	argv[];

{
	int	ns;	/* set to 1 iff -ns option is used */
	int	ifd;	/* input file descriptor */

	char	inbuf[ BFRLEN ];
	char	outbuf[ BFRLEN ];

	int	inbeg, inend, blkend;
	int	outend;
	int	reclen;

	getargs( argc, argv, &ns, &ifd );

	inbeg = inend = outend = 0;

	while ( 1 )  /* process a block */
	{
		if ( ! ns )
		{
			if ( inbeg + 4 > inend )
				flushem( ifd, inbuf, &inbeg, &inend, &blkend,
					outbuf, &outend );
			inbeg += 4;
		}
		if ( inbeg + 4 > inend )
			flushem( ifd, inbuf, &inbeg, &inend, &blkend,
				outbuf, &outend );
		GETINT( blkend, inbuf + inbeg, 2 );
		if ( blkend <= 0 )
		{
		fprintf( stderr, "%s:  block length <= 0.\n", MODULE );
			exit( EZERO );
		}
		blkend = inbeg + blkend;
		inbeg += 4;

		while ( inbeg < blkend )  /* process a record */
		{
			if ( inbeg + 4 > inend )
				flushem( ifd, inbuf, &inbeg, &inend, &blkend,
					outbuf, &outend );
			GETINT( reclen, inbuf + inbeg, 2 );
			inbeg += 4;
			reclen -= 4;
			if ( reclen <= 0 )
			{
		fprintf( stderr, "%s:  record length <= 0.\n", MODULE );
				exit( EZERO );
			}
			if ( inbeg + reclen > inend )
				flushem( ifd, inbuf, &inbeg, &inend, &blkend,
					outbuf, &outend );
			PUTINT( reclen, outbuf + outend, 4 );
			outend += 4;
			memcpy( outbuf + outend, inbuf + inbeg, reclen );
			inbeg += reclen;
			outend += reclen;
		}
	}
}


void flushem( ifd, inbuf, inbeg, inend, blkend, outbuf, outend )

	int	ifd;
	char *	inbuf;
	int *	inbeg;
	int *	inend;
	int *	blkend;
	char *	outbuf;
	int *	outend;

{
	char	tmpbuf[ BFRLEN ];
	int	nread;

	if ( write( 1, outbuf, ( unsigned ) *outend ) != *outend )
	{
		fprintf( stderr, "%s:  write error on stdout.\n", MODULE );
		exit( EWRERR );
	}
	*outend = 0;

	memcpy( tmpbuf, inbuf + *inbeg, *inend - *inbeg );
	memcpy( inbuf, tmpbuf, *inend - *inbeg );
	*inend -= *inbeg;
	*blkend -= *inbeg;
	*inbeg = 0;

	nread = readpipe( ifd, inbuf + *inend, BFRLEN - *inend );

	if ( nread < 0 )
	{
		fprintf( stderr, "%s:  read error on input file.\n", MODULE );
		exit( ERDERR );
	}
	if ( nread == 0 )
		if ( *blkend == *inend )
		{
			exit( ENORMAL );
		}
		else
		{
		fprintf( stderr, "%s:  incomplete input file.\n", MODULE );
			exit( EINCOMP );
		}

	*inend += nread;
}


void getargs( argc, argv, ns, ifd )

	int	argc;
	char *	argv[];
	int *	ns;
	int *	ifd;

{
	*ns = 0;
	*ifd = 0;

	switch ( argc )
	{
		case 1:
			break;
		case 2:
			if ( strcmp( argv[ 1 ], "-H" ) == 0 )
			{
				fprintf( stderr, "%s", help );
				exit( 1 );
			}
			if ( strcmp( argv[ 1 ], "-ns" ) == 0 )
			{
				*ns = 1;
			}
			else if ( ( *ifd = open( argv[ 1 ], 0 ) ) < 0 )
			{
fprintf( stderr, "%s:  cannot open input file (%s).\n", MODULE, argv[ 1 ] );
				exit( EBADIN );
			}
			break;
		case 3:
			if ( strcmp( argv[ 1 ], "-ns" ) == 0 )
			{
				*ns = 1;
			}
			else
			{
			fprintf( stderr, "usage: %s %s\n", MODULE, PARAMS );
				exit( EUSAGE );
			}
			if ( ( *ifd = open( argv[ 2 ], 0 ) ) < 0 )
			{
fprintf( stderr, "%s:  cannot open input file (%s).\n", MODULE, argv[ 2 ] );
				exit( EBADIN );
			}
			break;
		default:
			fprintf( stderr, "usage:  %s %s\n", MODULE, PARAMS );
			exit( EUSAGE );
			break;
	}
}
