/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	gencon.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988

	Gencon generates record conversion routines.  The command format is:

	gencon routine direction [ format ]

	routine		The name of the routine to generate.

	direction	Code indicating what to translate from and to.
			Valid codes are: i2c, c2i, s2c, c2s.

	format		File containing a description of the format of the
			record.  Each entry has the form "%d%c%d", where the
			fields are 'count', 'format', 'length', and 'format'
			is one of:

				b	dummy bytes
				c	character data
				i	integer data
				r	real data
				t	transparent
				v	invisible (super-transparent)
				w	dummy words
				H	historical line header

	The calling sequence of the generated routine is:

	void routine( inbuf, inlen, outbuf, outlen );

	arg	i/o	type	description
	-----------------------------------
	inbuf	input	char *	Buffer containing the input record.
	inlen	input	int  *	Length of the input record in bytes.
	outbuf	output	char *	Buffer to contain the output record.
	outlen	output	int  *	Length of the output record in bytes.
*/


#include	"gencon.h"


main( argc, argv )

	int	argc;
	char *	argv[];

{
	char *	routine;
	int	direction;
	FILE *	format;

	int	waszero = 0;

	int	count;
	char	form;
	int	size;

	int	inptr = 0;
	int	outptr = 0;

	getargs( argc, argv, &routine, &direction, &format );

	prheader( routine );

	while ( fscanf( format, "%d%c%d", &count, &form, &size ) == 3 )
	{
		if ( count < 0 )
		{
			fprintf( stderr, "%s: (%d%c%d) Count must be >= 0.\n",
				MODULE, count, form, size );
			exit( EBADFMT );
		}

		if ( size < 1 || size > WORDSIZE )
		{
		fprintf( stderr, "%s: (%d%c%d) Size must be >= 1 and <= %d.\n",
				MODULE, count, form, size, WORDSIZE );
			exit( EBADFMT );
		}

		if ( waszero )
		{
	fprintf( stderr, "%s: (%d%c%d) Count of zero must be last format.\n",
				MODULE, count, form, size );
			exit( EBADFMT );
		}

		if ( count == 0 ) waszero = 1;

		switch ( form )
		{
			case 'b':
			prfmtb( direction, count, size, &inptr, &outptr );
				break;
			case 'c':
			prfmtc( direction, count, size, &inptr, &outptr );
				break;
			case 'i':
			prfmti( direction, count, size, &inptr, &outptr );
				break;
			case 'r':
			prfmtr( direction, count, size, &inptr, &outptr );
				break;
			case 't':
			prfmtt( direction, count, size, &inptr, &outptr );
				break;
			case 'v':
			prfmtv( direction, count, size, &inptr, &outptr );
				break;
			case 'w':
			prfmtw( direction, count, size, &inptr, &outptr );
				break;
			case 'H':
			prfmtH( direction, count, size, &inptr, &outptr );
				break;
			default:
			fprintf( stderr, "%s: (%d%c%d) Illegal format code.\n",
					MODULE, count, form, size );
				exit( EBADFMT );
		}
	}

	if ( ! waszero )
	{
		fprintf( stderr, "%s:  last format must have count of zero.\n",
			MODULE );
		exit( EBADFMT );
	}

	prfooter();

	return( ENORMAL );
}
