/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmti.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	June 1988
			Changed 'usictc' to 'ksictc' in the hopes of dodging
			a usictc bug.
	Changed	:	February 1989
			Changed 'ksictc' back to 'usictc' now that CRI has a
			working version.
	Changed	:	March 1990
			Changed usict[ci] to USICT[CI].  Got rid of kludge.

	Generate subroutine calls to translate integers.
*/


#include	"gencon.h"


void prfmti( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/* debug
	printf("prfmti: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:
		case S2C:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tlength = %d;\n", size );
	printf( "\tUSICTC( inbuf, &start, outbuf + %d, &number, &length );\n",
		*outptr );
}
else
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, size );
	printf( "\tlength = %d;\n", size );
	printf( "\tUSICTC( inbuf, &start, outbuf + %d, &number, &length );\n",
		*outptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
                 	break;

		case C2S:
		case C2I:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tlength = %d;\n", size );
	printf(
	"\tUSICTI( inbuf + %d, outbuf, &start, &number, &length, &ier );\n",
		*inptr );
}
else
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, WORDSIZE );
	printf( "\tlength = %d;\n", size );
	printf(
	"\tUSICTI( inbuf + %d, outbuf, &start, &number, &length, &ier );\n",
		*inptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, WORDSIZE, size );
}
			*inptr += count * WORDSIZE;
			*outptr += count * size;
                 	break;

		case S2IN:
if ( count > 0 )
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d);\n",
		*outptr, *inptr, count * size);

	if (size == 2) 
 	  printf( "\tHTOCS( outbuf + %d, %d );\n", *outptr, count );
	else if (size == 4) 
 	  printf( "\tHTOCL( outbuf + %d, %d );\n", *outptr, count );
}
else
{
	printf( "\tnumber = *inlen - %d;\n", *inptr, size );
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, number);\n",
		*outptr, *inptr );
	if (size == 2) 
	  printf( "\tHTOCS( outbuf + %d, number / %d );\n", *outptr, size );
	else if (size == 4) 
	  printf( "\tHTOCL( outbuf + %d, number / %d );\n", *outptr, size );
	printf( "\t*outlen = %d + ( *inlen - %d );\n",
		*outptr, *inptr );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		case IN2S:
if ( count > 0 )
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d);\n",
		*outptr, *inptr, count * size );
	if (size == 2) 
	  printf( "\tCTOHS( outbuf + %d, %d );\n", *outptr, count );
	else if (size == 4) 
	  printf( "\tCTOHL( outbuf + %d, %d );\n", *outptr, count );
}
else
{
	printf( "\tnumber = *inlen - %d;\n", *inptr, size );
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, number);\n", *outptr, *inptr );
	if (size == 2) 
	  printf( "\tCTOHS( outbuf + %d, number / %d );\n", *outptr, size );
	else if (size == 4) 
	  printf( "\tCTOHL( outbuf + %d, number / %d );\n", *outptr, size );
	printf( "\t*outlen = %d + ( *inlen - %d );\n",
		*outptr, *inptr );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmti.\n",
				MODULE );
			exit( EINTERN );
			break;
	}
}
