/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	File	:	prfmtr.c
	Program	:	gencon
	Author	:	Dean Kopesky
	Date	:	May 1988
	Changed	:	March 1990
			Changed ussct[ci] to USSCT[CI]; vatc/vcta to IESCT[CI].
			June 1991
			Changed IESCT[IC] calls to always set 1 <= ISB <= 8,
			so I can use the Cray versions of those routines.

	Generate subroutine calls to translate single-precision
	floating-point data.
*/


#include	"gencon.h"


void prfmtr( direction, count, size, inptr, outptr )

	int	direction;
	int	count;
	int	size;
	int *	inptr;
	int *	outptr;

{
/*
	printf("prfmtr: count = %d, size = %d, inptr = %d, outptr = %d\n",
		count,size,*inptr,*outptr);
*/
	switch( direction )
	{
		case I2C:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tUSSCTC( inbuf, &start, outbuf + %d, &number );\n", *outptr );
}
else
{
	printf( "\tstart = %d;\n", *inptr + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, size );
	printf( "\tUSSCTC( inbuf, &start, outbuf + %d, &number );\n", *outptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
			break;

		case S2C:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", ( *inptr % 8 ) + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tIESCTC( inbuf + %d, &start, outbuf + %d, &number );\n",
		( *inptr / 8 ) * 8, *outptr );
}
else
{
	printf( "\tstart = %d;\n", ( *inptr % 8 ) + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, size );
	printf( "\tIESCTC( inbuf + %d, &start, outbuf + %d, &number );\n",
		( *inptr / 8 ) * 8, *outptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * size;
			*outptr += count * WORDSIZE;
			break;

		case C2I:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tUSSCTI( inbuf + %d, outbuf, &start, &number, &ier );\n",
		*inptr );
}
else
{
	printf( "\tstart = %d;\n", *outptr + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, WORDSIZE );
	printf( "\tUSSCTI( inbuf + %d, outbuf, &start, &number, &ier );\n",
		*inptr );
	printf( "\t*outlen = %d + ( ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, WORDSIZE, size );
}
			*inptr += count * WORDSIZE;
			*outptr += count * size;
			break;

		case C2S:

if ( count > 0 )
{
	printf( "\tstart = %d;\n", ( *outptr % 8 ) + 1 );
	printf( "\tnumber = %d;\n", count );
	printf( "\tIESCTI( inbuf + %d, outbuf + %d, &start, &number, &ier );\n",
		*inptr, ( *outptr / 8 ) * 8 );
}
else
{
	printf( "\tstart = %d;\n", ( *outptr % 8 ) + 1 );
	printf( "\tnumber = ( *inlen - %d ) / %d;\n", *inptr, WORDSIZE );
	printf( "\tIESCTI( inbuf + %d, outbuf + %d, &start, &number, &ier );\n",
		*inptr, ( *outptr / 8 ) * 8 );
	printf( "\t*outlen = %d + ( *inlen - %d ) / %d ) * %d;\n",
		*outptr, *inptr, size, WORDSIZE );
}
			*inptr += count * WORDSIZE;
			*outptr += count * size;
			break;

		case S2IN:
if ( count > 0 )
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d);\n", *outptr, *inptr, count * size);
	printf( "\tHTOCF( outbuf + %d, %d );\n", *outptr, count );
}
else
{
	printf( "\tnumber = *inlen - %d;\n", *inptr );
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, number);\n", *outptr, *inptr );
	printf( "\tHTOCF( outbuf + %d, number / %d );\n", *outptr, size );
	printf( "\t*outlen = %d + ( *inlen - %d );\n",
		*outptr, *inptr );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		case IN2S:
if ( count > 0 )
{
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, %d);\n", *outptr, *inptr, count * size);
	printf( "\tCTOHF( outbuf + %d, %d );\n", *outptr, count );
}
else
{
	printf( "\tnumber = *inlen - %d;\n", *inptr );
	printf( "\tmemcpy( outbuf + %d, inbuf + %d, number);\n", *outptr, *inptr );
	printf( "\tCTOHF( outbuf + %d, number / %d );\n", *outptr, size );
	printf( "\t*outlen = %d + ( *inlen - %d );\n",
		*outptr, *inptr );
}
			*inptr += count * size;
			*outptr += count * size;
			break;

		default:

			fprintf( stderr, "%s: internal error in prfmtr.\n",
				MODULE );
			exit( EINTERN );
			break;
	}

}
