/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	Package	:	sisio
	File	:	_isdisk.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	isdisk = _isdisk( fd );

	isdisk	return	int	1 iff fd is a disk file, 0 iff fd is a
				pipe, -1 if not open or other error.
	fd	input	int	File descriptor of file to check.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_isdisk.c,v 4.2 91/02/25 11:04:05 dmk Exp $

	$Log:	_isdisk.c,v $
	Revision 4.2  91/02/25  11:04:05  dmk
	MODSET: 4.2
	Added check for sockets (treated as pipes by the library).
	
	Revision 4.1  90/07/13  08:59:21  dmk
	MODSET: 4.1
	Added lint proofing.
	
	Revision 2.4  88/09/26  14:27:29  dmk
	MODSET: 2.4
	Added 'struct inode' declaration for lint-proofing.
	
	Revision 1.1  88/07/12  15:55:53  dmk
	Initial revision
	
*/


#ifdef	lint
struct	inode		{ int dummy; };
struct	kern_lnode	{ int dummy; };
#endif

#include	<sys/types.h>
#include	<sys/stat.h>


int _isdisk( fd )

	int	fd;

{
	struct stat	buf;

	if ( fstat( fd, &buf ) != 0 ) return( -1 );
	if ( ( buf.st_mode & S_IFMT ) == S_IFREG ) return( 1 );
	if ( ( buf.st_mode & S_IFMT ) == S_IFIFO ) return( 0 );
#ifndef __i860
	if ( ( buf.st_mode & S_IFMT ) == S_IFSOCK ) return( 0 );
#endif
	return( -1 );
}
