/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisabort.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISABORT specifies whether sisio should abort if an error occurs
	on the specified unit.

	FORTRAN:

	CALL SISABORT( unit, fswitch )

	unit	input	integer	Unit number.
	fswitch	input	charact	Set to 'on' or 'off' to enable or disable
				aborts.

	C:

	sisabort( unit, cswitch );

	unit	input	int	Unit number.
	cswitch	input	char *	Set to 'on' or 'off' to enable or disable
				aborts.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisabort.c,v 4.3 91/09/11 08:49:31 dmk Exp $

	$Log:	sisabort.c,v $
	Revision 4.3  91/09/11  08:49:31  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for STRLEN_IS_ARG, not sun.
	
	Revision 4.1  90/07/13  09:20:15  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:56:30  dmk
	MODSET: 3.1
	Added C entry point.
	
	Revision 2.3  88/08/16  12:44:14  dmk
	MODSET: 2.3
	Added the fswlen parameter to fix a bug in the SUN version.
	
	Revision 2.1  88/07/12  15:17:34  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Now uses CHECKRANGE.
	
	Revision 1.1  88/06/28  08:47:21  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	"sisio.h"

#define	MODULE	"SISABORT"

#define STRLEN	128


#ifdef	CRAY
void	F_SISABORT( unit, fswitch )

	int *	unit;
	_fcd	fswitch;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISABORT( unit, fswitch, fswlen )

	int *	unit;
	char *	fswitch;
	int	fswlen;
#endif

{
	char	cswitch[ STRLEN ];

	/*
		Check and translate switch.
	*/

#ifdef	CRAY
	if ( _strf2c( fswitch, cswitch, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fswitch, fswlen, cswitch, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, *unit, E_BADSWITCH );
		return;
	}

	/*
		Call C version.
	*/

	C_SISABORT( *unit, cswitch );
}


void	C_SISABORT( unit, cswitch )

	int	unit;
	char *	cswitch;
{
	/*
		Initialize if necessary and check for outstanding error.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );

	/*
		Set abort field.
	*/

	_strlower( cswitch );

	if ( ! strcmp( cswitch, "on" ) )
		_sisfit[ unit ].abort = TRUE;
	else if ( ! strcmp( cswitch, "off" ) )
		_sisfit[ unit ].abort = FALSE;
	else
	{
		_error( MODULE, unit, E_BADSWITCH );
		return;
	}
}
