/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisfdfit.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISFDFIT puts the file descriptor of an already-open file into
	SISIO's file information table, and returns an SISIO unit number,
	which allows you to use RTAPE and WRTAPE on files that were not
	opened with LBOPEN.

	FORTRAN:

	CALL SISFDFIT( unit, fd )

	unit	output	integer	Logical unit number assigned.
	fd	input	integer	File descriptor of an open file.

	C:

	lbopen( unit, fd );

	unit	output	int *	Logical unit number assigned.
	fd	input	int	File descriptor of an open file.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisfdfit.c,v 4.3 91/09/11 08:50:17 dmk Exp $

	$Log:	sisfdfit.c,v $
	Revision 4.3  91/09/11  08:50:17  dmk
	MODSET: 4.3
	Changed entry point names to macros.
	
	Revision 4.1  90/07/13  09:22:44  dmk
	MODSET: 4.1
	Changed SUN to sun.
	
	Revision 3.2  90/02/05  12:20:55  dmk
	MODSET: 3.2
	Initial revision.
	
--------------------------------------------------------------------------- */


#include	<fcntl.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sisio.h>

#define	MODULE	"SISFDFIT"


void 	F_SISFDFIT( unit, fd )

	int *	unit;
	int *	fd;

{
	/*
		Call the C version.
	*/

	C_SISFDFIT( unit, *fd );
}


void	C_SISFDFIT( unit, fd )

	int *	unit;
	int	fd;

{
	int	isdisk;

	/*
		Initialize sisio iff necessary.
	*/

	INITIALIZE;

	/*
		Select an unopen, error-free unit number.
	*/

	*unit = 2;

	while ( ( _sisfit[ *unit ].isopen || _sisfit[ *unit ].error )
			&& *unit < MAXUNIT )
		*unit += 1;

	if ( _sisfit[ *unit ].isopen || _sisfit[ *unit ].error )
	{
		_error( MODULE, -1, E_NOUNITS );
		return;
	}

	/*
		Note the file descriptor.
	*/

	_sisfit[ *unit ].filedes = fd;

	/*
		See if the file is a pipe.
	*/

	isdisk = _isdisk( _sisfit[ *unit ].filedes );
	if ( isdisk == -1 )
	{
		_error( MODULE, *unit, E_NOTFILE );
		_sisfit[ *unit ].filedes = 0;
		return;
	}
	_sisfit[ *unit ].isdisk = isdisk;

	/*
		Set the control word length.
	*/

	if ( _sisfit[ *unit ].trwhen == W_ALWAYS || ( _sisfit[ *unit ].trwhen
			== W_IFDISK && _sisfit[ *unit ].isdisk ) )
		_sisfit[ *unit ].cwlen = 4;
	else
		_sisfit[ *unit ].cwlen = WORDSIZE;

	/*
		don't use large buffering unless we're coming from disk
	*/

	if ( ! _sisfit[ *unit ].isdisk && _sisfit[ *unit ].largebuf )
		_sisfit[ *unit ].largebuf = FALSE;

	/*
		Allocate the buffer.
	*/

	if ( _sisfit[ *unit ].largebuf )
	{
		_sisfit[ *unit ].buffer = (char *) malloc( LGBUFSIZE );
		_sisfit[ *unit ].bufsize = LGBUFSIZE;
	}
	else
	{
		_sisfit[ *unit ].buffer = (char *) malloc( SMBUFSIZE );
		_sisfit[ *unit ].bufsize = SMBUFSIZE;
	}

	if ( _sisfit[ *unit ].buffer == NULL )
	{
		_error( MODULE, *unit, E_NOBUFFER );
		_sisfit[ *unit ].filedes = 0;
		return;
	}

	_sisfit[ *unit ].isopen = TRUE;
}
