/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	sisfmt.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISFMT specifies the format of an SIS file.  This subroutine is
	only needed for format V, which SISIO can't identify.

	FORTRAN:

	CALL SISFMT( unit, fformat )

	unit	input	integer	Unit number.
	fformat	input	charact	Set to '1', '3', '5', 'L', or 'V'.

	C:

	sisfmt( unit, cformat );

	unit	input	int	Unit number.
	cformat	input	char *	Set to "1", "3", "5", "L", or "V".


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisfmt.c,v 4.3 91/09/11 08:50:25 dmk Exp $

	$Log:	sisfmt.c,v $
	Revision 4.3  91/09/11  08:50:25  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Tests for STRLEN_IS_ARG, not sun.
	
	Revision 4.1  90/07/13  09:23:09  dmk
	MODSET: 4.1
	Initial revision.
	
--------------------------------------------------------------------------- */


#ifdef	CRAY
#include	<fortran.h>
#endif

#include	"sisio.h"

#define	MODULE	"SISFMT"

#define STRLEN	128


#ifdef	CRAY
void	F_SISFMT( unit, fformat )

	int *	unit;
	_fcd	fformat;
#endif
#ifdef	STRLEN_IS_ARG
void	F_SISFMT( unit, fformat, ffmtlen )

	int *	unit;
	char *	fformat;
	int	ffmtlen;
#endif

{
	char	cformat[ STRLEN ];

	/*
		Check and translate format.
	*/

#ifdef	CRAY
	if ( _strf2c( fformat, cformat, STRLEN ) < 0 )
#endif
#ifdef	STRLEN_IS_ARG
	if ( _strf2c( fformat, ffmtlen, cformat, STRLEN ) < 0 )
#endif
	{
		_error( MODULE, *unit, E_BADFMT );
		return;
	}

	/*
		Call C version.
	*/

	C_SISFMT( *unit, cformat );
}


void	C_SISFMT( unit, cformat )

	int	unit;
	char *	cformat;

{
	/*
		Initialize if necessary and check unit for range and
		outstanding error.
	*/

	INITIALIZE;
	CHECKRANGE( MODULE, unit );
	CHECKERROR( MODULE, unit );

	/*
		Set format field.
	*/

	_strlower( cformat );

	switch ( cformat[ 0 ] )
	{
		case '1':	_sisfit[ unit ].format = 1;	break;
		case '3':	_sisfit[ unit ].format = 3;	break;
		case '5':	_sisfit[ unit ].format = 5;	break;
		case 'l':	_sisfit[ unit ].format = 'L';	break;
		case 'v':	_sisfit[ unit ].format = 'V';	break;
		default:	_error( MODULE, unit, E_BADFMT );
				return;
	}
}
