/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	sisver.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISVER prints sisio version information.

	FORTRAN:

	CALL SISVER

	C:

	sisver();


	$Header: /m/m1/dmk/xlate/sisio/RCS/sisver.c,v 4.4 1992/05/08 13:29:05 dmk Exp $

	$Log: sisver.c,v $
	Revision 4.4  1992/05/08  13:29:05  dmk
	Added version 4.4 info.

	Revision 4.3  1991/09/11  09:01:36  dmk
	MODSET: 4.3
	Added 4.3 info.  Deleted 3.1 and 3.2.

	Revision 4.2  91/02/25  11:05:05  dmk
	MODSET: 4.2
	Added version 4.2 notes.
	
	Revision 4.1  90/07/13  09:28:21  dmk
	MODSET: 4.1
	Added version 4.1 notes.  Changed SUN to sun.
	
	Revision 3.2  90/02/05  14:04:13  dmk
	MODSET: 3.2
	Added version 3.2 info.  Deleted version 2.3 and 2.4 info.
	
	Revision 3.1  89/09/27  09:58:56  dmk
	MODSET: 3.1
	Added C entry point.  Added version 3.1 info.
	
	Revision 2.4  88/09/26  14:28:29  dmk
	MODSET: 2.4
	Added version 2.4 notes; deleted version 2.1 and 2.2 notes.
	
	Revision 2.3  88/08/16  12:48:28  dmk
	MODSET: 2.3
	Added version 2.3 information.
	
	Revision 2.2  88/07/20  08:57:10  dmk
	MODSET: 2.2
	Added 2.2 info; deleted 1.2 info.  See 'help' below for details.
	
	Revision 2.1  88/07/12  15:30:05  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Added SUN clause.  Split the
	header from the notes.  Added notes for this version (2.1).
	
	Revision 1.2  88/06/24  16:20:40  dmk
	MODSET: 1.2
	See 'help' below.
	
	Revision 1.1  88/06/24  12:55:08  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	<stdio.h>
#include	"sisio.h"

#define	VERSION	"4.4"
#define	DATE	"November 1991"

#ifdef	IEEE
#define	TYPE	"IEEE"
#endif
#ifdef	IBM
#define	TYPE	"IBM"
#endif
#ifndef	TYPE
#define	TYPE	"WORKSTATION"
#endif

static char	head[] =
"\
SISIO %s Version %s\n\
Dean Kopesky\n\
Minnesota Supercomputer Center, Inc.\n\
%s\n\
";

static char	info[] =
"\
Version 4.4\n\
The default buffer size for workstations has been changed to small buffers.\n\
This is to dodge a problem that occurs with certain pipelined codes.\n\
\n\
Version 4.3\n\
All C entry points in the RS-6000 version have had _c appended to them.  This\n\
is needed because the Fortran compiler on the RS-6000 maps entry points to\n\
the same names as the C compiler.  The include file sisio_c.h can be used to\n\
map the old names to the new ones (e.g., rtape to rtape_c).  If you use this\n\
include file, C source code will link properly on all machines.\n\
\n\
Version 4.2\n\
This version has a larger buffer size to allow processing of traces of up to\n\
200000 bytes (Cray format).  It also allows I/O on sockets; sockets are\n\
treated like pipes in that no data translation is performed.\n\
\n\
Version 4.1\n\
This version provides limited support for format L (VANL) datasets.  LBOPEN,\n\
LBCLOS, RTAPE, and WRTAPE work normally with format L.  BKSPT, SISSEEK, and\n\
SKIPT do not work with format L.  This version also provides support for\n\
format V (velocity function) datasets.  There are two new routines, SISFMT\n\
and SISB4MSG.  SISFMT sets the format of a dataset; it's use is only required\n\
with format V.  SISB4MSG sets the error message prefix; this is useful for\n\
determining which program in a pipeline is gagging.  This version also\n\
provides better error messages than previous versions.\n\
";


void	F_SISVER()

{
	C_SISVER();
}


void	C_SISVER()

{
	( void ) fprintf( stderr, "\n" );
	( void ) fprintf( stderr, head, TYPE, VERSION, DATE );
	( void ) fprintf( stderr, "\n" );
	( void ) fprintf( stderr, info );
	( void ) fprintf( stderr, "\n" );
}
