/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	File	:	_readsb.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_readsb reads a record from a simple blocked file.  Each record in
	a simple blocked file is preceeded by its length in either a four-
	or eight-byte field.

	Calling sequence:

	nread = _readsb( file, buffer, bfrlen, field )

	arg	i/o	type	description
	-----------------------------------
	nread	result	int	Number of bytes read, 0 if EOF, < 0 if error.
	file	input	int	File descriptor.
	buffer	output	char *	Address of area to read into.
	bfrlen	input	int	Size of buffer.
	field	input	int	Length of control words (4 or 8).


	$Header: /m/s1/dmk/xlate/sisio/RCS/_readsb.c,v 4.3 91/09/11 08:36:31 dmk Exp $

	$Log:	_readsb.c,v $
	Revision 4.3  91/09/11  08:36:31  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:10:02  dmk
	MODSET: 4.1
	Initial revision.
	
--------------------------------------------------------------------------- */


#include	"sisio.h"

#define	SB_EOF		 0	/* end of file encountered */
#define	SB_OVFLOW	-1	/* buffer overflow */
#define	SB_TOOSHRT	-2	/* record too short */
#define	SB_BADFLD	-3	/* invalid control word length */


int	_readsb( file, buffer, bfrlen, field )

	int	file;
	char	*buffer;
	int	bfrlen;
	int	field;

{
/* long implied 64 bits on the SGI, so I made reclen an int on machines
   other than the CRAY				- joe m. wade 4/25/95
*/


#ifdef	CRAY
	long	reclen;
	if ( field != 4 && field != 8 ) return( SB_BADFLD );
#else
	int	reclen;
	if ( field != 4 ) return( SB_BADFLD );
#endif

	if ( _readpipe( file, buffer, ( unsigned ) field ) != field )
		return( SB_EOF );

	( void ) memcpy( ( char * ) &reclen, buffer, WORDSIZE );
	reclen = ( unsigned ) reclen >> ( ( WORDSIZE - field ) * WORDSIZE );
	if ( reclen > bfrlen ) return( SB_OVFLOW );

	if ( _readpipe( file, buffer, ( unsigned ) reclen ) != reclen )
		return( SB_TOOSHRT );

	return( reclen );
}
