/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	_writeit.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	_Writeit writes a record to the specified unit, taking into account
	large buffering.

	nwrite = _writeit( unit, buffer, length );

	nwrite	return	int	Number of bytes written, < 0 if error.
	unit	input	int	Unit to write to.
	buffer	input	char *	Buffer containing the data to write.
	length	input	int	Length of data in buffer.


	$Header: /m/s1/dmk/xlate/sisio/RCS/_writeit.c,v 4.3 91/09/11 08:37:46 dmk Exp $

	$Log:	_writeit.c,v $
	Revision 4.3  91/09/11  08:37:46  dmk
	MODSET: 4.3
	Tests for CRAY rather than sun.
	
	Revision 4.1  90/07/13  09:06:25  dmk
	MODSET: 4.1
	Added code for format L.  Changed calls to eliminate need for dmklib.
	Changed SUN to sun.
	
	Revision 1.2  88/06/27  09:35:10  dmk
	MODSET: 1.2
	Will now flush the buffer if switching from reading to writing, rather
	than flagging an error.  Fixed a bug in the record length check.
	
	Revision 1.1  88/06/24  11:46:01  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"


int	_writeit( unit, buffer, length )

	int	unit;
	char *	buffer;
	int	length;

{
	int	ier;
	int	ferror;
	int	nwritten;
	int	c1 = 1, c4 = 4;
	int	start;

	/*
		Check or set record length as necessary.
	*/

	if ( _sisfit[ unit ].pointer == _sisfit[ unit ].headerat )

		if ( _sisfit[ unit ].hdrlen == 0 )
			_sisfit[ unit ].hdrlen = length;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].hdrlen != length )
					return( -E_NEWLEN );
		}

	else	/* pointer != headerat */

		if ( _sisfit[ unit ].trclen == 0 )
			_sisfit[ unit ].trclen = length;
		else
		{
			if ( _sisfit[ unit ].format != 0 &&
					_sisfit[ unit ].format != 'L' )
				if ( _sisfit[ unit ].trclen != length )
					return( -E_NEWLEN );
		}

	/*
		If large buffering is not enabled, simply write the record
		to the file.
	*/

	if ( ! _sisfit[ unit ].largebuf )
	{
		/*
			Translate control word and copy data to FIT buffer.
		*/

		if ( _sisfit[ unit ].cwlen == WORDSIZE )
			( void ) memcpy( _sisfit[ unit ].buffer,
				( char * ) &length, _sisfit[ unit ].cwlen );
		else
#ifdef	CRAY
			USICTI( &length, _sisfit[ unit ].buffer, &c1, &c1, &c4,
				&ier );
#else
		{
			_error( "_writeit", unit, E_INTERNAL );
			exit( E_SISIO + E_INTERNAL );
		}
#endif

		( void ) memcpy( _sisfit[ unit ].buffer + _sisfit[ unit ].cwlen,
			buffer, length );

		/*
			Write the data to the file.
		*/

		nwritten = write( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer,
			( unsigned ) ( length + _sisfit[ unit ].cwlen ) );

		if ( nwritten != length + _sisfit[ unit ].cwlen )
			return( -E_WRITE );

		_sisfit[ unit ].pointer += 1;

		return( nwritten );
	}

	/*
		If large buffering is enabled, fall through to here.

		First, check to make sure we are not already reading on this
		unit.  If we are, then flush the buffer.
	*/

	if ( _sisfit[ unit ].lgoper == L_READ )
	{
		ferror = _flushit( unit );
		if ( ferror < 0 ) return( ferror );
	}

	_sisfit[ unit ].lgoper = L_WRITE;

	/*
		If there is not enough room in the buffer for the record and
		a control word, write out the buffer.  If there is still not
		enough room, flag an error.
	*/

	if ( _sisfit[ unit ].bufsize - _sisfit[ unit ].bfrend <
		length + _sisfit[ unit ].cwlen )
	{
		nwritten = write( _sisfit[ unit ].filedes,
			_sisfit[ unit ].buffer,
			( unsigned ) _sisfit[ unit ].bfrend );

		if ( nwritten != _sisfit[ unit ].bfrend ) return( -E_WRITE );

		_sisfit[ unit ].bfrend = 0;
	}

	if ( _sisfit[ unit ].bufsize - _sisfit[ unit ].bfrend <
			length + _sisfit[ unit ].cwlen )
		return( -E_INTERNAL );

	/*
		Translate the control word, then copy the record to the FIT
		buffer.
	*/

	if ( _sisfit[ unit ].cwlen == WORDSIZE )
		( void ) memcpy( _sisfit[ unit ].buffer +
			_sisfit[ unit ].bfrend, ( char * ) &length, WORDSIZE );
	else
	{
#ifdef	CRAY
		start = _sisfit[ unit ].bfrend + 1;
		USICTI( &length, _sisfit[ unit ].buffer, &start, &c1, &c4,
			&ier );
#else
		_error( "_writeit", unit, E_INTERNAL );
		exit( E_SISIO + E_INTERNAL );
#endif
	}

	_sisfit[ unit ].bfrend += _sisfit[ unit ].cwlen;

	( void ) memcpy( _sisfit[ unit ].buffer + _sisfit[ unit ].bfrend,
		buffer, length );

	_sisfit[ unit ].bfrend += length;
	_sisfit[ unit ].pointer += 1;

	return( length );
}
