/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* ---------------------------------------------------------------------------

	Package	:	sisio
	Module	:	sisseek.c
	Author	:	Dean Kopesky
	Company	:	Minnesota Supercomputer Center, Inc.


	SISSEEK positions the unit at the specified trace.  If the trace number
	is less than 1, the file is positioned at trace 1.  If the trace number
	is greater than the number of traces, the file is positioned at EOF.
	This subroutine does not work on format L.

	FORTRAN:

	CALL SISSEEK( unit, trace )

	unit	input	integer	Unit to position.
	trace	input	integer	Trace number.

	C:

	sisseek( unit, trace );

	unit	input	int	Unit to position.
	trace	input	int	Trace number.


	$Header: /m/s1/dmk/xlate/sisio/RCS/sisseek.c,v 4.3 91/09/11 08:59:50 dmk Exp $

	Moved buffer declaration to top-level and made it static to prevent
	stack overflow on the Convex.
		      94/08/25            zjmw36

	$Log:	sisseek.c,v $
	Revision 4.3  91/09/11  08:59:50  dmk
	MODSET: 4.3
	Changed entry point names to macros.  Changed rtape() call.
	
	Revision 4.1  90/07/13  09:27:17  dmk
	MODSET: 4.1
	Added check for format L.  Changed SUN to sun.
	
	Revision 3.1  89/09/27  09:58:10  dmk
	MODSET: 3.1
	Added C entry point.  Now uses rtape() rather than RTAPE().
	
	Revision 2.4  88/09/26  14:38:11  dmk
	MODSET: 2.4
	Fixed a bug that was preventing SISSEEK from working when it was the
	first operation on a dataset (it was flushing the buffer too soon).
	
	Revision 2.1  88/07/12  15:16:00  dmk
	MODSET: 2.1
	Added lower case entry point for SUN.  Added SUN block:  rtape_ instead
	of RTAPE.  Eliminated use of SISERROR.
	
	Revision 1.2  88/06/27  09:39:51  dmk
	MODSET: 1.2
	Will now flush the buffer if large buffers are enabled, rather than
	flagging an error.  Will now use _sisfit[ unit ].cwlen rather than
	recalculating cwlen.
	
	Revision 1.1  88/06/24  12:24:30  dmk
	Initial revision
	
--------------------------------------------------------------------------- */


#include	"sisio.h"
#include	"sys/types.h"
#include	"unistd.h"

#define	MODULE	"SISSEEK"

static	char	buffer[ SMBUFSIZE ];

void	F_SISSEEK( unit, trace )

	int *	unit;
	int *	trace;

{
	C_SISSEEK( *unit, *trace );
}


void	C_SISSEEK( unit, trace )

	int	unit;
	int	trace;

{
/*
	char	buffer[ SMBUFSIZE ];
*/
#ifndef __convex__

/*
  I changed these to off_t declarations so they should hopefully be
  more accurate. - joe m. wade 4/25/95

	long	byte;
	int	pos;
*/
	off_t	byte,pos;
#else
	off64_t pos, byte;
#endif
	int	ferror;
	int	gohere;
	int	length;

	/*
		Initialize iff necessary; check unit for range; check for
		outstanding error; check to see if unit is open.  Check for
		format L.
	*/

	INITIALIZE;
	CHECKRANGE(MODULE,unit);
	CHECKERROR(MODULE,unit);
	CHECKOPEN(MODULE,unit);

	if ( _sisfit[ unit ].format == 'L' )
	{
		_error( MODULE, unit, E_NOTONL );
		return;
	}

	/*
		If we don't know how long the line header is, read it.
		If we don't know how long the traces are, read one.
	*/

	if ( trace >= 1 )
		gohere = trace;
	else
		gohere = 1;

	if ( _sisfit[ unit ].hdrlen == 0 )
	{
		C_RTAPE( unit, buffer, &length );
		if ( _sisfit[ unit ].error != 0 ) return;
	}

	if ( gohere > 1 && _sisfit[ unit ].trclen == 0 )
	{
		C_RTAPE( unit, buffer, &length );
		if ( _sisfit[ unit ].error != 0 ) return;
	}

	/*
		Check for large buffering.  If so, flush the buffer.
		( 7/13/98 - this followed the lseek previously, which
		  caused problems for obvious reasons - j.m.wade )
	*/

	if ( _sisfit[ unit ].largebuf )
	{
		ferror = _flushit( unit );
		if ( ferror < 0 )
		{
			_error( MODULE, unit, -ferror );
			return;
		}
	}

	/*
		Seek the proper location.
	*/


#ifndef __convex__
	byte = (off_t) _sisfit[ unit ].hdrlen + _sisfit[ unit ].cwlen
		+ (off_t) ((off_t)( gohere - 1 )
		* (off_t)( _sisfit[ unit ].trclen + _sisfit[ unit ].cwlen ));
	pos = lseek( _sisfit[ unit ].filedes, byte, 0 );
#else
	byte = (off64_t) _sisfit[ unit ].hdrlen + _sisfit[ unit ].cwlen
		+ (off64_t) ((off64_t)( gohere - 1 )
		* (off64_t)( _sisfit[ unit ].trclen + _sisfit[ unit ].cwlen ));
	pos = lseek64( _sisfit[ unit ].filedes, byte, SEEK_SET );
#endif

	if ( pos < 0 )
	{
		_error( MODULE, unit, E_LSEEK );
		return;
	}

	/*
		Figure out where we are, in case we tried to skip past EOF.
	*/

	_sisfit[ unit ].pointer =
		( pos - _sisfit[ unit ].hdrlen - _sisfit[ unit ].cwlen ) /
		( _sisfit[ unit ].trclen + _sisfit[ unit ].cwlen ) + 1;

}
