/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <setjmp.h>

#include "ikp_remote.h"

jmp_buf jumpbuf;

/*
   Buffered i/o routines used with sockets.
*/

void
alarmtr()
{
	signal(SIGALRM, alarmtr);
	longjmp(jumpbuf, -1);
}

int
buf_read(fd, buf, count)
int fd;
char *buf;
int count;
{
	int rem, nread;
	char *c;
	void alarmtr();

	c= buf;
	rem= count;

	if (setjmp(jumpbuf)) {
		alarm((unsigned) 0);
		return((int) (c-buf));
	}

	signal(SIGALRM, alarmtr);
	alarm((unsigned) SOCKIO_TIMEOUT);

	while (rem > 0) {
		nread= read(fd, c, rem);
		switch (nread) {
		case -1:
			alarm((unsigned) 0);
			if (c == buf)
				return(-1);
			else
				return((int) (c-buf));
			break;
		case 0:
			break;
		default:
			c+= nread;
			rem-= nread;
			alarm((unsigned) SOCKIO_TIMEOUT);
			break;
		}
	}
	alarm((unsigned) 0);
	return((int) (c-buf));
}

int
buf_write(fd, buf, count)
int fd;
char *buf;
int count;
{
	int rem, nwrite;
	char *c;
	void alarmtr();

	c= buf;
	rem= count;

	if (setjmp(jumpbuf)) {
		alarm((unsigned) 0);
		return((int) (c-buf));
	}
	signal(SIGALRM, alarmtr);
	alarm((unsigned) SOCKIO_TIMEOUT);

	while (rem > 0) {
		nwrite= write(fd, c, rem);
		switch (nwrite) {
		case -1:
			alarm((unsigned) 0);
			if (c == buf)
				return(-1);
			else
				return((int) (c-buf));
			break;
		case 0:
			break;
		default:
			c+= nwrite;
			rem-= nwrite;
			alarm((unsigned) SOCKIO_TIMEOUT);
			break;
		}
	}
	alarm((unsigned) 0);
	return((int) (c-buf));
}
