C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFFTML                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Performs multiple in-place, mixed-radix, complex FFT's with the*
C       data in natural order.                                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFFTMLTN  (CR,CI,WORK,TRIGS,IFAX,ICE,ICV,NE,NV,IDIR)            *
C  ARGUMENTS:                                                          *
C      CR      REAL     ??IOU*  (*)  -                                 *
C      CI      REAL     ??IOU*  (*)  -                                 *
C      WORK    REAL     ??IOU*  (*)  -                                 *
C      TRIGS   REAL     ??IOU*  (*)  -                                 *
C      IFAX    INTEGER  ??IOU*  (19) -                                 *
C      ICE     INTEGER  ??IOU*       -                                 *
C      ICV     INTEGER  ??IOU*       -                                 *
C      NE      INTEGER  ??IOU*       -                                 *
C      NV      INTEGER  ??IOU*       -                                 *
C      IDIR    INTEGER  ??IOU*       -                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JAN 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFFTMLTN( CR, CI, WORK, TRIGS, IFAX, ICE, ICV, NE, NV,    *
C      &               IDIR )                                          *
C                                                                      *
C  PARAMETERS:                                                         *
C       CR      REAL INPUT/OUTPUT MATRIX OF LOGICAL DIMENSION NE BY NV *
C               The real components of the source and results.         *
C                                                                      *
C       CI      REAL INPUT/OUTPUT MATRIX OF LOGICAL DIMENSION NE BY NV *
C               The imaginary components of the source and results.    *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH 4*NE*NV                  *
C                                                                      *
C       TRIGS   REAL INPUT VECTOR OF LENGTH 2*NE                       *
C               Sine and cosine table as generated by subroutine CFTFAX*
C                                                                      *
C       IFAX    INTEGER INPUT VECTOR OF LENGTH 19                      *
C               Factors of NE as generated by subroutine CFTFAX.       *
C                                                                      *
C       ICE     INTEGER INPUT SCALAR                                   *
C               The stride within each trace (data vector) in CR and CI*
C                                                                      *
C       ICV     INTEGER INPUT SCALAR                                   *
C               The stride between the start of each trace (data vector*
C               in CR and CI.  To obtain best performance, ICV should  *
C               be an odd number.                                      *
C                                                                      *
C       NE      INTEGER INPUT SCALAR                                   *
C               Length of each trace (data vector).  NE must factorable*
C               as: NE = 2**p * 3**q * 5**r where p, q, and r are      *
C               integers.                                              *
C                                                                      *
C       NV      INTEGER INPUT SCALAR                                   *
C               Number of traces (data vectors).                       *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR                                   *
C               Function selector:                                     *
C                  IDIR = -1,           do forward FFT                 *
C                  IDIR =  1,           do inverse FFT                 *
C                  IDIR <  0 and != -1, rearrange data from FFT order  *
C                                       to natural order               *
C                  IDIR >= 0 and !=  1, rearrange data from natural    *
C                                       order to FFT order             *
C                                                                      *
C  DESCRIPTION:                                                        *
C       CFFTMLTN functions identically to the Cray SCILIB subroutine   *
C       CFFTMLT except that the data is in natural order and CFFTMLTN  *
C       has the capability to rearrange the data without performing the*
C       FFT's.                                                         *
C                                                                      *
C       If NE is even then the normal FFT output ordering of the       *
C       frequency indices is:                                          *
C          0, 1, 2, ..., NE/2-1, NE/2, -(NE/2-1), -(NE/2-2), ..., -2, -*
C       If NE is odd, then the FFT order is:                           *
C          0, 1, 2, ..., NE/2-1, NE/2, -NE/2, -(NE/2-1), ..., -2, -1   *
C       Natural order is -(NE/2-1), -(NE/2-2), ..., NE/2-1, NE/2 and   *
C       -NE/2, -(NE/2-1), ..., NE/2-1, NE/2 for even and odd NE,       *
C       respectively.                                                  *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CFFTMLT                                                        *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C----------------------------------------------------------------------*
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CFFTML -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFFTMLTN  MULTIPLE CFFT, NATURAL ORDER         REV 1.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE CFFTMLTN( CR, CI, WORK, TRIGS, IFAX, ICE, ICV, NE, NV,
     &                     IDIR )
C
      INTEGER IFAX(19), ICE, ICV, NE, NV, IDIR
      REAL    CR(*), CI(*), WORK(*), TRIGS(*)
C
#ifdef CRAY
      REAL    SCALE(10)
C
      DATA SCALE / 1.0, 2.0, 4.0, 4.5, 5.5, 6.0, 8.0, 13.0, 15.0, 28.0 /
#endif
C
C-----------------------------------------------------------------------
C
C  Choose method
C
#ifdef CRAY
      ISC1 = 0
      M    = ICE
  110 CONTINUE
         ISC1 = ISC1 + 1
         LAST = M
         M    = M / 2
         IF( 2*M .EQ. LAST .AND. ISC1 .LT. 10 ) GO TO 110
C
      ISC2 = 0
      M    = ICV
  120 CONTINUE
         ISC2 = ISC2 + 1
         LAST = M
         M    = M / 2
         IF( 2*M .EQ. LAST .AND. ISC2 .LT. 10 ) GO TO 120
C
      C1 = ( 8.0 * SCALE(ISC1) + 8.0 ) * ( NV * NE ) + 300.0 * NV
      C2 = 8.0 * SCALE(ISC2) * ( NV * NE ) + 200.0 * NE
C
      IF( C1 .LT. C2 ) THEN
         METHOD = 1
      ELSE
         METHOD = 2
      ENDIF
#else
      IF( NE .LT. 20 .OR. NV .LT. 10 ) THEN
         IF( NV .LT. NE ) THEN
            METHOD = 1
         ELSE
            METHOD = 2
         ENDIF
      ELSE
         L1 = 1 + (NE - 1) * ICE
         L2 = 1 + (NV - 1) * ICV
         IF( L1 .LT. L2 ) THEN
            METHOD = 1
         ELSE
            METHOD = 2
         ENDIF
      ENDIF
#endif
C
      IF( IDIR .EQ. -1 ) THEN
         CALL CFFTMLT( CR, CI, WORK, TRIGS, IFAX, ICE, ICV, NE, NV,
     &                 IDIR )
      ENDIF
C
      IF( IDIR .LT. 0 ) THEN
         N1 = (NE + 2) / 2
         N2 = (NE - 1) / 2
      ELSE
         N2 = (NE + 2) / 2
         N1 = (NE - 1) / 2
      ENDIF
C
      IF( METHOD .EQ. 1 ) THEN
         JWR = 1
         JWI = 1 + N1
         J1  = 1
         J2  = 1 + ICE * N1
         J3  = 1 + ICE * N2
         DO 240 J = 1, NV
C
C           CALL VMOV( CR(J1)   , ICE, WORK(JWR),   1, N1 )
C           CALL VMOV( CI(J1)   , ICE, WORK(JWI),   1, N1 )
C
            K1  = J1
            KWR = JWR
            KWI = JWI
            DO 210 K = 1, N1
               WORK(KWR) = CR(K1)
               WORK(KWI) = CI(K1)
               K1  = K1  + ICE
               KWR = KWR + 1
               KWI = KWI + 1
  210       CONTINUE
C
C           CALL VMOV( CR(J2)   , ICE, CR(J1)   , ICE, N2 )
C           CALL VMOV( CI(J2)   , ICE, CI(J1)   , ICE, N2 )
C
            K1 = J1
            K2 = J2
            DO 220 K = 1, N2
               CR(K1) = CR(K2)
               CI(K1) = CI(K2)
               K1 = K1 + ICE
               K2 = K2 + ICE
  220       CONTINUE
C
C           CALL VMOV( WORK(JWR),   1, CR(J3)   , ICE, N1 )
C           CALL VMOV( WORK(JWI),   1, CI(J3)   , ICE, N1 )
C
            K3  = J3
            KWR = JWR
            KWI = JWI
            DO 230 K = 1, N1
               CR(K3) = WORK(KWR)
               CI(K3) = WORK(KWI)
               K3  = K3  + ICE
               KWR = KWR + 1
               KWI = KWI + 1
  230       CONTINUE
C
            J1 = J1 + ICV
            J2 = J2 + ICV
            J3 = J3 + ICV
  240    CONTINUE
      ELSE
         IF( IDIR .LT. 0 ) THEN
            J1 = 1
            J2 = 1 + ICE * N2
            JI = ICE
            MM = N2
            NN = N1 - N2
         ELSE
            J1 = 1 + ICE * (NE - 1)
            J2 = 1 + ICE * (NE - 1 - N1)
            JI = - ICE
            MM = N1
            NN = N2 - N1
         ENDIF
         J3  = J2
         JWR = 1
         JWI = 1 + 2 * NV
         DO 320 I = 1, NN
C
C           CALL VMOV( CR(J3), ICV, WORK(JWR), 1, NV )
C           CALL VMOV( CI(J3), ICV, WORK(JWI), 1, NV )
C
            K3  = J3
            KWR = JWR
            KWI = JWI
            DO 310 K = 1, NV
               WORK(KWR) = CR(K3)
               WORK(KWI) = CI(K3)
               K3  = K3  + ICV
               KWR = KWR + 1
               KWI = KWI + 1
  310       CONTINUE
            JWR = JWR + NV
            JWI = JWI + NV
            J3  = J3  + JI
  320    CONTINUE
C
         DO 350 I = 1, MM
C
C           CALL VMOV( CR(J1), ICV, CR(J2), ICV, NV )
C           CALL VMOV( CI(J1), ICV, CI(J2), ICV, NV )
C
            K1 = J1
            K2 = J2
            DO 330 K = 1, NV
               CR(K2) = CR(K1)
               CI(K2) = CI(K1)
               K1 = K1 + ICV
               K2 = K2 + ICV
  330       CONTINUE
C
C           CALL VMOV( CR(J3), ICV, CR(J1), ICV, NV )
C           CALL VMOV( CI(J3), ICV, CI(J1), ICV, NV )
C
            K1 = J1
            K3 = J3
            DO 340 K = 1, NV
               CR(K1) = CR(K3)
               CI(K1) = CI(K3)
               K1 = K1 + ICV
               K3 = K3 + ICV
  340       CONTINUE
C
            J1 = J1 + JI
            J2 = J2 + JI
            J3 = J3 + JI
  350    CONTINUE
C
         JWR = 1
         JWI = 1 + 2 * NV
         DO 370 I = 1, NN
C
C           CALL VMOV( WORK(JWR), 1, CR(J2), ICV, NV )
C           CALL VMOV( WORK(JWI), 1, CI(J2), ICV, NV )
C
            K2  = J2
            KWR = JWR
            KWI = JWI
            DO 360 K = 1, NV
               CR(K2) = WORK(KWR)
               CI(K2) = WORK(KWI)
               K2  = K2  + ICV
               KWR = KWR + 1
               KWI = KWI + 1
  360       CONTINUE
            JWR = JWR + NV
            JWI = JWI + NV
            J2  = J2  + JI
  370    CONTINUE
      ENDIF
C
      IF( IDIR .EQ. 1 ) THEN
         CALL CFFTMLT( CR, CI, WORK, TRIGS, IFAX, ICE, ICV, NE, NV,
     &                 IDIR )
      ENDIF
C
      RETURN
      END
