C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FFTFAX                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FFTFAX  (N,IRFAC,TRIG)                                          *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU*      -                                  *
C      IRFAC   INTEGER  ??IOU*  (*) -                                  *
C      TRIG    REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C********************************************************************C
C NAME: FFTFAX  SCILIB ANALOG                   REV 1.0     JAN 90   C
C********************************************************************C
C
C  PURPOSE:
C       This subroutine provides a dummy routine to be called in
C       place of the similarly named SCILIB routine.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                   JAN 90       T.G. MATTSON, QTC
C
C  CALLING FORMAT:
C       CALL FFTFAX (N, IRFAC, TRIG)
C
C  PARAMETERS:
C       N       Integer scalar.  Length of FFT.
C
C       IRFAC   Integer Array.  SCILIB returns an array of factors
C               in this array.  This routine sets the first element
C               of the array to N.
C
C       TRIG    Real Array.  SCILIB returns an array of Trig functions
C               in this array.  FFTFAX does nothing to this array.
C
C
C  DESCRIPTION:
C       This subroutine is a dummy routine.  It is provided to
C       allow programs to link.   The SCILIB version of this routine
C       sets up tables for the looping mixed radix FFT's.  Since
C       the qtc analogs of these FFT routines do not use a perset
C       tables, this routine is just a dummy routine.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       None
C
C---------------------------------------------------------------------
C
      SUBROUTINE FFTFAX (N, IRFAC, TRIG)
C
      INTEGER N, IRFAC(*)
      REAL TRIG(*)
C
C---------------------------------------------------------------------
C
      IRFAC(1) = N
C
      RETURN
      END
