C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       GENIX                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       GENERATES THE COMPRESSED INDEX DATA STRUCTURE GIVEN THE        *
C       INDEX MATRIX.                                                  *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      GENIX  (NX,NZ,INDEX,ITEMP,IVP,IVV,IXP,IXX)                      *
C      XGENIX  (NX,NZ,INDEX,ITEMP,IVP,IVV,IXP,IXX)                     *
C  ARGUMENTS:                                                          *
C      NX      INTEGER  ??IOU*          -                              *
C      NZ      INTEGER  ??IOU*          -                              *
C      INDEX   INTEGER  ??IOU*  (NX,NZ) -                              *
C      ITEMP   INTEGER  ??IOU*  (NX)    -                              *
C      IVP     INTEGER  ??IOU*  (*)     -                              *
C      IVV     INTEGER  ??IOU*  (*)     -                              *
C      IXP     INTEGER  ??IOU*  (*)     -                              *
C      IXX     INTEGER  ??IOU*  (*)     -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 87          R.D. COLEMAN, QTC      *
C       REL 2.0                 APR 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  GENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)         *
C       CALL XGENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)         *
C                                                                      *
C  PARAMETERS:                                                         *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S.                                         *
C                                                                      *
C       NZ      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Z'S.                                         *
C                                                                      *
C       INDEX   INTEGER INPUT MATRIX OF DIMENSION NX BY NZ             *
C                                                                      *
C       ITEMP   INTEGER SCRATCH VECTOR OF LENGTH NX                    *
C                                                                      *
C       IVP     INTEGER OUTPUT VECTOR OF LENGTH NZ + 1                 *
C               VELOCITY INDEX POINTER VECTOR.                         *
C                                                                      *
C       IVV     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH                *
C               VELOCITY INDEX VALUE VECTOR.                           *
C                                                                      *
C       IXP     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH                *
C               X INDEX POINTER VECTOR.                                *
C                                                                      *
C       IXX     INTEGER OUTPUT VECTOR OF IMPLIED LENGTH                *
C               X INDEX VALUE VECTOR.                                  *
C                                                                      *
C  DESCRIPTION:                                                        *
C       GIVEN THE NX BY NZ INDEX MATRIX, XGENIX GENERATES THE          *
C       COMPRESSED INDEX DATA STRUCTURE: IVP, IVV, IXP, AND IXX.       *
C       THE COMPRESSED DATA STRUCTURE CONTAINS COMPLETE INDEX INFOR-   *
C       MATION FOR IZ = 1.  IF IZ > 1, THEN IT ONLY CONTAINS DATA      *
C       ON DIFFERENCES BETWEEN THE INDICES AT IZ-1 AN IZ.              *
C                                                                      *
C       THE VECTOR IVP CONTAINS POINTERS INTO THE VECTORS IVV AND      *
C       IXP.  GIVEN A Z INDEX, IZ, THE DATA IN IVV AND IXP THAT IS     *
C       ASSOCIATED WITH THAT Z IS CONTAINED IN ELEMENTS J1 = IVP(IZ)   *
C       THROUGH J2 = IVP(IZ+1)-1.  IF IVP(IZ) = IVP(IZ+1), THEN        *
C       THERE ARE NO DIFFERENCES BETWEEN THE INDICES AT IZ-1 AND IZ.   *
C       IVP(NZ+1) POINTS TO THE LAST ELEMENT PLUS ONE IN IVV AND IXP.  *
C                                                                      *
C       THE VECTOR IVV CONTAINS VALUES OF VELOCITY INDICES AND THE     *
C       CORRESPONDING ELEMENTS IN IXP CONTAINS POINTERS INTO IXX       *
C       WHICH CONTAINS LISTS OF X INDICES THAT HAVE THE VELOCITY       *
C       INDEX.  THAT IS, THE ELEMENTS IXX(I1) THROUGH IXX(I2)          *
C       WHERE I1 = IXP(J) AND I2 = IXP(J+1)-1 ARE X INDICES WHICH      *
C       HAVE THE VELOCITY INDEX IVV(J).                                *
C                                                                      *
C       EXAMPLE:                                                       *
C          GIVEN THE INPUTS:                                           *
C             NX = 10                                                  *
C             NZ =  4                                                  *
C                                                                      *
C             TRANSPOSE( INDEX ) =  2 2 4 4 4 2 3 3 1 4                *
C                                   2 2 2 4 2 2 3 3 3 4                *
C                                   2 2 2 4 2 2 3 3 3 4                *
C                                   2 2 2 2 2 2 3 3 3 3                *
C                                                                      *
C          THEN THE OUTPUTS ARE:                                       *
C                                                                      *
C             I   IVP(I)   IVV(I)   IXP(I)   IXX(I)                    *
C                                                                      *
C             1      1        2        1        1                      *
C             2      5        4        4        2                      *
C             3      7        3        8        6                      *
C             4      7        1       10        3                      *
C             5      9        2       11        4                      *
C             6               3       13        5                      *
C             7               2       14       10                      *
C             8               3       15        7                      *
C             9                       16        8                      *
C            10                                 9                      *
C            11                                 3                      *
C            12                                 5                      *
C            13                                 9                      *
C            14                                 4                      *
C            15                                10                      *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: GENIX     GENERATE COMPRESSED INDEX DATA       REV 2.0  APR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  GENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)
      ENTRY      XGENIX (NX, NZ, INDEX, ITEMP, IVP, IVV, IXP, IXX)
C
      INTEGER NX, NZ, INDEX(NX,NZ), ITEMP(NX),
     &        IVP(*), IVV(*), IXP(*), IXX(*)
C
C-----------------------------------------------------------------------
C
      II = 0
      KK = 0
      DO 300 IZ = 1, NZ
         IVP(IZ) = KK + 1
C
         DO 110 I = 1, NX
            ITEMP(I) = INDEX(I,IZ)
  110    CONTINUE
C
         I1 = 1
         IF (IZ .EQ. 1) GO TO 200
C
         DO 120 I = 1, NX
            IF (INDEX(I,IZ) .EQ. INDEX(I,IZ-1)) ITEMP(I) = 0
  120    CONTINUE
C
  200    CONTINUE
         DO 210 I = I1, NX
            IF (ITEMP(I) .NE. 0) GO TO 220
  210    CONTINUE
         GO TO 300
C
  220    CONTINUE
         I1 = I
         JV = ITEMP(I1)
         ITEMP(I1) = 0
         II = II + 1
         IXX(II) = I1
         KK = KK + 1
         IVV(KK) = JV
         IXP(KK) = II
         DO 230 I = I1, NX
            IF (ITEMP(I) .EQ. JV) THEN
               ITEMP(I) = 0
               II = II + 1
               IXX(II) = I
            ENDIF
  230    CONTINUE
         GO TO 200
C
  300 CONTINUE
C
      IVV(KK+1) = 0
      IXP(KK+1) = II + 1
      IVP(NZ+1) = KK + 1
C
      RETURN
      END
 
