C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       GTAB2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       MULTIPLYS A REAL MATRIX AND A COMPLEX SUB-MATRIX WHERE THE     *
C       COMPLEX MATRICES ARE EXPRESSED BY TWO REAL MATRICES.           *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      GTAB2  (A,BR,BI,CR,CI,L,M,N)                                    *
C      CGTAB2  (A,BR,BI,CR,CI,L,M,N)                                   *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (M,M) -                                *
C      BR      REAL     ??IOU*  (L,N) -                                *
C      BI      REAL     ??IOU*  (L,N) -                                *
C      CR      REAL     ??IOU*  (M,N) -                                *
C      CI      REAL     ??IOU*  (M,N) -                                *
C      L       INTEGER  ??IOU*        -                                *
C      M       INTEGER  ??IOU*        -                                *
C      N       INTEGER  ??IOU*        -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       CRAY-2 VERSION: CRAY ASSEMBLY LANGUAGE                         *
C       OTHERS: FORTRAN 77                                             *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUL 87          R.D. COLEMAN, QTC      *
C       REV 2.0                 APR 88          T.G. MATTSON, QTC      *
C               modified for m,n >64                                   *
C       REL 3.0                 FEB 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  GTAB2 (A, BR, BI, CR, CI, L, M, N)                       *
C       CALL CGTAB2 (A, BR, BI, CR, CI, L, M, N)                       *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       REAL INPUT MATRIX OF DIMENSION M X M                   *
C               REAL INPUT MATRIX.                                     *
C                                                                      *
C       BR      REAL INPUT MATRIX OF DIMENSION L X N                   *
C               REAL COMPONENTS OF THE COMPLEX INPUT MATRIX ARE        *
C               CONTAINED IN THE FIRST M ROWS.                         *
C                                                                      *
C       BI      REAL INPUT MATRIX OF DIMENSION L X N                   *
C               IMAGINARY COMPONENTS OF THE COMPLEX INPUT MATRIX ARE   *
C               CONTAINED IN THE FIRST M ROWS.                         *
C                                                                      *
C       CR      REAL OUTPUT MATRIX OF DIMENSION M X N                  *
C               REAL COMPONENTS OF THE RESULT MATRIX.                  *
C                                                                      *
C       CI      REAL OUTPUT MATRIX OF DIMENSION M X N                  *
C               IMAGINARY COMPONENTS OF THE RESULT MATRIX.             *
C                                                                      *
C       L       INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF MATRICES BR AND BI.                   *
C                                                                      *
C       M       INTEGER INPUT SCALAR                                   *
C               ROW AND COLUMN DIMENSION OF MATRIX A AND ROW DIMENSION *
C               OF SUB-MATRICES BR AND BI AND MATRICES CR AND CI.      *
C               M MUST BE LESS THAN OR EQUAL TO L.                     *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               COLUMN DIMENSION OF MATRICES BR, BI, CR AND CI.        *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THIS ROUTINE PERFORMS THE FOLLOWING MATRIX MULTIPLICATIONS:    *
C                                                                      *
C          CR = A * BR                                                 *
C          CI = A * BI                                                 *
C                                                                      *
C       IF L > M, THEN ONLY THE FIRST M ROWS OF BR AND BI ARE USED.    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: GTAB2     XGTAB MATRIX MULTIPLY                REL 3.0  FEB 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  GTAB2 (A, BR, BI, CR, CI, L, M, N)
      ENTRY      CGTAB2 (A, BR, BI, CR, CI, L, M, N)
C
      REAL A(M,M), BR(L,N), BI(L,N), CR(M,N), CI(M,N)
C
      DO 120 J = 1, N
         DO 110 I = 1, M
            CR(I,J) = 0.0
            CI(I,J) = 0.0
  110    CONTINUE
  120 CONTINUE
C
      DO 230 J = 1, N
         DO 220 K = 1, M
            SR = BR(K,J)
            SI = BI(K,J)
            DO 210 I = 1, M
               CR(I,J) = CR(I,J) + SR * A(I,K)
               CI(I,J) = CI(I,J) + SI * A(I,K)
  210       CONTINUE
  220    CONTINUE
  230 CONTINUE
C
      RETURN
      END
