C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       MEXIT                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C      MEXIT writes the completion message, closes the SIS files and   *
C      exits the program.                                              *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      MEXIT  (IERR,LUERR,LUINP,LUOUT)                                 *
C  ARGUMENTS:                                                          *
C      IERR    INTEGER  ??IOU* -                                       *
C      LUERR   INTEGER  ??IOU* -                                       *
C      LUINP   INTEGER  ??IOU* -                                       *
C      LUOUT   INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL MEXIT( IERR, LUERR, LUINP, LUOUT )                        *
C                                                                      *
C  PARAMETERS:                                                         *
C       IERR    INTEGER INPUT SCALAR                                   *
C               Completion code.  IERR = 0 for normal completion       *
C                                     != 0 otherwise                   *
C                                                                      *
C       LUERR   INTEGER INPUT SCALAR                                   *
C               Logical unit number for completion message.            *
C               If LUERR < 0, then the completion message is suppressed*
C                                                                      *
C       LUINP   INTEGER INPUT SCALAR                                   *
C               Logical unit number of input SIS dataset.              *
C               If LUINP > 1, then the file is assumed to be opened.   *
C               Otherwise, it is assumed that the file is not opened.  *
C                                                                      *
C       LUOUT   INTEGER INPUT SCALAR                                   *
C               Logical unit number of output SIS dataset.             *
C               If LUOUT > 1, then the file is assumed to be opened.   *
C               Otherwise, it is assumed that the file is not opened.  *
C                                                                      *
C  DESCRIPTION:                                                        *
C      MEXIT conditionally writes the completion message, closes any SI*
C      files that are opened and exits the program.                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LBCLOS -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUERR  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      0  ( 1) -                                                       *
C      1  ( 1) -                                                       *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: MEXIT     EXIT MIGRATION PROGRAM               REV 1.0  NOV 91 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE MEXIT( IERR, LUERR, LUINP, LUOUT )
C
C  SUBROUTINE ARGUMENTS
C
      INTEGER IERR, LUERR, LUINP, LUOUT
C
C-----------------------------------------------------------------------
C
  901 FORMAT (/' ', '***** NORMAL COMPLETION *****'/)
  902 FORMAT (/' ', '***** ABNORMAL COMPLETION CODE = ', I4, ' *****'/)
C
C-----------------------------------------------------------------------
C
      IF( LUINP .GE. 0 ) CALL LBCLOS (LUINP)
      IF( LUOUT .GE. 0 ) CALL LBCLOS (LUOUT)
C
      IF( IERR .LE. 0 ) THEN
         IF( LUERR .GT. 0) WRITE( LUERR, 901 )
         STOP 0
      ELSE
         IF( LUERR .GT. 0) WRITE( LUERR, 902 ) IERR
         STOP 1
      ENDIF
C
      END
