C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RDVMOD                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      RDVMOD  (LUVEL,NSMP,DZVM,FMAX,TEND,TRACE,NZSEG,NZT,IZSNZ,ZSDZ,  *
C               ZSSLOW,IERR)                                           *
C  ARGUMENTS:                                                          *
C      LUVEL   INTEGER  ??IOU*      -                                  *
C      NSMP    INTEGER  ??IOU*      -                                  *
C      DZVM    REAL     ??IOU*      -                                  *
C      FMAX    REAL     ??IOU*      -                                  *
C      TEND    REAL     ??IOU*      -                                  *
C      TRACE   REAL     ??IOU*  (*) -                                  *
C      NZSEG   INTEGER  ??IOU*      -                                  *
C      NZT     INTEGER  ??IOU*      -                                  *
C      IZSNZ   INTEGER  ??IOU*  (*) -                                  *
C      ZSDZ    REAL     ??IOU*  (*) -                                  *
C      ZSSLOW  REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RTAPE -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C      FLOAT   REAL    -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*********************************************************************
C NAME: RDVMOD  READ VELOCITY MODEL             REV 1.1     JUL 92   *
C*********************************************************************
C
C  PURPOSE:
C       RDVMOD READS A V(Z) VELOCITY MODEL (A TRACE) FROM A SIS
C       VELOCITY FILE AND GENERATE A VELOCITY MODEL IN THE FORMAT
C       REQUIRED BY THE 2D V(Z) MIGRATION PROGRAMS.
C
C
C  CALLING FORMAT:
C       CALL RDVMOD (LUVEL, NSMP, DZVM, FMAX, TEND, TRACE,
C      &             NZSEG, NZT, IZSNZ, ZSDZ, ZSSLOW, IERR)
C
C  PARAMETERS:
C       LUVEL   INTEGER INPUT SCALAR
C               LOGICAL UNIT NUMBER OF VELOCITY FILE
C
C       NSMP    INTEGER INPUT SCALAR
C               NUMBER OF VELOCITY SAMPLES PER TRACE
C
C       DZVM    REAL INPUT SCALAR
C               DEPTH SAMPLE INTERVAL
C
C       FMAX    REAL INPUT SCALAR
C               MAXIMUM FREQUENCY
C
C       TEND    REAL INPUT SCALAR
C               ENDING TIME
C
C       TRACE   REAL WORK VECTOR OF IMPLIED LENGTH
C               BUFFER FOR INPUT TRACE
C
C       NZSEG   INTEGER OUTPUT SCALAR
C               NUMBER OF OUTPUT Z SEGMENTS
C
C       NZT     INTEGER OUTPUT SCALAR
C               TOTAL NUMBER OF Z STEPS = SUM[ IZSNZ(I), I = 1, NZSEG ]
C
C       IZSNZ   INTEGER OUTPUT VECTOR OF LENGTH NZSEG
C               NUMBER OF Z STEPS IN EACH Z SEGMENT
C
C       ZSDZ    REAL OUTPUT VECTOR OF LENGTH NZSEG
C               DELTA Z FOR EACH Z SEGMENT
C
C       ZSSLOW  REAL OUTPUT VECTOR OF LENGTH NZSEG
C               RECIPROCAL OF THE INTERVAL VELOCITY IN EACH Z SEGMENT
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE:
C                  = 0 - NORMAL COMPLETION
C                  = 1 - FILE READ ERROR
C
C  DESCRIPTION:
C       RDVMOD READS A VELOCITY MODEL (A TRACE) FROM THE VELOCITY FILE
C       WHERE TRACE.DATA(I) IS THE VELOCITY AT Z = I*DZVM.  CONTIGUOUS
C       VELOCITY SAMPLES OF EQUAL VALUE ARE GROUPED INTO Z SEGMENTS
C       AND PARAMETERS ARE CALCULATED FOR EACH Z SEGMENTS.  NOTE: A
C       Z SEGMENT IS A REGION IN THE VERTICAL DIMENSION OF CONSTANT
C       VELOCITY AND IS DEFINED BY A BEGINNING AND ENDING DEPTH (Z) AND
C       AND THE INTERVAL VELOCITY.
C
C  ERROR CONDITIONS:
C       IF AN ERROR OCCURS IN ATTEMPTING TO READ A TRACE FROM THE
C       VELOCITY FILE, THEN IERR IS SET TO 1 AND THE ROUTINE IS
C       ABORTED.
C
C  SUBPROGRAMS CALLED:
C       RTAPE
C
C  HISTORY
C       ORIGINAL        DEC 90          R.D. COLEMAN, QTC
C       REV 1.1         JUL 92          R.D. COLEMAN, CETech
C               Made subroutine portable.
C
C----------------------------------------------------------------------
C
      SUBROUTINE RDVMOD (LUVEL, NSMP, DZVM, FMAX, TEND, TRACE,
     &                   NZSEG, NZT, IZSNZ, ZSDZ, ZSSLOW, IERR)
C
C  PARAMETERS:
C
      INTEGER NTHDR
C                         Number of trace header words
C
#ifdef CRAY
      PARAMETER (NTHDR = 128)
#else
      PARAMETER (NTHDR =  64)
#endif
C
C  FORMAL PARAMETERS:
C
      REAL    DZVM
C                         Depth sample interval for input velocities
      REAL    FMAX
C                         Maximum frequency
      INTEGER IERR
C                         Completion code
      INTEGER IZSNZ (*)
C                         Number of Z's per Z segment
      INTEGER LUVEL
C                         Logical unit number of velocity file
      INTEGER NSMP
C                         Number of samples per velocity model (trace)
      INTEGER NZSEG
C                         Number of Z segments
      INTEGER NZT
C                         Number of Z's total
      REAL    TEND
C                         End time
      REAL    TRACE (*)
C                         Trace
      REAL    ZSDZ  (*)
C                         Maximum interval velocity for Z segment
      REAL    ZSSLOW(*)
C                         Minimum interval velocity for Z segment
C
C  LOCAL VARIABLES:
C
      REAL    DT
C                         Delta time (two-way)
      REAL    DZMAX
C                         Maximum delta Z
      INTEGER I
C                         Z segment index
      INTEGER J
C                         Sample index
      INTEGER NBYTES
C                         Number of bytes read
      INTEGER NDZ
C                         Number of Z steps in Z segment
      REAL    T
C                         Two-way travel time
      REAL    V
C                         Velocity
      REAL    VLAST
C                         Velocity in last sample
      REAL    Z
C                         Depth
      REAL    ZLAST
C                         Depth at end of last Z segment
      REAL    ZSTEP
C                         Change in depth for Z segment (NDZ*DZ)
C
C  SUBROUTINES CALLED:
C
      EXTERNAL RTAPE
C                         Read trace from an SIS dataset
C
C-----------------------------------------------------------------------
C
      IERR  = 0
      NZSEG = 0
C
C  READ VELOCITY MODEL (TRACE) FROM FILE
C
      CALL RTAPE( LUVEL, TRACE, NBYTES )
C
      IF (NBYTES .EQ. 0) THEN
          IERR = 1
          RETURN
      ENDIF
C
C  GROUP SAMPLES INTO Z SEGMENTS.  NOTE: TEMPORARILY, ZSDZ CONTAINS
C  DEPTH AT BOTTOM OF SEGMENT AND ZSSLOW CONTAINS THE SEGMENT VELOCITY.
C
      VLAST = -1.0
      I     = 0
      Z     = 0.0
      T     = 0.0
      DO 110 J = 1, NSMP
          V = TRACE(J+NTHDR)
C
          IF (V .NE. VLAST) THEN
              VLAST = V
              DT    = 2.0 * DZVM / V
              I     = I + 1
              ZSSLOW(I) = V
          ENDIF
C
          IF (T + DT .GT. TEND) GO TO 120
C
          Z = Z + DZVM
          T = T + DT
C
          ZSDZ(I) = Z
  110 CONTINUE
C
C  FIX UP FOR END TIME
C
  120 CONTINUE
      DT = TEND - T
      ZSDZ(I) = Z + 0.5 * V * DT
C
C  CALCULATE SEGMENT PARAMETERS
C
  200 CONTINUE
      NZSEG = I
      NZT   = 0
      ZLAST = 0.0
      DO 210 I = 1, NZSEG
          V     = ZSSLOW(I)
          ZSTEP = ZSDZ(I) - ZLAST
          ZLAST = ZSDZ(I)
          DZMAX = 0.25 * V / FMAX
          NDZ   = IFIX( ZSTEP / DZMAX )
          IF (DZMAX*FLOAT(NDZ) .LT. ZSTEP) NDZ = NDZ + 1
C
          NZT       = NZT + NDZ
          IZSNZ(I)  = NDZ
          ZSDZ(I)   = ZSTEP / FLOAT( IZSNZ(I) )
          ZSSLOW(I) = 1.0 / V
  210 CONTINUE
C
      RETURN
      END
