C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RFFT2M                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES NT REAL TO COMPLEX FORWARD FFT'S OR NT COMPLEX TO     *
C       REAL INVERSE FFT'S.                                            *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RFFT2MTC  (X,IDIR,IW1,NW,NS,NT,WRK,IERR)                        *
C      XRFFT  (X,IDIR,IW1,NW,NS,NT,WRK,IERR)                           *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C      IW1     INTEGER  ??IOU*      -                                  *
C      NW      INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      NT      INTEGER  ??IOU*      -                                  *
C      WRK     REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                APR 87          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RFFT2MTC (X, IDIR, IW1, NW, NS, NT, WRK, IERR)            *
C       CALL XRFFT    (X, IDIR, IW1, NW, NS, NT, WRK, IERR)            *
C                                                                      *
C  PARAMETERS:                                                         *
C       X       REAL/COMPLEX INPUT/OUTPUT ARRAY OF LENGTH NS * NT.     *
C               FOR FORWARD FFT'S, X CONTAINS AN NS BY NT REAL MATRIX  *
C               ON INPUT AND AN NW BY NT COMPLEX MATRIX ON OUTPUT.     *
C               FOR INVERSE FFT'S, X CONTAINS AN NW BY NT COMPLEX      *
C               MATRIX ON INPUT AND AN NS BY NT REAL MATRIX ON OUTPUT. *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR.                                  *
C               FFT DIRECTION SWITCH: IDIR >= 0 FOR FORWARD FFT'S AND  *
C               IDIR < 0 FOR INVERSE FFT'S.                            *
C                                                                      *
C       IW1     INTEGER INPUT SCALAR.                                  *
C               INDEX OF FIRST FREQUENCY COMPONENT.  IW1 MUST BE       *
C               BETWEEN 1 AND NS/2.                                    *
C                                                                      *
C       NW      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF FREQUENCY COMPONENTS.  NW MUST BE BETWEEN    *
C               0 AND NS/2-IW1+1.                                      *
C                                                                      *
C       NS      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF REAL ELEMENTS PER TRACE.  NS MUST BE A POWER *
C               OF 2 BETWEEN 16 AND 16384.                             *
C                                                                      *
C       NT      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF TRACES.                                      *
C                                                                      *
C       WRK     REAL SCRATCH VECTOR OF LENGTH 4 * NS + 6               *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR.                                 *
C               COMPLETION CODE.  IERR = 0 FOR NORMAL COMPLETION;      *
C               OTHERWISE, IT IS SET TO THE SUM OF THE CONDITION CODES *
C               THAT APPLY.  THE CONDITION CODE VALUES ARE:            *
C                  1 - THE VALUE OF IW1 IS INVALID                     *
C                  2 - THE VALUE OF NW  IS INVALID                     *
C                  4 - THE VALUE OF NS  IS INVALID                     *
C                  8 - THE VALUE OF NT  IS INVALID                     *
C                                                                      *
C  DESCRIPTION:                                                        *
C       IF THE FORWARD FFT IS SELECTED, THEN XRFFT PERFORMS A REAL TO  *
C       COMPLEX FORWARD FFT ON NT TRACES EACH OF LENGTH NS.  THE NT    *
C       TRACES ARE STORED AS COLUMNS OF AN NS BY NT REAL MATRIX X.     *
C       ONLY THE FREQUENCY COMPONENTS OF THE RESULTS THAT ARE SELECTED *
C       BY IW1 AND NW ARE STORED BACK INTO X.  THE SELECTED RESULTS    *
C       ARE COMPRESSED TO FORM AN NW BY NT COMPLEX MATRIX IN THE FIRST *
C       2*NW*NT WORDS OF X.  THE REMAINER OF X IS NOT USED ON OUTPUT.  *
C                                                                      *
C       THE FREQUENCY COMPONENTS ARE INDEXED 1, 2, ..., NS/2+1.  THE   *
C       NS/2+1 COMPONENT (NYQUIST FREQUENCY) IS DISCARDED.  THUS, THE  *
C       VALID RANGE FOR IW1 IS FROM 1 TO NS/2 AND THE VALID RANGE FOR  *
C       NW IS FROM 1 TO NS/2-IW1+1.                                    *
C                                                                      *
C       IF THE INVERSE FFT IS SELECTED, THEN THE INVERSE PROCESS IS    *
C       PERFORMED.  THE INPUT DATA IS AN NW BY NT COMPLEX MATRIX IN    *
C       X.  THE INPUT DATA IS EXPANDED IN-PLACE TO FORM AN NS/2 BY NT  *
C       COMPLEX MATRIX WITH ZEROS INSERTED FOR THE MISSING FREQUENCY   *
C       COMPONENTS.  A COMPLEX TO REAL INVERSE FFT IS PERFORMED ON     *
C       EACH COLUMN OF THE EXPNDED MATRIX TO PRODUCE AN NS BY NT REAL  *
C       OUTPUT MATRIX.                                                 *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CRAY SCILIB: CRFFT2, RCFFT2                                    *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF ANY ONE OF THE PARAMETERS IW1, NW, NS, OR NT HAS A VALUE    *
C       OUTSIDE ITS VALID RANGE (SEE ABOVE), THEN THE APPROPRIATE      *
C       COMPLETION CODE IS SET (SEE ABOVE) AND THE PROCESS IS ABORTED. *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      RCFFT2 -                                                        *
C      VSMUL  -                                                        *
C      CRFFT2 -                                                        *
C      VCLR   -                                                        *
C      VMOV   -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RFFT2MTC  REAL FFT - LOOPING BY COLUMN         REL 2.0  FEB 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RFFT2MTC (X, IDIR, IW1, NW, NS, NT, WRK, IERR)
      ENTRY      XRFFT    (X, IDIR, IW1, NW, NS, NT, WRK, IERR)
C
      REAL X(*), WRK(*)
C
      DATA MINNS, MAXNS / 16, 16384 /
C
C---------------------------------------------------------------------
C
C
      MS = MINNS
  110 CONTINUE
         IF (MS .LT. NS) THEN
            MS = MS + MS
            GO TO 110
         ENDIF
C
      MAXW  = MS / 2
      IERR = 0
      IF (IW1 .LT. 1 .OR. IW1 .GT. MAXW      ) IERR = IERR + 1
      IF (NW  .LT. 1 .OR. NW  .GT. MAXW-IW1+1) IERR = IERR + 2
      IF (NS .LT. MINNS .OR. NS .GT. MAXNS .OR. NS .NE. MS)
     &   IERR = IERR + 4
      IF (NT .LE. 0) IERR = IERR + 8
C
      IF (IERR .NE. 0) GO TO 800
C
      NW2 = 2 * NW
      IW  = NS + 3
      JW  = 2 * IW1 - 1
CTPC  KW  = JW + NW2 - 1
C
      IF (IDIR .LT. 0) GO TO 300
C
      SCALE = 1.0 / FLOAT( 2 * NS )
      CALL RCFFT2 (1, -1, NS, WRK, WRK(IW), WRK)
C
      JX1 = 1 - NS
      KX2 = 0
      DO 220 J = 1, NT
         JX1 = JX1 + NS
         JX2 = KX2 + 1
         KX2 = KX2 + NW2
         CALL RCFFT2 (0, -1, NS, X(JX1), WRK(IW), WRK)
CTPC     X(JX2:KX2) = SCALE * WRK(JW:KW)
         CALL VSMUL( WRK(JW), 1, SCALE, X(JX2), 1, NW2 )
  220 CONTINUE
      GO TO 800
C
  300 CONTINUE
      CALL CRFFT2 (1, 1, NS, WRK, WRK(IW), WRK)
CTPC  WRK(1:NS+2) = 0.0
      CALL VCLR( WRK, 1, NS+2 )
C
      JX1 = 1 + NT * NW2
      JX2 = 1 + NT * NS
      DO 320 J = 1, NT
         KX1 = JX1 - 1
         JX1 = JX1 - NW2
         JX2 = JX2 - NS
CTPC     WRK(JW:KW) = X(JX1:KX1)
         CALL VMOV( X(JX1), 1, WRK(JW), 1, NW2 )
         CALL CRFFT2 (0, 1, NS, WRK, WRK(IW), X(JX2))
  320 CONTINUE
C
  800 CONTINUE
      RETURN
      END
 
