C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RFFTMM                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES NT REAL TO COMPLEX FORWARD FFT'S OR NT COMPLEX TO     *
C       REAL INVERSE FFT'S.                                            *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RFFTMMTC  (X,IDIR,IW1,NW,NS,NT,WRK,IERR)                        *
C      XRFFT2  (X,IDIR,IW1,NW,NS,NT,WRK,IERR)                          *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C      IW1     INTEGER  ??IOU*      -                                  *
C      NW      INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      NT      INTEGER  ??IOU*      -                                  *
C      WRK     REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUN 88          R.D. COLEMAN, QTC      *
C       REL 2.0                 FEB 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL RFFTMMTC (X, IDIR, IW1, NW, NS, NT, WRK, IERR)            *
C       CALL XRFFT2   (X, IDIR, IW1, NW, NS, NT, WRK, IERR)            *
C                                                                      *
C  PARAMETERS:                                                         *
C       X       REAL/COMPLEX INPUT/OUTPUT ARRAY OF LENGTH NS*NT + 3*NT *
C               FOR FORWARD FFT'S, X CONTAINS AN NS BY NT REAL MATRIX  *
C               ON INPUT AND AN NW BY NT COMPLEX MATRIX ON OUTPUT.     *
C               FOR INVERSE FFT'S, X CONTAINS AN NW BY NT COMPLEX      *
C               MATRIX ON INPUT AND AN NS BY NT REAL MATRIX ON OUTPUT. *
C               AN ADDITIONAL 3*NT WORDS ARE REQUIRED AT THE END OF THE*
C               MATRIX FOR WORK SPACE.                                 *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR.                                  *
C               FFT DIRECTION SWITCH: IDIR >= 0 FOR FORWARD FFT'S AND  *
C               IDIR < 0 FOR INVERSE FFT'S.                            *
C                                                                      *
C       IW1     INTEGER INPUT SCALAR.                                  *
C               INDEX OF FIRST FREQUENCY COMPONENT.  IW1 MUST BE       *
C               BETWEEN 1 AND NS/2.                                    *
C                                                                      *
C       NW      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF FREQUENCY COMPONENTS.  NW MUST BE BETWEEN    *
C               0 AND NS/2-IW1+1.                                      *
C                                                                      *
C       NS      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF REAL ELEMENTS PER TRACE.  NS MUST BE A NUMBER*
C               OF THE FORM 2**I * 3**J * 5**K, WHERE I IS A POSITIVE  *
C               INTEGER AND J AND K ARE NON-NEGATIVE INTEGERS.         *
C                                                                      *
C       NT      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF TRACES.                                      *
C                                                                      *
C       WRK     REAL SCRATCH VECTOR OF LENGTH 2*NS*(NT+1)              *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR.                                 *
C               COMPLETION CODE.  IERR = 0 FOR NORMAL COMPLETION;      *
C               OTHERWISE, IT IS SET TO THE SUM OF THE CONDITION CODES *
C               THAT APPLY.  THE CONDITION CODE VALUES ARE:            *
C                  1 - THE VALUE OF IW1 IS INVALID                     *
C                  2 - THE VALUE OF NW  IS INVALID                     *
C                  4 - THE VALUE OF NS  IS INVALID                     *
C                  8 - THE VALUE OF NT  IS INVALID                     *
C                                                                      *
C  DESCRIPTION:                                                        *
C       IF THE FORWARD FFT IS SELECTED, THEN RFFTMMTC PERFORMS A REAL T*
C       COMPLEX FORWARD FFT ON NT TRACES EACH OF LENGTH NS.  THE NT    *
C       TRACES ARE STORED AS COLUMNS OF AN NS BY NT REAL MATRIX X.     *
C       ONLY THE FREQUENCY COMPONENTS OF THE RESULTS THAT ARE SELECTED *
C       BY IW1 AND NW ARE STORED BACK INTO X.  THE SELECTED RESULTS    *
C       ARE COMPRESSED TO FORM AN NW BY NT COMPLEX MATRIX IN THE FIRST *
C       2*NW*NT WORDS OF X.  THE REMAINER OF X IS NOT USED ON OUTPUT.  *
C                                                                      *
C       THE FREQUENCY COMPONENTS ARE INDEXED 1, 2, ..., NS/2+1.  THE   *
C       NS/2+1 COMPONENT (NYQUIST FREQUENCY) IS DISCARDED.  THUS, THE  *
C       VALID RANGE FOR IW1 IS FROM 1 TO NS/2 AND THE VALID RANGE FOR  *
C       NW IS FROM 1 TO NS/2-IW1+1.                                    *
C                                                                      *
C       IF THE INVERSE FFT IS SELECTED, THEN THE INVERSE PROCESS IS    *
C       PERFORMED.  THE INPUT DATA IS AN NW BY NT COMPLEX MATRIX IN    *
C       X.  THE INPUT DATA IS EXPANDED IN-PLACE TO FORM AN NS/2 BY NT  *
C       COMPLEX MATRIX WITH ZEROS INSERTED FOR THE MISSING FREQUENCY   *
C       COMPONENTS.  A COMPLEX TO REAL INVERSE FFT IS PERFORMED ON     *
C       EACH COLUMN OF THE EXPNDED MATRIX TO PRODUCE AN NS BY NT REAL  *
C       OUTPUT MATRIX.                                                 *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       MATH ADVANTAGE: VCLR, VMOV                                     *
C       CRAY SCILIB   : FFTFAX, RFFTMLT                                *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF ANY ONE OF THE PARAMETERS IW1, NW, NS, OR NT HAS A VALUE    *
C       OUTSIDE ITS VALID RANGE (SEE ABOVE), THEN THE APPROPRIATE      *
C       COMPLETION CODE IS SET (SEE ABOVE) AND THE PROCESS IS ABORTED. *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      NRFFT5  INTEGER -                                               *
C      FFTFAX          -                                               *
C      VMOV            -                                               *
C      RFFTML          -                                               *
C      VCLR            -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RFFTMMTC  REAL FFT - LOOPING BY COLUMN         REL 2.0  FEB 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE RFFTMMTC (X, IDIR, IW1, NW, NS, NT, WRK, IERR)
      ENTRY      XRFFT2   (X, IDIR, IW1, NW, NS, NT, WRK, IERR)
C
      REAL    X(*), WRK(*)
      INTEGER IDIR, IW1, NW, NS, NT, IERR, IFAC(19)
C
C---------------------------------------------------------------------
C
C=======================================================================
C                          INITIALIZATION
C=======================================================================
C
C  VALIDATE PARAMETERS
C
      MS = NRFFT5( NS )
C
      MAXW  = MS / 2
      IERR = 0
      IF (IW1 .LT. 1 .OR. IW1 .GT. MAXW      ) IERR = IERR + 1
      IF (NW  .LT. 1 .OR. NW  .GT. MAXW-IW1+1) IERR = IERR + 2
      IF (NS .NE. MS) IERR = IERR + 4
      IF (NT .LE.  0) IERR = IERR + 8
C
      IF (IERR .NE. 0) GO TO 800
C
C  GET FACTORS OF NS AND CORRESPONDING TRIG TABLES
C
      CALL FFTFAX (NS, IFAC, WRK)
C
      NW2 = NW + NW
      IW  = NS + NS + 1
      LS  = NS + 3
C
C  SELECT FORWARD OR INVERSE TRANSFORM PATH
C
      IF (IDIR .LT. 0) GO TO 300
C
C=======================================================================
C                          FORWARD TRANSFORM
C=======================================================================
C
C  EXPAND MATRIX TO CREATE THREE EXTRA WORDS AT THE END OF COLUMN
C
      IF (NT .GT. 1) THEN
         K1 = NS * NT
         K2 = LS * (NT - 1) + NS
         DO 210 J = NT, 2, -1
            CALL VMOV (X(K1), -1, X(K2), -1, NS)
            K1 = K1 - NS
            K2 = K2 - LS
  210    CONTINUE
      ENDIF
C
C  PERFORM FORWARD FFT
C
      CALL RFFTMLT (X, WRK(IW), WRK, IFAC, 1, LS, NS, NT, -1)
C
C  COMPRESS MATRIX TO KEEP ONLY ELEMENTS SELECTED BY IW1 AND NW
C
      K1 = IW1 + IW1 - 1
      K2 = 1
      DO 220 J = 1, NT
         CALL VMOV (X(K1), 1, X(K2), 1, NW2)
         K1 = K1 + LS
         K2 = K2 + NW2
  220 CONTINUE
C
      GO TO 800
C
C=======================================================================
C                          INVERSE TRANSFORM
C=======================================================================
C
  300 CONTINUE
C
C  EXPAND MATRIX AND ZERO PAD
C
      N1 = 2 * (IW1 - 1)
      N2 = NS + 2 - N1 - NW2
      K1 = NW2 * NT
      K2 = LS * (NT - 1) + N1 + NW2
      L2 = K2 + 1
      L1 = L2 - N1 - NW2
      DO 310 J = NT, 1, -1
         CALL VMOV (X(K1), -1, X(K2), -1, NW2)
         CALL VCLR (X(L1), 1, N1)
         CALL VCLR (X(L2), 1, N2)
         K1 = K1 - NW2
         K2 = K2 - LS
         L1 = L1 - LS
         L2 = L2 - LS
  310 CONTINUE
C
C  PERFORM INVERSE FFT
C
      CALL RFFTMLT (X, WRK(IW), WRK, IFAC, 1, LS, NS, NT, 1)
C
C  COMPRESS MATRIX TO DELETE THE THREE WORDS AT THE END OF EACH COLUMN
C
      IF (NT .GT. 1) THEN
         K1 = 1 + LS
         K2 = 1 + NS
         DO 320 J = 2, NT
            CALL VMOV (X(K1), 1, X(K2), 1, NS)
            K1 = K1 + LS
            K2 = K2 + NS
  320    CONTINUE
      ENDIF
C
C=======================================================================
C                          EXIT SUBROUTINE
C=======================================================================
C
  800 CONTINUE
      RETURN
      END
 
