C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       WRPICK                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Write an 'xsd' pick file which consists of a 'Units' card      *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C  ENTRY POINTS:                                                       *
C      WRPICK  (REC,TRAC,SAMP,COLOR,NAME,NPICKS,UNITS,OFFSET,NREC,     *
C               NTRAC,NSAMP,JSEG,MAXPIK,LPRT,LPOUT,JERR)               *
C  ARGUMENTS:                                                          *
C      REC     REAL     ??IOU*  (*) -                                  *
C      TRAC    REAL     ??IOU*  (*) -                                  *
C      SAMP    REAL     ??IOU*  (*) -                                  *
C      COLOR   INTEGER  ??IOU*  (*) -                                  *
C      NAME    CHAR*20  ??IOU*  (*) -                                  *
C      NPICKS  INTEGER  ??IOU*  (*) -                                  *
C      UNITS   REAL     ??IOU*  (*) -                                  *
C      OFFSET  REAL     ??IOU*  (*) -                                  *
C      NREC    INTEGER  ??IOU*      -                                  *
C      NTRAC   INTEGER  ??IOU*      -                                  *
C      NSAMP   INTEGER  ??IOU*      -                                  *
C      JSEG    INTEGER  ??IOU*      -                                  *
C      MAXPIK  INTEGER  ??IOU*      -                                  *
C      LPRT    INTEGER  ??IOU*      -                                  *
C      LPOUT   INTEGER  ??IOU*      -                                  *
C      JERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 92/02/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C  REVISED:  Mary Ann Thornton  October 5, l992                        *
C            changed a format statment to read new xsd formatted picks *
C            This version does not write the name of the segments or   *
C            the number of picks per segment.                          *
C  REVISED:  Mary Ann Thornton  December l6, 1992                      *
C            Rewrite the subroutine to write the new improved xsd      *
C            formatted picks with the number of segments and maximum   *
C            number of picks on the Units card                         *
C            and the names of the segments                             *
C            To use this subroutine, the picks must have been read in  *
C            with subroutine rdpick.F (from this same library)         *
C  CALLING FORMAT:                                                     *
C       call wrpick(rec,trac,samp,color,name,npicks,units,offset,      *
C    &              nrec,ntrac,nsamp,jseg,maxpik,lprt,lpout,jerr)      *
C                                                                      *
C  PARAMETERS:                                                         *
C    rec       Input real one-dimensional array of x points            *
C                                                                      *
C    trac      Input real one-dimensional array of y points            *
C                                                                      *
C    samp      Input real one-dimensional array of z points            *
C                                                                      *
C    color     Integer array of segment colors                         *
C                                                                      *
C    name      Input Character*20 array length 1000 containing         *
C              segment names                                           *
C                                                                      *
C    npicks    Integer input array of length 1000                      *
C               npicks(1) = the number of points in segment one        *
C               npicks(2) = the number of points in segment two, etc.  *
C                                                                      *
C    units     Real input array of length 3                            *
C              units(1) = Units measure for the x points               *
C              units(2) = Units measure for the y points               *
C              units(3) = Units measure for the z points               *
C                                                                      *
C    offset    Real input array of length 3                            *
C              offset(1) = offset measure for the x points             *
C              offset(2) = offset measure for the y points             *
C              offset(3) = offset measure for the z points             *
C                                                                      *
C    nrec      Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    ntrac     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    nsamp     Integer input scalar                                    *
C              No. records in original 'picked' dataset                *
C                                                                      *
C    jseg      Integer input scalar                                    *
C              Number of segments in the picks file                    *
C                                                                      *
C    maxpik    Integer output scalar                                   *
C              Maximum number of picks in any one segment              *
C                                                                      *
C    lprt      Integer input scalar                                    *
C              Logical unit of print out                               *
C                                                                      *
C    lpout     Integer input scalar                                    *
C              Logical unit of pick file                               *
C                                                                      *
C    jerr      Integer input/output scalar                             *
C              Error flag                                              *
C                                                                      *
C  DESCRIPTION:  This routine writes an 'xsd' pick file given          *
C      arrays containing the x, y, and z points and color for          *
C      each segment.                                                   *
C                                                                      *
C  SUBPROGRAMS CALLED:  None                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr =250  =   Error writing picks file                         *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LPOUT  ( OUTPUT SEQUENTIAL ) -                                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: WRPICK    WRITE PICKS                          REV 2.0  DEC 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine wrpick(rec,trac,samp,color,name,npicks,units,offset,
     &                  nrec,ntrac,nsamp,jseg,maxpik,lprt,lpout,jerr)
C
      integer npicks(*),color(*)
      character*20 name(*)
      real rec(*),trac(*),samp(*)
      real units(*),offset(*)
      character*6 uword
      character*7 oword
      character*6 cword
      data uword/'Units '/
      data oword/'Offset '/
      data cword/'Count '/
 
      jerr = 0
   50 format(a6,3(f12.3,1x),3(i5,1x),a7,3(f12.3,1x),a6,i5,1x,i5)
      write(lpout,50,err=350)uword,units(1),units(2),units(3),
     &nrec,ntrac,nsamp,oword,offset(1),offset(2),offset(3),cword,
     &jseg,maxpik
  100 format(2(f12.3,1x),f12.3)
      knt = 0
      do 300 j=1,jseg
         write(lpout,60,err=350)j,name(j),color(j),npicks(j)
   60    format('Segment = ',i5,' Name ',a20,'  color = ',i5,
     &          ' picks = ',i5)
         do 250 n=1,npicks(j)
            knt = knt + 1
            write(lpout,100,err=350)rec(knt),trac(knt),samp(knt)
  250    continue
  300 continue
      return
  350 write(lprt,*)' Error encountered writing picks file'
      jerr = 250
      return
      end
