C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C***********************************************************************
      subroutine pmprnt(a,mxrow,nr,nc,iounit)
C
c     print out amplitude and phase of a complex matrix.
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      real a(2,mxrow,nc)
      real amp(4),phase(4)
      parameter (degprad=180./3.1415926)
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      do 30 j=1,nc,4
         jh=min(j+3,nc)
         write(iounit,'(//,8x,4i15)') (n,n=j,jh)
         write(iounit,'(68a1)') ('=',m=1,68)
         do 30 i=1,nr
            ka=0
            do 25 k=j,jh
             ka=ka+1
             amp(ka)=sqrt(a(1,i,k)**2+a(2,i,k)**2)
             if(a(1,i,k) .eq. 0. .and. a(2,i,k) .eq. 0.) then
                phase(ka)=0.
             else
                phase(ka)=atan2(a(2,i,k),a(1,i,k))*degprad
             endif
25          continue
            write(iounit,'(8x,4e15.6)') (amp(k),k=1,ka)   
            write(iounit,'(1x,i4,3x,4f15.6)') i,(phase(k),k=1,ka) 
            write(iounit,'(68a1)') ('=',m=1,68)
30    continue
c
      return
      end
