%{
/*

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "Panel.h"

extern Widget text(Attribute *);
extern Widget toggle(Attribute *);
extern Widget slider(Attribute *);
extern Widget filebox(Attribute *);

extern void tab_space(int);
extern void space(int);
extern void char_space(int);
extern void start_frame();
extern void end_frame();
extern void label(char *);
extern void separator();

extern Panel *item=NULL;

void reset();

static Attribute *attribute=NULL;
static int radiobox_flag=0;

/*
int yydebug=1;
*/
%}
%union {
  int i;
  float r;
  char *s;
}

%token XUI_FILE

%token P_MOD P_EXEC P_LIB P_HELP P_INPUT P_OUTPUT P_DIAG
%token LABEL TEXT FILEBOX TOGGLE RADIOBUTTON SLIDER LIST
%token CHAR TAB SET_X SET_Y SPACE BLANK_LINE SEPARATOR
%token RADIOBOX FRAME
%token NAME COLUMNS ROWS VARIABLE HORIZONTAL VERTICAL DEFAULT HELP
%token TYPE MIN MAX POSITION
%token STICKY SOCKET STDIN STDOUT 

%token LB RB

%token <s> STRING 

%%

pattern
  : compound_program compound_statement
  | compound_program
  ;

compound_program
  : program
  | compound_program program
  ;

program
  : XUI_FILE         { }
  | P_LIB STRING     { item->program_library=strdup($2); }
  | P_MOD STRING     { item->program_mod=strdup($2); }
  | P_EXEC STRING    { item->program_exec=strdup($2); }
  | P_HELP STRING    { item->program_help=strdup($2); }
  | P_INPUT STRING 
  | P_OUTPUT STRING 
  | P_DIAG STRING 
  ;

compound_statement
  : statement
  | compound_statement statement
  ;

statement
  : LABEL  STRING    { label($2); }
  | widget LB compound_attribute RB { switch (attribute->widget_type) {
                                        case TEXT_WIDGET:
                                          attribute->w=text(attribute); 
					  reset();
					  break;
                                        case FILEBOX_WIDGET:
                                          attribute->w=filebox(attribute);
					  reset();
					  break;
                                        case SLIDER_WIDGET:
                                          attribute->w=slider(attribute);
					  reset();
					  break;
					case TOGGLE_WIDGET:
					  attribute->w=toggle(attribute); 
					  reset();
					  break;
					case RADIOBUTTON_WIDGET:
					  attribute->w=toggle(attribute); 
					  line_feed();
					  reset();
					  break;
					}
				    }
  | FRAME                     { radiobox_flag=0; start_frame(); }
  | RADIOBOX                  { radiobox_flag=1; start_radio(); }
  | LB compound_statement RB  { if (radiobox_flag) 
				  end_radio(); 
                                else 
				  end_frame(); }
  | SPACE STRING  { space(atoi($2)); }
  | SPACE         { space(1); }
  | TAB STRING    { tab_space(atoi($2)); }
  | TAB           { tab_space(1); }
  | CHAR STRING   { char_space(atoi($2)); }
  | CHAR          { char_space(1); }
  | SET_X STRING  { set_x(atoi($2)); }
  | SET_Y STRING  { set_y(atoi($2)); }
  | SEPARATOR     { separator(); }
  ;

widget
  : TEXT        { attribute->widget_type=TEXT_WIDGET; }
  | FILEBOX     { attribute->widget_type=FILEBOX_WIDGET; }
  | SLIDER      { attribute->widget_type=SLIDER_WIDGET; }
  | TOGGLE      { attribute->widget_type=TOGGLE_WIDGET; }
  | RADIOBUTTON { attribute->widget_type=RADIOBUTTON_WIDGET; }
  ;

compound_attribute
  : attribute
  | compound_attribute attribute

attribute
  : COLUMNS  STRING  { sscanf($2,"%d",&attribute->columns); }
  | ROWS     STRING  { sscanf($2,"%d",&attribute->rows); }
  | VARIABLE STRING  { attribute->variable=strdup($2); 
		       if (xui_trace_flag_internal)
			 fprintf(stderr,"%s\n",$2); }
  | DEFAULT  STRING  { attribute->default_value=strdup($2); }
  | HELP     STRING  { attribute->help=strdup($2); }
  | NAME     STRING  { attribute->name=strdup($2); }
  | POSITION STRING  { strcpy(attribute->position,$2); }
  | HORIZONTAL       { attribute->orientation=XmHORIZONTAL; }
  | VERTICAL         { attribute->orientation=XmVERTICAL; }
  | STICKY           { attribute->sticky=True; }
  | SOCKET           { attribute->socket=True; }
  | STDIN            { attribute->stdin_flag=True; }
  | STDOUT           { attribute->stdout_flag=True; }
  | MIN      STRING  { strcpy(attribute->min_value,$2); }
  | MAX      STRING  { strcpy(attribute->max_value,$2); }
  | TYPE     STRING  { if (strcmp($2,"Integer")==0) 
			 attribute->type=INTEGER;
		       if (strcmp($2,"Float")==0)
			 attribute->type=FLOAT;
		       if (strcmp($2,"String")==0)
			 attribute->type=STRING;
		     }
  ;


%%

void reset()
{
  attribute->next=(Attribute *)malloc(sizeof(Attribute));
  attribute=attribute->next;
  attribute->next=NULL;

  attribute->widget_type=0;
  attribute->rows=1;
  attribute->columns=20;
  attribute->socket=False;
  attribute->sticky=False;
  strcpy(attribute->min_value,"");
  strcpy(attribute->max_value,"");
  strcpy(attribute->position,"");
  attribute->type=0;
  attribute->name=strdup("");
  attribute->variable=strdup("");
  attribute->default_value=strdup("");
  attribute->help=strdup("");
  attribute->orientation=XmHORIZONTAL;
  attribute->stdin_flag=False;
  attribute->stdout_flag=False;
}

Panel *add_item()
{
  attribute=(Attribute *)malloc(sizeof(Attribute));
  attribute->next=NULL;


  attribute->widget_type=0;
  attribute->rows=1;
  attribute->columns=20;
  attribute->socket=False;
  attribute->sticky=False;
  strcpy(attribute->min_value,"");
  strcpy(attribute->max_value,"");
  strcpy(attribute->position,"");
  attribute->type=0;
  attribute->name=strdup("");
  attribute->variable=strdup("");
  attribute->default_value=strdup("");
  attribute->help=strdup("");
  attribute->orientation=XmHORIZONTAL;
  attribute->stdin_flag=False;
  attribute->stdout_flag=False;

  item=(Panel *)malloc(sizeof(Panel));
  item->attribute=attribute;
  item->program_library=NULL;
  item->program_mod=NULL;
  item->program_exec=NULL;
  item->program_help=NULL;

  return item;
}

 
void mark_line()
{
}




