/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
	This routine lets Fortran programs find out whether
        they can read, write, or both on a SISIO file.
						- Joe Dellinger
						Jan 13 1995
*/

#include <stdio.h>
#include <localsys.h>
#include <io_defs.h>
#include <sisio.h>
#include <ut_defs.h>

#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>


#ifndef F_LUCRW
#define F_LUCRW lucrw_
#endif


void
F_LUCRW (lu, canread, canwrite)
     int *lu, *canread, *canwrite;
{
fitentry fit;			/* defined in sisio.h */

    C_SISINFO (*lu, &fit);

    switch (fcntl (fit.filedes, F_GETFL, 0))
      {
      case O_RDONLY:
	  *canread = 1;
	  *canwrite = 0;
	  break;
      case O_WRONLY:
	  *canread = 0;
	  *canwrite = 1;
	  break;
      case O_RDWR:
	  *canread = 1;
	  *canwrite = 1;
	  break;
      case -1:
      default:
	  *canread = 0;
	  *canwrite = 0;
	  break;
      }
}
