C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      function uspclose(icon)
c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Close input/output number icon.
c
c return value:
c     0: normal
c    -1: something went wrong
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icon, uspclose

      integer nblen, usprwtrace, usppass

      integer icomp, mcomp, luno

      integer oldn3, newn3
      integer    slheader(SZLNHD)
      integer    slhedlength

      character  rname*(*)
      parameter (rname = 'uspclose()')
 
#include "uspinfo.h"



      uspclose = 0


#ifdef DEBUG
          write (LERR,*)
     1    'Closing connection ', icon, '.'
#endif


      if (icon .le. 0 .or. icon .gt. curcon) then
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon, ' not opened.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon, ' not opened.'

          uspclose = -1
          return
      endif

      if (lustatus(icon) .eq. IO_NOK) then
c
c Oops! Something's wrong!
c
          write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif
          write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Connection ', icon,
     1        ' is not open. Cannot be accessed.'
 
          uspclose = -1
          return
      endif

      if (cinput(icon) .gt. 0) then
          if (lustatus(cinput(icon)) .ne. IO_NOK) then

              write (LERR,*) name(1:nblen(name)), ' ', rname,
     1        ': Cannot close output ', icon,
     1        ' until corresponding input ', cinput(icon),
     1        ' has first been closed.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write (LER ,*) name(1:nblen(name)), ' ', rname,
     1        ': Cannot close output ', icon,
     1        ' until corresponding input ', cinput(icon),
     1        ' has first been closed.'

              uspclose = -1
              return

          endif
      endif


c
c    Finish up any traces left to pass-through.
c

      if (canread(icon) .ne. 0 .and. ipass(icon) .ne. 0 .and.
     1                                         uspclose .eq. 0) then
 
          uspclose = usppass(icon, vn2(icon) * vn3(icon) + 1)
 
      endif


c
c    Flush the output
c

      if (canwrite(icon) .ne. 0 .and. uspclose .eq. 0) then
          uspclose = usprwtrace(icon, FLUSH, nulltrace, 0, 0)

          if (uspclose .ne. 0) then

              write (LERR,*) name(1:nblen(name)), ' ', rname,
     1                ': Warning, unable to flush output ', icon, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              write (LER ,*) name(1:nblen(name)), ' ', rname,
     1                ': Warning, unable to flush output ', icon, '.'

          endif
      endif


      if (lumax(icon) .ne. n2(icon) * n3(icon)) then

          if (append(icon) .eq. 0) then

c
c    There is a problem with this file.
c
              uspclose = 1

              if (lumax(icon) .lt. n2(icon) * n3(icon)) then

                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning, output ', icon,
     1            ' is smaller than expected.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning, output ', icon,
     1            ' is smaller than expected.'

              else

                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning, output ', icon,
     1            ' is larger than expected.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning, output ', icon,
     1            ' is larger than expected.'

              endif

          else
c
c    We have appended some traces onto the end, or perhaps not
c    written as many as we originally promised. But that's OK,
c    we've opened the file for appending so we'll fix the line header
c    instead of complaining.
c

c
c    First, make sure we have an integer number of gathers
c

              if (lumax(icon) .ne.
     1              n2(icon) * int(lumax(icon) / n2(icon))) then

                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning: incomplete gather at end of',
     1            ' output ', icon, '.'
                  write (LERR,*) name(1:nblen(name)), ' ', rname,
     1            ': Line header will NOT be updated.'
#ifdef SUNSYSTEM
                  call flush(LERR)
#endif
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Warning: incomplete gather at end of',
     1            ' output ', icon, '.'
                  write (LER ,*) name(1:nblen(name)), ' ', rname,
     1            ': Line header will NOT be updated.'

              else

c
c    If all is well, then update the line header
c

                  newn3 = lumax(icon) / n2(icon)


                  if (canread(icon) .eq. 0 .or.
     1                                   canwrite(icon) .eq. 0) then

                      write (LERR,*) name(1:nblen(name)), ' ', rname,
     1                ': Warning, unable to update line header',
     1                ' for connection ', icon, ';'
                      write (LERR,*) name(1:nblen(name)), ' ', rname,
     1                ': New NumRec should be ', newn3, '.'
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
                      write (LER ,*) name(1:nblen(name)), ' ', rname,
     1                ': Warning, unable to update line header',
     1                ' for connection ', icon, ';'
                      write (LER ,*) name(1:nblen(name)), ' ', rname,
     1                ': New NumRec should be ', newn3, '.'


                  else


                      if (multiin(icon) .eq. MI_PIPE .and.
     1                                            nc(icon) .gt. 0) then
                          mcomp = 1
                      else
                          mcomp = nc(icon)
                      endif
 

                      do icomp = 1, mcomp

                          luno =
     1 LUIOMC(icomp,icon)

#ifdef DEBUG
                          write (LERR,*)
     1                    'Updating header icomp ', icomp,
     1                    ', lu ', luno, ',',
     1                    ' file ', '''',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1                    '''.'
#endif

                          if (luno .ge. 0) then

c    Seek to the beginning
                              call rwd (luno)

c    Read the line header
                              call rtape  (luno, slheader, slhedlength)

#ifdef DEBUG
                              write (LERR,*) 'Read ', slhedlength,
     1                        ' bytes of line header.'
#endif

                              if (slhedlength .le. 0) then
                                  write (LERR, *) name(1:nblen(name)),
     1                            ' ', rname,
     1                            ': Could not read line header from ',
     1                            '''',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1                            ''''
#ifdef SUNSYSTEM
                                  call flush(LERR)
#endif
                                  write (LER , *) name(1:nblen(name)),
     1                            ' ', rname,
     1                            ': Could not read line header from ',
     1                            '''',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1                            ''''
                                  goto 100
                              endif

c    Update the line header
                              call saver(slheader,
     1                             'NumRec', oldn3, LINEHEADER)
                              call savew(slheader,
     1                             'NumRec', newn3, LINEHEADER)

c    Seek back to the beginning again
                              call rwd (luno)

c    Write it back out
                              call wrtape  (luno, slheader, slhedlength)

                              write (LERR, *) name(1:nblen(name)),
     1                        ' ', rname,
     1                        ': Updated line header keyword NumRec '
                              write (LERR, *) '     in file ',  '''',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1                        '''', ' from ', oldn3, ' to ', newn3, '.'

                          endif

 100                  continue
                      enddo

                  endif

              endif

          endif

      else if (append(icon) .ne. 0) then

          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': Warning: despite having been opened for appending,',
     1    ' file ', icon, ' is no bigger than it was before.'
#ifdef SUNSYSTEM
          call flush(LERR)
#endif

      endif


c
c    Deallocate any associated trace transpose buffer.
c

      call usptbf(icon)


c
c    Finally, close all the files!
c

      if (multiin(icon) .eq. MI_PIPE .and. nc(icon) .gt. 0) then
          mcomp = 1
      else
          mcomp = nc(icon)
      endif
 
          write (LERR, *) name(1:nblen(name)), ' ', rname,
     1    ': Closing connection ', icon, ':'


      do icomp = 1, mcomp

          luno =
     1 LUIOMC(icomp,icon)

          write (LERR, *)
     1    '     comp. ', icomp, ', unit ', luno, ',',
     1    ' file ', '''',
     1 FINAME(icomp,icon)
     1 (1:nblen(FINAME(icomp,icon))),
     1    '''.'

          if (luno .ge. 0) then
              call lbclos ( luno )
          endif

      enddo


c
c    This connection is no longer open. IO on it is now Not OK!
c
      lustatus(icon) = IO_NOK


      return

      end
